/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.INamedFieldDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUnitDataSourceRecord;

public class UnitDataSourceRecordImpl
implements IUnitDataSourceRecord {
    private final INamedFieldDataSourceRecord m_record;
    private final String m_lowUnitFieldKey;
    private final String m_highUnitFieldKey;
    private final String m_unitTypeFieldKey;
    private final String m_placeNameFieldKey;

    public UnitDataSourceRecordImpl(INamedFieldDataSourceRecord record, String lowUnitFieldKey, String highUnitFieldKey, String unitTypeFieldKey, String placeNameFieldKey) {
        this.m_record = record;
        this.m_lowUnitFieldKey = lowUnitFieldKey;
        this.m_highUnitFieldKey = highUnitFieldKey;
        this.m_unitTypeFieldKey = unitTypeFieldKey;
        this.m_placeNameFieldKey = placeNameFieldKey;
    }

    @Override
    public boolean hasLowUnit() throws DataSourceException {
        return this.m_record.hasField(this.m_lowUnitFieldKey);
    }

    @Override
    public String getLowUnit() throws DataSourceException {
        String fieldName = this.m_record.getFieldName(this.m_lowUnitFieldKey);
        if (fieldName != null) {
            return this.m_record.getFieldStringValue(fieldName);
        }
        return null;
    }

    @Override
    public boolean hasHighUnit() throws DataSourceException {
        return this.m_record.hasField(this.m_highUnitFieldKey);
    }

    @Override
    public String getHighUnit() throws DataSourceException {
        String fieldName = this.m_record.getFieldName(this.m_highUnitFieldKey);
        if (fieldName != null) {
            return this.m_record.getFieldStringValue(fieldName);
        }
        return null;
    }

    @Override
    public boolean hasUnitType() throws DataSourceException {
        return this.m_record.hasField(this.m_unitTypeFieldKey);
    }

    @Override
    public String getUnitType() throws DataSourceException {
        String fieldName = this.m_record.getFieldName(this.m_unitTypeFieldKey);
        if (fieldName != null) {
            return this.m_record.getFieldStringValue(fieldName);
        }
        return null;
    }

    @Override
    public boolean hasPlaceName() throws DataSourceException {
        return this.m_record.hasField(this.m_placeNameFieldKey);
    }

    @Override
    public String getPlaceName() throws DataSourceException {
        String fieldName = this.m_record.getFieldName(this.m_placeNameFieldKey);
        if (fieldName != null) {
            return this.m_record.getFieldStringValue(fieldName);
        }
        return null;
    }
}

