/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataHandler;
import com.mapinfo.mapmarker.common.dp.PhaseProgressBounds;
import com.mapinfo.mapmarker.common.dp.PhaseProgressBoundsProvider;
import com.mapinfo.mapmarker.common.dp.ProgressBarUpdaterProvider;
import com.mapinfo.mapmarker.common.dp.UserCancelledRuntimeException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.DataFileStatistics;
import com.mapinfo.mapmarker.common.dp.binary.FrequentDataFileStrings;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.IDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataWriter;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeoInfoItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJPost2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJPostInfoItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJPostInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetBuilder;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.SacMetadata;
import com.mapinfo.mapmarker.common.dp.binary.StreetDataFileStatistics;
import com.mapinfo.mapmarker.common.dp.binary.StreetDataGroup;
import com.mapinfo.mapmarker.common.dp.binary.VendorDataType;
import com.mapinfo.mapmarker.common.dp.binary.index.BrowseInputIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.BrowseMultiValueNIOMultiLevelInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.dp.binary.index.IFileInnerIndexConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.IInputIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexMultiValueIndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.MultiLevelNIOInnerIndexConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.SacMiSoundexInputIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.SacMiSoundexKeyMultiValueNIOMultiLevelInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.SacMiSoundexKeySingleValueNIOMultiLevelInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.StandardPostInfoIndexFileConvertor;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public abstract class AbstractDataProvider
implements IDataProvider {
    protected static final int MAX_FREQUENT_STRINGS = 255;
    protected MMJDataWriter m_dataWriter = new MMJDataWriter(this);
    protected MMJStreetBuilder m_dataBuilder;
    protected Properties m_processProperties;
    protected List m_alternateIndexFiles = null;
    protected MultiSegmentStreet m_currentMultiStreet = null;
    protected FrequentDataFileStrings m_streetFrequentStrings;
    protected FrequentDataFileStrings m_geoinfoFrequentStrings;
    protected FrequentDataFileStrings m_postinfoFrequentStrings;
    protected IDataHandler m_streetDataHandler;
    protected IDataHandler m_postInfoDataHandler;
    protected IDataHandler m_geoInfoDataHandler;
    protected IDataHandler m_post2sacDataHandler;
    protected IDataHandler m_geo2sacDataHandler;
    private boolean m_forUserDictionary;
    private int m_vendordataType;
    private static final String KEY_VENDOR_CODE = "VENDOR_CODE";

    @Override
    public void initialize(Properties processingProperties) throws DataCreationException {
        this.m_processProperties = processingProperties;
        String vendorCode = processingProperties.getProperty(KEY_VENDOR_CODE);
        VendorDataType vendorTypeEnum = VendorDataType.ChangeDataSetInNumericValue((String)vendorCode);
        this.setVandorAndDataType(vendorTypeEnum.getDataType());
    }

    @Override
    public String getPostInfoFilePath() {
        return this.m_processProperties.getProperty("postInfo_outputFilePath");
    }

    public void setVandorAndDataType(int vendorAndDataType) {
        this.m_vendordataType = vendorAndDataType;
    }

    public int getVandorAndDataType() {
        return this.m_vendordataType;
    }

    @Override
    public String getGeoInfoFilePath() {
        return this.m_processProperties.getProperty("geoInfo_outputFilePath");
    }

    @Override
    public String getPost2SacFilePath() {
        return this.m_processProperties.getProperty("post2sac_outputFilePath");
    }

    @Override
    public String getGeo2SacFilePath() {
        return this.m_processProperties.getProperty("geo2sac_outputFilePath");
    }

    @Override
    public String getStreetFilePath() {
        return this.m_processProperties.getProperty("street_outputFilePath");
    }

    @Override
    public void processStreets(boolean createStatistics) throws DataCreationException {
        StreetDataFileStatistics.createStreetFileStatistics((boolean)true);
        try {
            this.m_dataWriter.processStreets(this.getStreetFileBaseName());
        }
        catch (OutOfMemoryError e) {
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(0, (Throwable)e);
        }
        catch (UserCancelledRuntimeException UCREx) {
            throw UCREx;
        }
        catch (RuntimeException e) {
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(100, (Throwable)e);
        }
        finally {
            if (DebugLevel.getDebugLevel((int)5) >= 1) {
                DataCreationLogger.getLogger().logMemoryUsage();
                DataCreationLogger.getLogger().logStatus("Closing street data handler.");
            }
            try {
                this.m_streetDataHandler.close();
            }
            catch (DataSourceException dataSourceException) {}
            if (DebugLevel.getDebugLevel((int)5) >= 1) {
                DataCreationLogger.getLogger().logMemoryUsageWithGC();
            }
        }
        if (createStatistics) {
            try {
                String statString = StreetDataFileStatistics.getStreetFileStatisticsObject().getStatistics();
                PrintStream statFile = new PrintStream(new FileOutputStream(StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)this.getStreetFileBaseName(), (String)".sts")));
                statFile.println(statString);
                statFile.close();
            }
            catch (IOException IOEx) {
                DataCreationLogger.getLogger().logStackTrace(IOEx);
            }
        }
    }

    @Override
    public void processGeoInfo(boolean createStatistics) throws DataCreationException {
        try {
            this.m_dataWriter.processGeoInfo(this.getGeoInfoFileBaseName());
            if (DebugLevel.getDebugLevel((int)5) >= 1) {
                DataCreationLogger.getLogger().logMemoryUsage();
                DataCreationLogger.getLogger().logStatus("Closing geoinfo data handler.");
            }
            this.m_geoInfoDataHandler.close();
            if (DebugLevel.getDebugLevel((int)5) >= 1) {
                DataCreationLogger.getLogger().logMemoryUsageWithGC();
            }
        }
        catch (RuntimeException e) {
            throw new DataCreationException(300, (Throwable)e);
        }
        catch (DataSourceException e) {
            throw new DataCreationException(301, (Throwable)e);
        }
        if (createStatistics) {
            DataFileStatistics.getStatisticsInstance().outputStatistics(StringUtilities.appendToPath((String)this.m_processProperties.getProperty("geoInfo_outputFilePath"), (String)this.m_processProperties.getProperty("geoInfo_outputFile")));
        }
    }

    @Override
    public void processGeo2Sac(boolean createStatistics) throws DataCreationException {
        try {
            this.m_dataWriter.processGeo2Sac();
            if (DebugLevel.getDebugLevel((int)5) >= 1) {
                DataCreationLogger.getLogger().logMemoryUsage();
                DataCreationLogger.getLogger().logStatus("Closing geo2sac data handler.");
            }
            this.m_geo2sacDataHandler.close();
            if (DebugLevel.getDebugLevel((int)5) >= 1) {
                DataCreationLogger.getLogger().logMemoryUsageWithGC();
            }
        }
        catch (RuntimeException e) {
            throw new DataCreationException(700, (Throwable)e);
        }
        catch (DataSourceException e) {
            throw new DataCreationException(701, (Throwable)e);
        }
    }

    @Override
    public void processPostInfo(boolean createStatistics) throws DataCreationException {
        try {
            this.m_dataWriter.processPostInfo(this.getPostInfoFileBaseName());
            if (DebugLevel.getDebugLevel((int)5) >= 1) {
                DataCreationLogger.getLogger().logMemoryUsage();
                DataCreationLogger.getLogger().logStatus("Closing postinfo data handler.");
            }
            this.m_postInfoDataHandler.close();
            if (DebugLevel.getDebugLevel((int)5) >= 1) {
                DataCreationLogger.getLogger().logMemoryUsageWithGC();
            }
        }
        catch (RuntimeException e) {
            throw new DataCreationException(500, (Throwable)e);
        }
        catch (DataSourceException e) {
            throw new DataCreationException(501, (Throwable)e);
        }
        if (createStatistics) {
            DataFileStatistics.getStatisticsInstance().outputStatistics(StringUtilities.appendToPath((String)this.m_processProperties.getProperty("postInfo_outputFilePath"), (String)this.m_processProperties.getProperty("postInfo_outputFile")));
        }
    }

    @Override
    public void processPost2Sac(boolean createStatistics) throws DataCreationException {
        try {
            this.m_dataWriter.processPost2Sac();
            if (DebugLevel.getDebugLevel((int)5) >= 1) {
                DataCreationLogger.getLogger().logMemoryUsage();
                DataCreationLogger.getLogger().logStatus("Closing post2sac data handler.");
            }
            this.m_post2sacDataHandler.close();
            if (DebugLevel.getDebugLevel((int)5) >= 1) {
                DataCreationLogger.getLogger().logMemoryUsageWithGC();
            }
        }
        catch (RuntimeException e) {
            throw new DataCreationException(800, (Throwable)e);
        }
        catch (DataSourceException e) {
            throw new DataCreationException(801, (Throwable)e);
        }
    }

    @Override
    public StreetDataGroup getNextStreetGroup() throws DataCreationException {
        StreetDataGroup group = null;
        if (this.m_currentMultiStreet == null) {
            this.m_currentMultiStreet = (MultiSegmentStreet)this.m_streetDataHandler.getNextDataRecord();
            if (this.m_currentMultiStreet == null) {
                PhaseProgressBounds bounds;
                DataCreationLogger.getLogger().logStatus(this.m_dataBuilder.getSummaryInfo());
                if (DebugLevel.getDebugLevel((int)5) >= 1) {
                    DataCreationLogger.getLogger().logMemoryUsage();
                    DataCreationLogger.getLogger().logStatus("Setting data builder to null.");
                }
                this.m_dataBuilder = null;
                if (DebugLevel.getDebugLevel((int)5) >= 1) {
                    DataCreationLogger.getLogger().logMemoryUsageWithGC();
                }
                if ((bounds = PhaseProgressBoundsProvider.getInstance().getBounds(1)) != null) {
                    ProgressBarUpdaterProvider.getUpdaterInstance().update(bounds.getEnd());
                }
                return null;
            }
        }
        boolean done = false;
        while (!done) {
            if (this.m_currentMultiStreet == null) {
                done = true;
            } else if (group == null) {
                group = new StreetDataGroup(this.m_currentMultiStreet.getSac(), this.m_currentMultiStreet.getKey());
                if (this.supportsReverseGeocode()) {
                    group.addStreet(this.m_dataBuilder.buildStreetFromRecord(this.m_currentMultiStreet, this.getStreetMetadata()), this.m_currentMultiStreet.getBrowseKeys(), this.m_currentMultiStreet.getAlternateDataItems(), this.m_currentMultiStreet.getSpatialIndexValues());
                } else {
                    group.addStreet(this.m_dataBuilder.buildStreetFromRecord(this.m_currentMultiStreet, this.getStreetMetadata()), this.m_currentMultiStreet.getBrowseKeys(), this.m_currentMultiStreet.getAlternateDataItems());
                }
                this.m_currentMultiStreet = null;
            } else if (group.getKey().equals(this.m_currentMultiStreet.getKey())) {
                if (this.supportsReverseGeocode()) {
                    group.addStreet(this.m_dataBuilder.buildStreetFromRecord(this.m_currentMultiStreet, this.getStreetMetadata()), this.m_currentMultiStreet.getBrowseKeys(), this.m_currentMultiStreet.getAlternateDataItems(), this.m_currentMultiStreet.getSpatialIndexValues());
                } else {
                    group.addStreet(this.m_dataBuilder.buildStreetFromRecord(this.m_currentMultiStreet, this.getStreetMetadata()), this.m_currentMultiStreet.getBrowseKeys(), this.m_currentMultiStreet.getAlternateDataItems());
                }
                this.m_currentMultiStreet = null;
            } else {
                done = true;
            }
            if (done || this.m_currentMultiStreet != null) continue;
            this.m_currentMultiStreet = (MultiSegmentStreet)this.m_streetDataHandler.getNextDataRecord();
        }
        return group;
    }

    @Override
    public byte[] getAlternateStreetBrowseSupportedTypes() {
        return new byte[]{0};
    }

    @Override
    public byte[] getAlternateStreetSearchSupportedTypes() {
        return new byte[]{0};
    }

    @Override
    public String getAlternateBrowseTypeTempIndexExtension(byte alternateType) {
        switch (alternateType) {
            case 0: {
                return ".pbt";
            }
        }
        return null;
    }

    @Override
    public String getAlternateBrowseTypeFinalIndexExtension(byte alternateType) {
        switch (alternateType) {
            case 0: {
                return ".pbx";
            }
        }
        return null;
    }

    @Override
    public String getAlternateSearchTypeTempIndexExtension(byte alternateType) {
        switch (alternateType) {
            case 0: {
                return ".pst";
            }
        }
        return null;
    }

    @Override
    public String getAlternateSearchTypeFinalIndexExtension(byte alternateType) {
        switch (alternateType) {
            case 0: {
                return ".pdx";
            }
        }
        return null;
    }

    @Override
    public RandomAccessFile getAlternateBrowseIndexFile(byte alternateBrowseIndexType) throws DataCreationException {
        switch (alternateBrowseIndexType) {
            case 0: {
                String streetBaseName = this.m_processProperties.getProperty("street_outputFile");
                String placeBrowseIndexExtension = this.getAlternateBrowseTypeTempIndexExtension(alternateBrowseIndexType);
                if (placeBrowseIndexExtension == null) {
                    return null;
                }
                String placeBrowseIndexFileName = StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)streetBaseName, (String)placeBrowseIndexExtension);
                return this.getAlternateIndexFileForName(placeBrowseIndexFileName);
            }
        }
        return null;
    }

    @Override
    public RandomAccessFile getAlternateSearchIndexFile(byte alternateSearchIndexType) throws DataCreationException {
        switch (alternateSearchIndexType) {
            case 0: {
                String streetBaseName = this.m_processProperties.getProperty("street_outputFile");
                String placeSearchIndexExtension = this.getAlternateSearchTypeTempIndexExtension(alternateSearchIndexType);
                if (placeSearchIndexExtension == null) {
                    return null;
                }
                String placeSearchIndexFileName = StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)streetBaseName, (String)placeSearchIndexExtension);
                return this.getAlternateIndexFileForName(placeSearchIndexFileName);
            }
        }
        return null;
    }

    @Override
    public void closeAllAternateIndexes() throws DataCreationException {
        if (this.m_alternateIndexFiles != null) {
            Iterator alternateIndexIterator = this.m_alternateIndexFiles.iterator();
            while (alternateIndexIterator.hasNext()) {
                AlternateIndexFileCacheItem item = (AlternateIndexFileCacheItem)alternateIndexIterator.next();
                alternateIndexIterator.remove();
                try {
                    item.getIndexFile().close();
                }
                catch (IOException e) {
                    throw new DataCreationException(200, (Throwable)e);
                }
            }
        }
    }

    protected RandomAccessFile getAlternateIndexFileForName(String indexFileName) throws DataCreationException {
        RandomAccessFile indexFile;
        if (this.m_alternateIndexFiles == null) {
            this.m_alternateIndexFiles = new ArrayList();
        }
        for (AlternateIndexFileCacheItem item : this.m_alternateIndexFiles) {
            if (!indexFileName.equals(item.getIndexFileName())) continue;
            return item.getIndexFile();
        }
        try {
            indexFile = new RandomAccessFile(indexFileName, "rw");
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logError("Unable to open alternate index: " + indexFileName);
            throw new DataCreationException(200, (Throwable)e);
        }
        this.m_alternateIndexFiles.add(new AlternateIndexFileCacheItem(indexFileName, indexFile));
        return indexFile;
    }

    @Override
    public byte[] getSpecialStreetAltTypesSupported() {
        return new byte[0];
    }

    @Override
    public String getSpecialIntermediateIndexExtension(byte special) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSpecialTemporaryIndexExtension(byte special) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFileInnerIndexConvertor getStreetIndexFileConvertor() {
        return new MultiLevelNIOInnerIndexConvertor((IInputIndexFileHelper)new SacMiSoundexInputIndexFileHelper(), new SacMiSoundexKeySingleValueNIOMultiLevelInnerIndexHelper(), (MapMarkerIndexFileMetadata)new MapMarkerMultiLevelIndexFileMetadata(3));
    }

    @Override
    public IFileInnerIndexConvertor getStreetBrowseIndexFileConvertor() {
        return new MultiLevelNIOInnerIndexConvertor((IInputIndexFileHelper)new BrowseInputIndexFileHelper(), new BrowseMultiValueNIOMultiLevelInnerIndexHelper(), (MapMarkerIndexFileMetadata)new MapMarkerMultiLevelIndexFileMetadata(3));
    }

    @Override
    public IFileInnerIndexConvertor getStreetAlternateSearchTypeIndexFileConvertor(byte alternateType) {
        switch (alternateType) {
            case 0: {
                return new MultiLevelNIOInnerIndexConvertor((IInputIndexFileHelper)new SacMiSoundexInputIndexFileHelper(), new SacMiSoundexKeyMultiValueNIOMultiLevelInnerIndexHelper(), (MapMarkerIndexFileMetadata)new MapMarkerMultiLevelIndexFileMetadata(3));
            }
        }
        return null;
    }

    @Override
    public IFileInnerIndexConvertor getStreetAlternateBrowseTypeIndexFileConvertor(byte alternateType) {
        switch (alternateType) {
            case 0: {
                return new MultiLevelNIOInnerIndexConvertor((IInputIndexFileHelper)new BrowseInputIndexFileHelper(), new BrowseMultiValueNIOMultiLevelInnerIndexHelper(), (MapMarkerIndexFileMetadata)new MapMarkerMultiLevelIndexFileMetadata(3));
            }
        }
        return null;
    }

    @Override
    public MMJGeo2SacRecord getNextGeo2SacRecord() throws DataCreationException {
        return (MMJGeo2SacRecord)this.m_geo2sacDataHandler.getNextDataRecord();
    }

    @Override
    public MMJPost2SacRecord getNextPost2SacRecord() throws DataCreationException {
        return (MMJPost2SacRecord)this.m_post2sacDataHandler.getNextDataRecord();
    }

    @Override
    public MMJPostInfoItem getNextPostInfoItem() throws DataCreationException {
        MMJPostInfoRecord record = (MMJPostInfoRecord)this.m_postInfoDataHandler.getNextDataRecord();
        if (record != null) {
            PostInfoDataItem item = (PostInfoDataItem)this.m_dataBuilder.buildPostInfoFromRecord(record.getRecord(), this.getPostInfoMetadata());
            MMJPostInfoItem returnVal = new MMJPostInfoItem(item, record.getKey());
            return returnVal;
        }
        return null;
    }

    @Override
    public IndexFileConvertor getPostInfoIndexFileConvertor(String tempIndex, String newIndex) {
        return new StandardPostInfoIndexFileConvertor(tempIndex, newIndex);
    }

    @Override
    public MMJGeoInfoItem getNextGeoInfoItem() throws DataCreationException {
        MMJGeoInfoRecord record = (MMJGeoInfoRecord)this.m_geoInfoDataHandler.getNextDataRecord();
        if (record != null) {
            GeoInfoDataItem item = (GeoInfoDataItem)this.m_dataBuilder.buildGeoInfoFromRecord(record.getRecord(), this.getGeoInfoMetadata());
            MMJGeoInfoItem returnVal = new MMJGeoInfoItem(item, record.getKey());
            return returnVal;
        }
        return null;
    }

    @Override
    public GeoInfoSoundexIndexer getGeoInfoSoundexIndexer() {
        return null;
    }

    @Override
    public IndexFileConvertor getExactMatchGeoInfoIndexConvertor(String tempIndex, String newIndex) {
        return new MiStringIndexFileConvertor(tempIndex, newIndex);
    }

    @Override
    public IndexFileConvertor getSoundexGeoInfoIndexConvertor(String tempIndex, String newIndex) {
        return new MiSoundexMultiValueIndexFileConvertor(tempIndex, newIndex);
    }

    protected String getStreetFileBaseName() {
        return this.m_processProperties.getProperty("street_outputFile");
    }

    protected String getPostInfoFileBaseName() {
        return this.m_processProperties.getProperty("postInfo_outputFile");
    }

    protected String getGeoInfoFileBaseName() {
        return this.m_processProperties.getProperty("geoInfo_outputFile");
    }

    @Override
    public void preProcessStreetDataSet() throws DataCreationException {
        try {
            this.m_streetDataHandler.open(this.m_processProperties);
        }
        catch (DataSourceException e) {
            throw new DataCreationException(100, (Throwable)e);
        }
        this.m_streetDataHandler.prepare();
        this.m_streetFrequentStrings = this.m_streetDataHandler.getFrequentDataFileStrings(255);
    }

    @Override
    public void preProcessPost2SacDataSet() throws DataCreationException {
        try {
            this.m_post2sacDataHandler.open(this.m_processProperties);
        }
        catch (DataSourceException e) {
            throw new DataCreationException(800, (Throwable)e);
        }
        this.m_post2sacDataHandler.prepare();
    }

    @Override
    public void preProcessGeo2SacDataSet() throws DataCreationException {
        try {
            this.m_geo2sacDataHandler.open(this.m_processProperties);
        }
        catch (DataSourceException e) {
            throw new DataCreationException(700, (Throwable)e);
        }
        this.m_geo2sacDataHandler.prepare();
    }

    @Override
    public void preProcessPostInfoDataSet() throws DataCreationException {
        try {
            this.m_postInfoDataHandler.open(this.m_processProperties);
        }
        catch (DataSourceException e) {
            throw new DataCreationException(500, (Throwable)e);
        }
        this.m_postInfoDataHandler.prepare();
        this.m_postinfoFrequentStrings = this.m_postInfoDataHandler.getFrequentDataFileStrings(255);
    }

    @Override
    public void preProcessGeoInfoDataSet() throws DataCreationException {
        try {
            this.m_geoInfoDataHandler.open(this.m_processProperties);
        }
        catch (DataSourceException e) {
            throw new DataCreationException(300, (Throwable)e);
        }
        this.m_geoInfoDataHandler.prepare();
        this.m_geoinfoFrequentStrings = this.m_geoInfoDataHandler.getFrequentDataFileStrings(255);
    }

    @Override
    public SacMetadata getPost2SacMetadata() throws DataCreationException {
        return new SacMetadata();
    }

    @Override
    public SacMetadata getGeo2SacMetadata() throws DataCreationException {
        return new SacMetadata();
    }

    @Override
    public boolean forUserDictionary() {
        return this.m_forUserDictionary;
    }

    protected void setForUserDictioary(boolean ud) {
        this.m_forUserDictionary = ud;
    }

    @Override
    public boolean supportsReverseGeocode() {
        return false;
    }

    @Override
    public int getNumberOfRangesToCombineForSpatialIndexValues() {
        return 20;
    }

    private class AlternateIndexFileCacheItem {
        String m_indexFileName;
        RandomAccessFile m_indexFile;

        public AlternateIndexFileCacheItem(String indexFileName, RandomAccessFile indexFile) {
            this.m_indexFileName = indexFileName;
            this.m_indexFile = indexFile;
        }

        public String getIndexFileName() {
            return this.m_indexFileName;
        }

        public RandomAccessFile getIndexFile() {
            return this.m_indexFile;
        }
    }
}

