/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.AlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;

public class AlternateDataItem
implements Comparable {
    private byte m_alternateSearchType;
    private AlternateDataRecord m_record;
    private MapMarkerIndexKey m_searchKey;
    private MapMarkerIndexKey m_browseKey;

    public AlternateDataItem(byte alternateSearchType, AlternateDataRecord record, MapMarkerIndexKey searchKey, MapMarkerIndexKey browseKey) {
        this.m_alternateSearchType = alternateSearchType;
        this.m_record = record;
        this.m_searchKey = searchKey;
        this.m_browseKey = browseKey;
    }

    public byte getAlternateSearchType() {
        return this.m_alternateSearchType;
    }

    public AlternateDataRecord getAlternateDataRecord() {
        return this.m_record;
    }

    public MapMarkerIndexKey getSearchKey() {
        return this.m_searchKey;
    }

    public MapMarkerIndexKey getBrowseKey() {
        return this.m_browseKey;
    }

    public int compareTo(Object that) {
        AlternateDataItem thatItem = (AlternateDataItem)that;
        if (this.m_alternateSearchType == thatItem.m_alternateSearchType) {
            long thatOffset;
            long thisOffset = this.m_record.getStreetOffset();
            if (thisOffset == (thatOffset = thatItem.m_record.getStreetOffset())) {
                short thatSegment;
                short thisSegment = this.m_record.getSegmentNumber();
                if (thisSegment == (thatSegment = thatItem.m_record.getSegmentNumber())) {
                    short thatRange;
                    short thisRange = this.m_record.getRangeNumber();
                    if (thisRange == (thatRange = thatItem.m_record.getRangeNumber())) {
                        short thisUnit = this.m_record.getUnitNumber();
                        short thatUnit = thatItem.m_record.getUnitNumber();
                        return thisUnit - thatUnit;
                    }
                    return thisRange - thatRange;
                }
                return thisSegment - thatSegment;
            }
            return (int)(thisOffset - thatOffset);
        }
        return this.m_alternateSearchType - thatItem.m_alternateSearchType;
    }
}

