/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;

public class CustomMaskCodeWriter {
    private static String[] RECORD_TYPES = new String[]{"MASK_TYPE_STREET", "MASK_TYPE_SEGMENT", "MASK_TYPE_RANGE", "MASK_TYPE_RANGE_UNIT", "MASK_TYPE_GEOINFO", "MASK_TYPE_POSTINFO"};
    private static String[] RECORD_TYPE_ARGS = new String[]{"street", "segment", "range", "unit", "geoinfo", "postinfo"};
    private static int INVALID_RECORD_TYPE = -1;
    private static String[] DATA_ITEM_TYPES = new String[]{" BOOLEANS: ", " BYTES: ", " CHARS: ", " DOUBLES: ", " FLOATS: ", " INTS: ", " LONGS: ", " SHORTS: ", " STRINGS: ", " BLOBS: ", " UNSIGNED-BYTES: ", " UNSIGNED-SHORTS: ", " CUSTOM DATUM 0: ", " CUSTOM DATUM 1: ", " CUSTOM DATUM 2: "};
    private static String[] MASK_SET_METHODS = new String[]{"setBoolHash", "setByteHash", "setCharHash", "setDoubleHash", "setFloatHash", "setIntHash", "setLongHash", "setShortHash", "setStringHash", "setBlobHash", "setUnsignedByteHash", "setUnsignedShortHash", "setCustomDatumHash", "setCustomDatumHash", "setCustomDatumHash"};
    private static int HASH_STRING_LENGTH = 64;
    private static int MAX_TYPE_MASKS_PER_TYPE = 255;

    private static String getTypeHashAssignmentString(int typeNumber, String hashString) {
        return "\t\tmask." + MASK_SET_METHODS[typeNumber] + "(TypeMask.convertBinaryStringToHash(\"" + hashString + "\"));\n";
    }

    private static String getCustomTypeHashAssignmentString(int customTypeNumber, int typeNumber, String hashString) {
        return "\t\tmask." + MASK_SET_METHODS[typeNumber] + "((byte)" + customTypeNumber + ", TypeMask.convertBinaryStringToHash(\"" + hashString + "\"));\n";
    }

    private static int getRecordTypeIndex(String recordTypeArg) {
        for (int i = 0; i < RECORD_TYPE_ARGS.length; ++i) {
            if (!recordTypeArg.equals(RECORD_TYPE_ARGS[i])) continue;
            return i;
        }
        return INVALID_RECORD_TYPE;
    }

    private static String getMaskAssignmentString(int recordType, int maskNumber) {
        return "\t\tmasks.setIndexedTypeMask(DataFileMasks." + RECORD_TYPES[recordType] + " , (short)" + maskNumber + ", mask);\n";
    }

    private static String removeHashStringFromCommentLine(String commentString, int typeOffset, String typeLabel) {
        System.out.println("Type: " + typeLabel + "\tcommentString: " + commentString);
        int endOfLabel = typeOffset + typeLabel.length();
        return commentString.substring(0, endOfLabel) + commentString.substring(endOfLabel + HASH_STRING_LENGTH + 1);
    }

    private static String createCommentString(String originalString) {
        String str = "\t\t// " + originalString;
        for (int i = 0; i < DATA_ITEM_TYPES.length; ++i) {
            int typeOffset = str.indexOf(DATA_ITEM_TYPES[i]);
            if (typeOffset < 0) continue;
            str = CustomMaskCodeWriter.removeHashStringFromCommentLine(str, typeOffset, DATA_ITEM_TYPES[i]);
        }
        return str + "\n";
    }

    private static String getNextHashString(String inputLine, int typeLabelStart, String typeLabel) {
        int hashStringStart = typeLabelStart + typeLabel.length();
        return inputLine.substring(hashStringStart, hashStringStart + HASH_STRING_LENGTH - 1);
    }

    private static String processLine(String inputLine, int recordType, int lineNumber) {
        String str = CustomMaskCodeWriter.createCommentString(inputLine);
        str = str + "\t\tmask = new TypeMask();\n";
        for (int i = 0; i < DATA_ITEM_TYPES.length; ++i) {
            int typeOffset = inputLine.indexOf(DATA_ITEM_TYPES[i]);
            if (typeOffset < 0) continue;
            String hashString = CustomMaskCodeWriter.getNextHashString(inputLine, typeOffset, DATA_ITEM_TYPES[i]);
            if (DATA_ITEM_TYPES[i].startsWith(" CUSTOM")) {
                int customTypeNumber = i - DATA_ITEM_TYPES.length + 3;
                str = str + CustomMaskCodeWriter.getCustomTypeHashAssignmentString(customTypeNumber, i, hashString);
                continue;
            }
            str = str + CustomMaskCodeWriter.getTypeHashAssignmentString(i, hashString);
        }
        str = str + CustomMaskCodeWriter.getMaskAssignmentString(recordType, lineNumber);
        return str;
    }

    private static void processFile(int recordType, RandomAccessFile inputFile, PrintStream outputFile) {
        int lineNumber = 1;
        while (true) {
            try {
                while (true) {
                    String inputLine;
                    if ((inputLine = inputFile.readLine()) == null || inputLine.length() == 0 || lineNumber > MAX_TYPE_MASKS_PER_TYPE) {
                        throw new EOFException();
                    }
                    String outputLine = CustomMaskCodeWriter.processLine(inputLine, recordType, lineNumber);
                    outputFile.println(outputLine);
                    ++lineNumber;
                }
            }
            catch (EOFException EOF) {
                System.out.println("Finished processing file.");
                try {
                    inputFile.close();
                    outputFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            catch (IOException IOEx) {
                System.err.println("ERROR: Unable to process line in input.");
                System.exit(1);
                continue;
            }
            break;
        }
    }

    private static void usage() {
        System.err.println("CustomMaskCodeWriter <record type> <input file> <output file>");
        System.exit(1);
    }

    public static final void main(String[] args) {
        int recordType;
        if (args.length != 3) {
            CustomMaskCodeWriter.usage();
        }
        if ((recordType = CustomMaskCodeWriter.getRecordTypeIndex(args[0])) == INVALID_RECORD_TYPE) {
            System.err.println("Must pass a valid record argument.");
            CustomMaskCodeWriter.usage();
        }
        File inputFile = new File(args[1]);
        RandomAccessFile input = null;
        try {
            input = new RandomAccessFile(inputFile, "r");
        }
        catch (IOException IOEx) {
            System.err.println("ERROR: Unable to open input file: " + args[1]);
            System.err.println(IOEx.getMessage());
            CustomMaskCodeWriter.usage();
        }
        PrintStream outputFile = null;
        try {
            outputFile = new PrintStream(new FileOutputStream(args[2]));
        }
        catch (IOException IOEx) {
            System.err.println("ERROR: Unable to create output file: " + args[2]);
            System.err.println(IOEx.getMessage());
            CustomMaskCodeWriter.usage();
        }
        CustomMaskCodeWriter.processFile(recordType, input, outputFile);
    }
}

