/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.binary.BlobAdditionalFieldsFactory;
import com.mapinfo.mapmarker.common.dp.binary.CompressedSegment;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.FrequentDataFileStrings;
import com.mapinfo.mapmarker.common.dp.binary.GenericRange;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.GenericUnit;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetBuilder;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.binary.NoModCompressedSegment;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.TAIntermediateRangeRecord;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.IOException;
import java.util.List;

public class GenericStreetBuilder
extends MMJStreetBuilder {
    protected long totalStreets = 0L;
    protected long totalSegments = 0L;
    protected long totalRanges = 0L;
    protected long totalRangeUnits = 0L;

    protected IDataFileDataItem getStreetDataObject() {
        return new GenericStreet();
    }

    protected IDataFileDataItem getSegmentDataObject() {
        return new GenericSegment();
    }

    protected IDataFileDataItem getRangeDataObject() {
        return new GenericRange();
    }

    protected IDataFileDataItem getRangeUnitDataObject() {
        return new GenericUnit();
    }

    @Override
    public IDataFileDataItem buildStreetFromRecord(MultiSegmentStreet record, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        ++this.totalStreets;
        IDataFileDataItem street = this.getStreetDataObject();
        this.populateStreetInfo(record, street, metadata);
        this.populateLocalStreetInfo(record, street, metadata);
        MMJSegmentRecord lastSegment = null;
        List segments = record.getSegments();
        for (MMJSegmentRecord segmentRecord : segments) {
            this.compressSegment(segmentRecord, lastSegment);
            lastSegment = segmentRecord;
            ++this.totalSegments;
            this.addSegmentToStreet(street, this.buildSegmentFromRecord(segmentRecord, metadata));
        }
        return street;
    }

    protected void addSegmentToStreet(IDataFileDataItem streetItem, IDataFileDataItem segmentItem) {
        ((GenericStreet)streetItem).addSegment((GenericSegment)segmentItem);
    }

    protected void compressSegment(MMJSegmentRecord segmentRecord, MMJSegmentRecord lastSegment) throws DataCreationException {
    }

    protected void populateLocalStreetInfo(MultiSegmentStreet record, IDataFileDataItem street, MMJComplexDataFileMetadata metadata) throws DataCreationException {
    }

    protected void populateStreetInfo(MultiSegmentStreet record, IDataFileDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        Address address = record.getAddress();
        GenericStreet street = (GenericStreet)item;
        try {
            String temp = address.getGenericField1();
            if (temp != null && temp.length() != 0) {
                street.putString(0, temp);
            }
            if ((temp = address.getGenericField2()) != null && temp.length() != 0) {
                street.putString(1, temp);
            }
            if ((temp = address.getGenericField3()) != null && temp.length() != 0) {
                street.putString(2, temp);
            }
            if ((temp = address.getGenericField4()) != null && temp.length() != 0) {
                street.putString(3, temp);
            }
            if ((temp = address.getPreAddress()) != null && temp.length() != 0) {
                street.putString(4, temp);
            }
            if ((temp = address.getMainAddress()) != null && temp.length() != 0) {
                int mainAddressIndex = metadata.getFrequentStrings().getStringNumber(0, temp);
                if (mainAddressIndex != -1) {
                    street.putByte(1, FrequentDataFileStrings.convertIndexToByte((int)mainAddressIndex));
                } else {
                    street.putString(7, temp);
                }
            }
            if ((temp = address.getPreDirectional()) != null && temp.length() != 0) {
                street.putString(5, temp);
            }
            if ((temp = address.getPreThoroughfareType()) != null && temp.length() != 0) {
                int preTypeIndex = metadata.getFrequentStrings().getStringNumber(1, temp);
                if (preTypeIndex != -1) {
                    street.putByte(0, FrequentDataFileStrings.convertIndexToByte((int)preTypeIndex));
                } else {
                    street.putString(6, temp);
                }
            }
            if ((temp = address.getPostThoroughfareType()) != null && temp.length() != 0) {
                int postTypeIndex = metadata.getFrequentStrings().getStringNumber(1, temp);
                if (postTypeIndex != -1) {
                    street.putByte(2, FrequentDataFileStrings.convertIndexToByte((int)postTypeIndex));
                } else {
                    street.putString(8, temp);
                }
            }
            if ((temp = address.getPostDirectional()) != null && temp.length() != 0) {
                street.putString(9, temp);
            }
            if ((temp = address.getPostAddress()) != null && temp.length() != 0) {
                street.putString(10, temp);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate street data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(101, (Throwable)e);
        }
    }

    protected void populateLocalSegmentInfo(MMJSegmentRecord segmentRecord, IDataFileDataItem segmentItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
    }

    protected void populateSegmentInfo(MMJSegmentRecord segmentRecord, IDataFileDataItem segmentItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        block29: {
            GenericSegment segment = (GenericSegment)segmentItem;
            try {
                String leftPostalCode1 = segmentRecord.getLeftPostalCode1();
                String rightPostalCode1 = segmentRecord.getRightPostalCode1();
                if (leftPostalCode1 != null && rightPostalCode1 != null && leftPostalCode1.equals(rightPostalCode1)) {
                    segment.putString(12, leftPostalCode1);
                } else {
                    if (leftPostalCode1 != null) {
                        segment.putString(0, leftPostalCode1);
                    }
                    if (rightPostalCode1 != null) {
                        segment.putString(1, rightPostalCode1);
                    }
                }
                String leftPostalCode2 = segmentRecord.getLeftPostalCode2();
                String rightPostalCode2 = segmentRecord.getRightPostalCode2();
                if (leftPostalCode2 != null && rightPostalCode2 != null && leftPostalCode2.equals(rightPostalCode2)) {
                    segment.putString(13, leftPostalCode2);
                } else {
                    if (leftPostalCode2 != null) {
                        segment.putString(2, leftPostalCode2);
                    }
                    if (rightPostalCode2 != null) {
                        segment.putString(3, rightPostalCode2);
                    }
                }
                String leftAreaName1 = segmentRecord.getLeftAreaName1();
                String rightAreaName1 = segmentRecord.getRightAreaName1();
                if (leftAreaName1 != null && rightAreaName1 != null && leftAreaName1.equals(rightAreaName1)) {
                    segment.putString(14, leftAreaName1);
                } else {
                    if (leftAreaName1 != null) {
                        segment.putString(4, leftAreaName1);
                    }
                    if (rightAreaName1 != null) {
                        segment.putString(5, rightAreaName1);
                    }
                }
                String leftAreaName2 = segmentRecord.getLeftAreaName2();
                String rightAreaName2 = segmentRecord.getRightAreaName2();
                if (leftAreaName2 != null && rightAreaName2 != null && leftAreaName2.equals(rightAreaName2)) {
                    segment.putString(15, leftAreaName2);
                } else {
                    if (leftAreaName2 != null) {
                        segment.putString(6, leftAreaName2);
                    }
                    if (rightAreaName2 != null) {
                        segment.putString(7, rightAreaName2);
                    }
                }
                String leftAreaName3 = segmentRecord.getLeftAreaName3();
                String rightAreaName3 = segmentRecord.getRightAreaName3();
                if (leftAreaName3 != null && rightAreaName3 != null && leftAreaName3.equals(rightAreaName3)) {
                    segment.putString(16, leftAreaName3);
                } else {
                    if (leftAreaName3 != null) {
                        segment.putString(8, leftAreaName3);
                    }
                    if (rightAreaName3 != null) {
                        segment.putString(9, rightAreaName3);
                    }
                }
                String leftAreaName4 = segmentRecord.getLeftAreaName4();
                String rightAreaName4 = segmentRecord.getRightAreaName4();
                if (leftAreaName4 != null && rightAreaName4 != null && leftAreaName4.equals(rightAreaName4)) {
                    segment.putString(17, leftAreaName4);
                } else {
                    if (leftAreaName4 != null) {
                        segment.putString(10, leftAreaName4);
                    }
                    if (rightAreaName4 != null) {
                        segment.putString(11, rightAreaName4);
                    }
                }
                String segmentId = segmentRecord.getId();
                if (segmentId == null) break block29;
                boolean storeSegmentIdAsLong = false;
                try {
                    segment.putLong(3, Long.parseLong(segmentId));
                    storeSegmentIdAsLong = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!storeSegmentIdAsLong) {
                    segment.putString(19, segmentId);
                }
            }
            catch (MMJETypeArraySizeExceededException e) {
                DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
                DataCreationLogger.getLogger().logInternalError(e.getMessage());
                DataCreationLogger.getLogger().logStackTrace(e);
                throw new DataCreationException(106, (Throwable)e);
            }
        }
    }

    protected void populateLocalRangeInfo(MMJRangeRecord record, IDataFileDataItem rangeItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
    }

    protected void populateRangeInfo(MMJRangeRecord record, IDataFileDataItem rangeItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericRange range = (GenericRange)rangeItem;
        try {
            if (record.getFromHouse().isPureNumeric()) {
                long fromHouse = record.getFromHouse().getAddressNumber();
                if (fromHouse <= 255L && fromHouse >= 0L) {
                    range.putUnsignedByte(1, (short)fromHouse);
                } else if (fromHouse <= 65535L && fromHouse >= 0L) {
                    range.putUnsignedShort(1, (int)fromHouse);
                } else if (fromHouse <= Integer.MAX_VALUE && fromHouse >= Integer.MIN_VALUE) {
                    range.putInt(0, (int)fromHouse);
                } else {
                    range.putLong(0, fromHouse);
                }
            } else {
                range.putString(1, record.getFromHouse().getCombinedAddressNumber());
            }
            if (record.getToHouse().isPureNumeric()) {
                long toHouse = record.getToHouse().getAddressNumber();
                if (toHouse <= 255L && toHouse >= 0L) {
                    range.putUnsignedByte(2, (short)toHouse);
                } else if (toHouse <= 65535L && toHouse >= 0L) {
                    range.putUnsignedShort(2, (int)toHouse);
                } else if (toHouse <= Integer.MAX_VALUE && toHouse >= Integer.MIN_VALUE) {
                    range.putInt(1, (int)toHouse);
                } else {
                    range.putLong(1, toHouse);
                }
            } else {
                range.putString(0, record.getToHouse().getCombinedAddressNumber());
            }
            if (record.getPlaceName() != null) {
                range.putString(2, record.getPlaceName());
            }
            if (record.getIntermediateDataRecordArray() != null) {
                TAIntermediateRangeRecord intm = new TAIntermediateRangeRecord(record.getIntermediateDataRecordArray());
                range.putBlob(1, intm.getBytes());
            }
            range.putByte(1, record.isAscending() ? (byte)0 : 1);
            range.putByte(0, (byte)record.getOddEven());
            range.putByte(2, record.isLeft() ? (byte)0 : 1);
            if (record.hasAdditionalFields()) {
                range.putBlob(2, BlobAdditionalFieldsFactory.createBlob(record.getAdditionalFields()));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(107, (Throwable)e);
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(107, (Throwable)e);
        }
    }

    protected void populateLocalRangeUnitInfo(MMJRangeUnitRecord record, IDataFileDataItem unitItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
    }

    protected void populateRangeUnitInfo(MMJRangeUnitRecord record, IDataFileDataItem unitItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericUnit unit = (GenericUnit)unitItem;
        try {
            if (record.getLowUnit() != null) {
                unit.putString(0, record.getLowUnit());
            }
            if (record.getHighUnit() != null) {
                unit.putString(1, record.getHighUnit());
            }
            if (record.getUnitType() != null) {
                unit.putString(2, record.getUnitType());
            }
            if (record.getPlaceName() != null) {
                unit.putString(3, record.getPlaceName());
            }
            if (record.hasAdditionalFields()) {
                unit.putBlob(0, BlobAdditionalFieldsFactory.createBlob(record.getAdditionalFields()));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate unit data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(108, (Throwable)e);
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(IOEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace(IOEx);
            throw new DataCreationException(107, (Throwable)IOEx);
        }
    }

    protected IDataFileDataItem buildSegmentFromRecord(MMJSegmentRecord segmentRecord, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        IDataFileDataItem segment = this.getSegmentDataObject();
        this.populateSegmentInfo(segmentRecord, segment, metadata);
        this.populateLocalSegmentInfo(segmentRecord, segment, metadata);
        this.storeSegmentPoints(segmentRecord, segment, (MMJDataFileMetadata)metadata);
        this.storeHousePoints(segmentRecord, segment, (MMJDataFileMetadata)metadata);
        MMJRangeRecord lastRange = null;
        List addressRanges = segmentRecord.getRanges();
        if (addressRanges != null) {
            for (MMJRangeRecord range : addressRanges) {
                this.compressRange(range, lastRange);
                lastRange = range;
                this.addRangeToSegment(segment, this.buildRangeFromRangeRecord(range, metadata));
                ++this.totalRanges;
            }
        }
        return segment;
    }

    protected void storeHousePoints(MMJSegmentRecord segmentRecord, IDataFileDataItem segment, MMJDataFileMetadata metadata) throws DataCreationException {
        List housePoints;
        if (segmentRecord.isPointHouseSegment() && (housePoints = segmentRecord.getPointHouseGeometry()) != null) {
            try {
                ((GenericSegment)segment).setHousePoints(new NoModCompressedSegment(housePoints.toArray(new DirectPosition[0]), metadata.getXPow10(), metadata.getYPow10()));
            }
            catch (IOException IOEx) {
                throw new DataCreationException(106, (Throwable)IOEx);
            }
            catch (MMJEDataCorruptedException MMJEDCEx) {
                throw new DataCreationException(106, (Throwable)MMJEDCEx);
            }
        }
    }

    protected void storeSegmentPoints(MMJSegmentRecord segmentRecord, IDataFileDataItem segment, MMJDataFileMetadata metadata) throws DataCreationException {
        List points = segmentRecord.getPoints();
        if (points != null) {
            for (DirectPosition p : points) {
                ((GenericSegment)segment).addPoint(p);
            }
        }
    }

    protected void addRangeToSegment(IDataFileDataItem segmentItem, IDataFileDataItem rangeItem) {
        ((GenericSegment)segmentItem).addRange((GenericRange)rangeItem);
    }

    protected void compressRange(MMJRangeRecord rangeRecord, MMJRangeRecord lastRange) throws DataCreationException {
    }

    protected IDataFileDataItem buildRangeFromRangeRecord(MMJRangeRecord record, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        IDataFileDataItem range = this.getRangeDataObject();
        this.populateRangeInfo(record, range, metadata);
        this.populateLocalRangeInfo(record, range, metadata);
        MMJRangeUnitRecord lastUnit = null;
        List units = record.getRangeUnits();
        if (units != null) {
            for (MMJRangeUnitRecord unitRecord : units) {
                this.compressRangeUnit(unitRecord, lastUnit);
                lastUnit = unitRecord;
                ++this.totalRangeUnits;
                this.addRangeUnitToRange(range, this.buildRangeUnitFromRecord(unitRecord, metadata));
            }
        }
        return range;
    }

    protected void compressRangeUnit(MMJRangeUnitRecord rangeUnitRecord, MMJRangeUnitRecord lastRangeUnit) throws DataCreationException {
    }

    protected void addRangeUnitToRange(IDataFileDataItem rangeItem, IDataFileDataItem unitItem) {
        ((GenericRange)rangeItem).addRangeUnit((GenericUnit)unitItem);
    }

    protected IDataFileDataItem buildRangeUnitFromRecord(MMJRangeUnitRecord record, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        IDataFileDataItem unit = this.getRangeUnitDataObject();
        this.populateRangeUnitInfo(record, unit, metadata);
        this.populateLocalRangeUnitInfo(record, unit, metadata);
        return unit;
    }

    @Override
    public String getSummaryInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\nGenericStreetBuilder Summary:");
        buffer.append("\n\tGenericStreet created: " + this.totalStreets);
        buffer.append("\n\tGenericSegments created: " + this.totalSegments);
        buffer.append("\n\tGenericRanges created: " + this.totalRanges);
        buffer.append("\n\tGenericRangeUnits created: " + this.totalRangeUnits);
        buffer.append("\n");
        return buffer.toString();
    }

    protected IDataFileDataItem getPostInfoDataObject() {
        return new PostInfoDataItem();
    }

    protected void populateLocalPostInfo(PostInfoRecord record, IDataFileDataItem postInfoItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
    }

    @Override
    public IDataFileDataItem buildPostInfoFromRecord(PostInfoRecord record, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        IDataFileDataItem item = this.getPostInfoDataObject();
        this.populatePostInfo(record, item, metadata);
        this.populateLocalPostInfo(record, item, metadata);
        return item;
    }

    protected void populatePostInfo(PostInfoRecord record, IDataFileDataItem postInfoItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        block10: {
            PostInfoDataItem postInfo = (PostInfoDataItem)postInfoItem;
            try {
                String postalCode1 = record.getPostalCode1();
                if (postalCode1 != null) {
                    String areaName4;
                    String areaName3;
                    String areaName2;
                    String areaName1;
                    String placeName;
                    postInfo.putString(0, record.getPostalCode1());
                    String postalCode2 = record.getPostalCode2();
                    if (postalCode2 != null) {
                        postInfo.putString(1, postalCode2);
                    }
                    postInfo.putByte(0, record.getPrecision());
                    DirectPosition centroid = record.getCentroid();
                    if (centroid != null) {
                        long xCoord = CompressedSegment.convertDoubleToLongAndRound((double)centroid.getX(), (byte)metadata.getXPow10());
                        long yCoord = CompressedSegment.convertDoubleToLongAndRound((double)centroid.getY(), (byte)metadata.getYPow10());
                        postInfo.putLong(0, xCoord);
                        postInfo.putLong(1, yCoord);
                    }
                    if ((placeName = record.getGenericField1()) != null) {
                        postInfo.putString(6, placeName);
                    }
                    if ((areaName1 = record.getAreaName1()) != null) {
                        postInfo.putString(2, areaName1);
                    }
                    if ((areaName2 = record.getAreaName2()) != null) {
                        postInfo.putString(3, areaName2);
                    }
                    if ((areaName3 = record.getAreaName3()) != null) {
                        postInfo.putString(4, areaName3);
                    }
                    if ((areaName4 = record.getAreaName4()) != null) {
                        postInfo.putString(5, areaName4);
                    }
                    break block10;
                }
                DataCreationLogger.getLogger().logInternalError("PostInfoRecord does not contain a postalCode1.");
                throw new DataCreationException(501);
            }
            catch (MMJETypeArraySizeExceededException e) {
                DataCreationLogger.getLogger().logInternalError("ERROR: Unable to build PostInfoDataItem.");
                DataCreationLogger.getLogger().logInternalError(e.getMessage());
                DataCreationLogger.getLogger().logStackTrace(e);
                throw new DataCreationException(501, (Throwable)e);
            }
        }
    }

    protected void populateLocalGeoInfo(GeoInfoRecord record, IDataFileDataItem geoInfoItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
    }

    protected IDataFileDataItem getGeoInfoDataObject() {
        return new GeoInfoDataItem();
    }

    @Override
    public IDataFileDataItem buildGeoInfoFromRecord(GeoInfoRecord record, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        IDataFileDataItem item = this.getGeoInfoDataObject();
        this.populateGeoInfo(record, item, metadata);
        this.populateLocalGeoInfo(record, item, metadata);
        return item;
    }

    protected void populateGeoInfo(GeoInfoRecord record, IDataFileDataItem geoInfoItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        FrequentDataFileStrings geoinfoFrequentStrings = metadata.getFrequentStrings();
        GeoInfoDataItem geoInfo = (GeoInfoDataItem)geoInfoItem;
        try {
            if (record.getAreaName1() != null && record.getAreaName1().length() != 0) {
                int areaName1Index = geoinfoFrequentStrings.getStringNumber(0, record.getAreaName1());
                if (areaName1Index != -1) {
                    geoInfo.putByte(1, FrequentDataFileStrings.convertIndexToByte((int)areaName1Index));
                } else {
                    geoInfo.putString(0, record.getAreaName1());
                }
            }
            if (record.getAreaName2() != null && record.getAreaName2().length() != 0) {
                int areaName2Index = geoinfoFrequentStrings.getStringNumber(1, record.getAreaName2());
                if (areaName2Index != -1) {
                    geoInfo.putByte(2, FrequentDataFileStrings.convertIndexToByte((int)areaName2Index));
                } else {
                    geoInfo.putString(1, record.getAreaName2());
                }
            }
            if (record.getAreaName3() != null && record.getAreaName3().length() != 0) {
                int areaName3Index = geoinfoFrequentStrings.getStringNumber(2, record.getAreaName3());
                if (areaName3Index != -1) {
                    geoInfo.putByte(3, FrequentDataFileStrings.convertIndexToByte((int)areaName3Index));
                } else {
                    geoInfo.putString(2, record.getAreaName3());
                }
            }
            if (record.getAreaName4() != null && record.getAreaName4().length() != 0) {
                int areaName4Index = geoinfoFrequentStrings.getStringNumber(3, record.getAreaName4());
                if (areaName4Index != -1) {
                    geoInfo.putByte(4, FrequentDataFileStrings.convertIndexToByte((int)areaName4Index));
                } else {
                    geoInfo.putString(3, record.getAreaName4());
                }
            }
            if (record.getAltAreaName1() != null && record.getAltAreaName1().length() != 0) {
                geoInfo.putString(4, record.getAltAreaName1());
            }
            if (record.getAltAreaName2() != null && record.getAltAreaName2().length() != 0) {
                geoInfo.putString(5, record.getAltAreaName2());
            }
            if (record.getAltAreaName3() != null && record.getAltAreaName3().length() != 0) {
                geoInfo.putString(6, record.getAltAreaName3());
            }
            if (record.getAltAreaName4() != null && record.getAltAreaName4().length() != 0) {
                geoInfo.putString(7, record.getAltAreaName4());
            }
            if (record.getPrecision() != 0) {
                geoInfo.putByte(0, record.getPrecision());
                DirectPosition pnt = record.getPoint();
                long xCoord = CompressedSegment.convertDoubleToLongAndRound((double)pnt.getX(), (byte)metadata.getXPow10());
                long yCoord = CompressedSegment.convertDoubleToLongAndRound((double)pnt.getY(), (byte)metadata.getYPow10());
                geoInfo.putLong(0, xCoord);
                geoInfo.putLong(1, yCoord);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to build GeoInfoDataItem.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(301, (Throwable)e);
        }
    }
}

