/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.dp.IIntermediateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.AbstractMMJAlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValue;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MMJRangeRecord
extends AbstractMMJAlternateDataRecord {
    public static final int ODD_EVEN_ODD = 1;
    public static final int ODD_EVEN_EVEN = 2;
    public static final int ODD_EVEN_BOTH = 0;
    public static final int ODD_EVEN_IRREGULAR = 5;
    protected ParsedNumber m_fromHouse = null;
    protected ParsedNumber m_toHouse = null;
    private String m_placeName = null;
    protected int m_oddEven = 0;
    protected boolean m_leftSide = true;
    private int pointRangeLocationPrecision;
    private boolean bIsPointRange;
    protected IIntermediateDataRecord[] m_IntermediateDataRecordArray = null;
    private ArrayList m_rangeUnits = null;
    private DirectPosition m_point;
    private Map<String, String> m_additionalFields;

    public MMJRangeRecord() {
        this.setPointRangeLocationPrecision(0);
    }

    public void setFromHouse(String fromHouse) {
        this.m_fromHouse = new ParsedNumber(fromHouse);
    }

    public ParsedNumber getFromHouse() {
        return this.m_fromHouse;
    }

    public void setToHouse(String toHouse) {
        this.m_toHouse = new ParsedNumber(toHouse);
    }

    public ParsedNumber getToHouse() {
        return this.m_toHouse;
    }

    public void setPlaceName(String placeName) {
        this.m_placeName = placeName;
    }

    public String getPlaceName() {
        return this.m_placeName;
    }

    public void setOddEven(int oddEven) {
        this.m_oddEven = oddEven;
    }

    public int getOddEven() {
        return this.m_oddEven;
    }

    public void setRight() {
        this.m_leftSide = false;
    }

    public void setLeft() {
        this.m_leftSide = true;
    }

    public boolean isLeft() {
        return this.m_leftSide;
    }

    public void setIntermediateDataRecordArray(IIntermediateDataRecord[] dataRecordArray) {
        this.m_IntermediateDataRecordArray = dataRecordArray;
    }

    public IIntermediateDataRecord[] getIntermediateDataRecordArray() {
        return this.m_IntermediateDataRecordArray;
    }

    public boolean isAscending() {
        if (this.m_fromHouse != null && this.m_toHouse != null) {
            return this.m_fromHouse.compareTo((Object)this.m_toHouse) <= 0;
        }
        return true;
    }

    public void addRangeUnit(MMJRangeUnitRecord unit) {
        if (this.m_rangeUnits == null) {
            this.m_rangeUnits = new ArrayList();
        }
        this.m_rangeUnits.add(unit);
    }

    public List getRangeUnits() {
        return this.m_rangeUnits;
    }

    public void setPoint(DirectPosition point) {
        this.m_point = point;
    }

    public DirectPosition getPoint() {
        return this.m_point;
    }

    public String toString() {
        return "MMJRangeRecord:\n\tFrom: " + this.m_fromHouse.getCombinedAddressNumber() + "\n\tTo: " + this.m_toHouse.getCombinedAddressNumber() + "\n\tPlaceName: " + this.m_placeName;
    }

    public boolean isValid() {
        if (this.getIntermediateDataRecordArray() != null) {
            return true;
        }
        if (this.getOddEven() == 5) {
            return true;
        }
        if (this.getFromHouse().isPureNumeric() && this.getToHouse().isPureNumeric()) {
            return true;
        }
        if (this.getFromHouse().getNumFields() != this.getToHouse().getNumFields()) {
            return false;
        }
        if (this.getFromHouse().getAddressNumberExists() != this.getToHouse().getAddressNumberExists()) {
            return false;
        }
        if (this.getFromHouse().getSuffixNumberExists() != this.getToHouse().getSuffixNumberExists()) {
            return false;
        }
        if (this.getFromHouse().isHyphenatedNumber() != this.getToHouse().isHyphenatedNumber()) {
            return false;
        }
        if (this.getFromHouse().getAddressPrefix() == null != (this.getToHouse().getAddressPrefix() == null)) {
            return false;
        }
        if (this.getFromHouse().getAddressSuffix() == null != (this.getToHouse().getAddressSuffix() == null)) {
            return false;
        }
        if (this.getFromHouse().getAddressTrailer() == null != (this.getToHouse().getAddressTrailer() == null)) {
            return false;
        }
        if (this.getFromHouse().getNumberSeparator() == null != (this.getToHouse().getNumberSeparator() == null)) {
            return false;
        }
        if (this.getFromHouse().getPrefixSeparator() == null != (this.getToHouse().getPrefixSeparator() == null)) {
            return false;
        }
        if (this.getFromHouse().getSuffixSeparator() == null != (this.getToHouse().getSuffixSeparator() == null)) {
            return false;
        }
        return this.getFromHouse().getTrailerSeparator() == null == (this.getToHouse().getTrailerSeparator() == null);
    }

    public List<SpatialIndexValue> getSpatialIndexValues() {
        List<SpatialIndexValue> spatialValues;
        if (this.getPoint() != null) {
            SpatialIndexValue spatialValue = new SpatialIndexValue();
            spatialValue.addPoint(this.getPoint());
            spatialValues = Collections.singletonList(spatialValue);
        } else {
            spatialValues = Collections.emptyList();
        }
        return spatialValues;
    }

    public int getPointRangeLocationPrecision() {
        return this.pointRangeLocationPrecision;
    }

    public void setPointRangeLocationPrecision(int pointRangeLocationPrecision) {
        this.pointRangeLocationPrecision = pointRangeLocationPrecision;
    }

    public boolean isPointRange() {
        return this.bIsPointRange;
    }

    public void setIsPointRange(boolean bIsPointRange) {
        this.bIsPointRange = bIsPointRange;
    }

    public void setAdditionalFields(Map<String, String> additionalFields) {
        this.m_additionalFields = Collections.unmodifiableMap(new HashMap<String, String>(additionalFields));
    }

    public boolean hasAdditionalFields() {
        return this.m_additionalFields != null && !this.m_additionalFields.isEmpty();
    }

    public Map<String, String> getAdditionalFields() {
        if (this.m_additionalFields == null) {
            return Collections.emptyMap();
        }
        return this.m_additionalFields;
    }
}

