/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.dp.binary.AbstractMMJAlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import java.util.ArrayList;
import java.util.List;

public class MMJStreetRecord
extends AbstractMMJAlternateDataRecord {
    private Address m_address = null;
    private MapMarkerIndexKey m_key = null;
    private int m_sac = -1;
    private MMJSegmentRecord m_segment = null;
    private ArrayList m_browseKeys = null;

    public MMJStreetRecord() {
    }

    public MMJStreetRecord(MMJStreetRecord that) {
        this();
        this.copy(that);
    }

    public void setAddress(Address address) {
        this.m_address = address;
    }

    public Address getAddress() {
        return this.m_address;
    }

    public void setKey(MapMarkerIndexKey key) {
        this.m_key = key;
    }

    public MapMarkerIndexKey getKey() {
        return this.m_key;
    }

    public void setSac(int sac) {
        this.m_sac = sac;
    }

    public int getSac() {
        return this.m_sac;
    }

    public void setSegment(MMJSegmentRecord segment) {
        this.m_segment = segment;
    }

    public MMJSegmentRecord getSegment() {
        return this.m_segment;
    }

    public void addBrowseKey(MapMarkerIndexKey key) {
        if (this.m_browseKeys == null) {
            this.m_browseKeys = new ArrayList();
        }
        this.m_browseKeys.add(key);
    }

    public List getBrowseKeys() {
        return this.m_browseKeys;
    }

    public void setBrowseKeys(ArrayList keys) {
        this.m_browseKeys = keys;
    }

    public boolean equals(Object that) {
        MMJStreetRecord thatRecord = (MMJStreetRecord)that;
        return this.m_key.equals(thatRecord.m_key) && this.m_address.getMainAddress().equals(thatRecord.m_address.getMainAddress());
    }

    public int compareTo(Object o2) {
        MMJStreetRecord record2 = (MMJStreetRecord)o2;
        if (this.equals(record2)) {
            return 0;
        }
        if (this.m_key.equals(record2.m_key)) {
            return this.m_address.getMainAddress().compareTo(record2.m_address.getMainAddress());
        }
        return this.m_key.compareTo((Object)record2.m_key);
    }

    public void copy(MMJStreetRecord that) {
        if (that != null) {
            this.setAddress((Address)new AddressImpl(that.getAddress()));
            this.setKey(that.getKey());
            this.setSac(that.getSac());
            this.setSegment(that.getSegment());
            if (that.m_browseKeys != null) {
                for (int i = 0; i < that.m_browseKeys.size(); ++i) {
                    MapMarkerIndexKey key = (MapMarkerIndexKey)that.m_browseKeys.get(i);
                    this.addBrowseKey(key);
                }
            }
            super.copy(that);
        }
    }

    public String toString() {
        String returnString = this.m_address.toString() + "\n" + this.m_segment.toString();
        List rangeList = this.m_segment.getRanges();
        if (rangeList != null) {
            for (MMJRangeRecord range : rangeList) {
                returnString = returnString + "\n" + range.toString();
            }
        }
        return returnString;
    }
}

