/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.io.RandomAccessFile;

public class MMJSupportedAltsWriter {
    private RandomAccessFile m_altSupportFile = null;

    protected MMJSupportedAltsWriter() {
    }

    protected byte[] getAltBrowseSupportedTypes() {
        return null;
    }

    protected byte[] getAltSearchSupportedTypes() {
        return null;
    }

    private void writeAltTypeArray(byte[] altTypes) {
        int altCount = altTypes == null ? 0 : altTypes.length;
        try {
            this.m_altSupportFile.writeInt(altCount);
            for (int i = 0; i < altCount; ++i) {
                this.m_altSupportFile.writeByte(altTypes[i]);
            }
        }
        catch (IOException IOEx) {
            System.err.println("ERROR: Unable to write to alt.mmj.");
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public final void createFile() {
        try {
            this.createFile(null);
        }
        catch (IOException ioex) {
            if (this.m_altSupportFile == null) {
                System.err.println("ERROR: Unable to create alt.mmj file.");
            } else {
                System.err.println("ERROR: Unable to close the alt.mmj file.");
            }
            System.err.println(ioex.getMessage());
            ioex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void createFile(String udPath) throws IOException {
        byte[] altBrowseTypes = this.getAltBrowseSupportedTypes();
        byte[] altSearchTypes = this.getAltSearchSupportedTypes();
        if (altBrowseTypes == null && altSearchTypes == null) {
            System.out.println("No file need be created, no alternates supported.");
            return;
        }
        System.out.println("Creating alt.mmj file.");
        String path = StringUtilities.appendToPath((String)udPath, (String)"alt.mmj");
        this.m_altSupportFile = new RandomAccessFile(path.toString(), "rw");
        this.writeAltTypeArray(altBrowseTypes);
        this.writeAltTypeArray(altSearchTypes);
        this.m_altSupportFile.close();
    }
}

