/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.StreetDataFileStatistics;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MultiSegmentStreet {
    private Address m_address;
    private ArrayList m_segments;
    private int m_lastCombinedSegment;
    private MapMarkerIndexKey m_key;
    private int m_sac;
    private List m_browseKeys;
    private List m_alternateDataItems;
    private MMJSegmentComparer m_segmentComparer;
    private MMJRangeRecordComparator m_rangeComparator;

    public MultiSegmentStreet(MMJStreetRecord streetRecord, MMJSegmentComparer segmentComparer) {
        this(streetRecord, segmentComparer, new MMJRangeRecordComparator());
    }

    public MultiSegmentStreet(MMJStreetRecord streetRecord, MMJSegmentComparer segmentComparer, MMJRangeRecordComparator rangeComparator) {
        this.m_address = streetRecord.getAddress();
        this.m_key = streetRecord.getKey();
        this.m_sac = streetRecord.getSac();
        this.m_segmentComparer = segmentComparer;
        this.m_rangeComparator = rangeComparator;
        this.m_segments = new ArrayList();
        this.addSegment(streetRecord.getSegment());
        this.m_lastCombinedSegment = -1;
        this.m_browseKeys = streetRecord.getBrowseKeys();
        this.m_alternateDataItems = streetRecord.getAlternateDataItems();
    }

    public Address getAddress() {
        return this.m_address;
    }

    public MapMarkerIndexKey getKey() {
        return this.m_key;
    }

    public int getSac() {
        return this.m_sac;
    }

    public List getBrowseKeys() {
        return this.m_browseKeys;
    }

    public void addSegment(MMJSegmentRecord segmentRecord) {
        if (segmentRecord.getRanges() == null) {
            if (this.combineSegment(segmentRecord)) {
                StreetDataFileStatistics stats = StreetDataFileStatistics.getStreetFileStatisticsObject();
                stats.incrementCombinedSegments();
                this.reCombineSegments();
                return;
            }
        } else if (segmentRecord.getPoints() == null && this.combineNoPointSegment(segmentRecord)) {
            return;
        }
        boolean isDuplicate = false;
        for (Object segment : this.m_segments) {
            if (!this.isDuplicateSegment((MMJSegmentRecord)segment, segmentRecord)) continue;
            isDuplicate = true;
            break;
        }
        if (!isDuplicate) {
            this.m_segments.add(segmentRecord);
        }
    }

    private boolean isDuplicateSegment(MMJSegmentRecord existingSegment, MMJSegmentRecord newSegment) {
        boolean newSegmentHasPoints;
        MMJSegmentRecord copyOfNewSegment = newSegment;
        if (!this.m_segmentComparer.segmentsCompare(existingSegment, copyOfNewSegment)) {
            copyOfNewSegment = this.getCopyOfSegment(newSegment);
            copyOfNewSegment.reverse();
            if (!this.m_segmentComparer.segmentsCompare(existingSegment, copyOfNewSegment)) {
                return false;
            }
        }
        boolean existingSegmentHasPoints = existingSegment.getPoints() != null && existingSegment.getPoints().size() > 0;
        boolean bl = newSegmentHasPoints = copyOfNewSegment.getPoints() != null && copyOfNewSegment.getPoints().size() > 0;
        if (existingSegmentHasPoints != newSegmentHasPoints) {
            return false;
        }
        if (!existingSegmentHasPoints || existingSegment.getIntersectionCase(copyOfNewSegment) == 5) {
            return this.rangesCompare(existingSegment.getRanges(), copyOfNewSegment.getRanges());
        }
        return false;
    }

    private boolean rangesCompare(List ranges1, List ranges2) {
        if (ranges1 == ranges2) {
            return true;
        }
        if (ranges1 == null) {
            return ranges2.size() == 0;
        }
        if (ranges2 == null) {
            return ranges1.size() == 0;
        }
        if (ranges1.size() != ranges2.size()) {
            return false;
        }
        for (Object o1 : ranges1) {
            boolean foundRange = false;
            for (Object o2 : ranges2) {
                if (this.m_rangeComparator.compare(o1, o2) != 0) continue;
                foundRange = true;
                break;
            }
            if (foundRange) continue;
            return false;
        }
        return true;
    }

    public List getSegments() {
        return this.m_segments;
    }

    protected boolean combineSegment(MMJSegmentRecord segmentRecord) {
        for (int i = 0; i < this.m_segments.size(); ++i) {
            int intersectionCase;
            MMJSegmentRecord oldSegment = (MMJSegmentRecord)this.m_segments.get(i);
            if (oldSegment.getRanges() != null || (intersectionCase = oldSegment.getIntersectionCase(segmentRecord)) == 0 || intersectionCase == 5 || !this.segmentsCanBeCombined(oldSegment, segmentRecord, intersectionCase)) continue;
            this.combineTwoSegments(oldSegment, segmentRecord, intersectionCase);
            this.m_lastCombinedSegment = i;
            return true;
        }
        return false;
    }

    protected MMJSegmentRecord getCopyOfSegment(MMJSegmentRecord segment) {
        return new MMJSegmentRecord(segment);
    }

    protected boolean segmentsCanBeCombined(MMJSegmentRecord segment1, MMJSegmentRecord segment2, int intersectionCase) {
        MMJSegmentRecord copy1 = this.getCopyOfSegment(segment1);
        MMJSegmentRecord copy2 = this.getCopyOfSegment(segment2);
        if (intersectionCase == 4) {
            copy1.reverse();
        } else if (intersectionCase == 3) {
            copy2.reverse();
        } else if (intersectionCase == 2) {
            copy1.reverse();
            copy2.reverse();
        }
        return this.m_segmentComparer.segmentsCompare(copy1, copy2);
    }

    protected void combineTwoSegments(MMJSegmentRecord fixedSegment, MMJSegmentRecord addedSegment, int intersectionCase) {
        if (intersectionCase == 4) {
            fixedSegment.reverse();
        } else if (intersectionCase == 3) {
            addedSegment.reverse();
        } else if (intersectionCase == 2) {
            fixedSegment.reverse();
            addedSegment.reverse();
        }
        if (intersectionCase != 5) {
            fixedSegment.getPoints().addAll(addedSegment.getPoints());
        }
    }

    protected void reCombineSegments() {
        int segmentCount = this.m_segments.size();
        if (segmentCount == 1) {
            return;
        }
        MMJSegmentRecord lastSegment = (MMJSegmentRecord)this.m_segments.get(this.m_lastCombinedSegment);
        boolean combinedSegment = false;
        for (int i = 0; i < segmentCount; ++i) {
            int intersectionCase;
            MMJSegmentRecord otherSegment;
            if (i == this.m_lastCombinedSegment || (otherSegment = (MMJSegmentRecord)this.m_segments.get(i)).getRanges() != null || (intersectionCase = otherSegment.getIntersectionCase(lastSegment)) == 0 || !this.segmentsCanBeCombined(otherSegment, lastSegment, intersectionCase)) continue;
            this.combineTwoSegments(otherSegment, lastSegment, intersectionCase);
            combinedSegment = true;
            break;
        }
        if (combinedSegment) {
            StreetDataFileStatistics stats = StreetDataFileStatistics.getStreetFileStatisticsObject();
            stats.incrementCombinedSegments();
            ArrayList<MMJSegmentRecord> tempList = new ArrayList<MMJSegmentRecord>(segmentCount - 1);
            for (int i = 0; i < segmentCount; ++i) {
                if (i == this.m_lastCombinedSegment) continue;
                MMJSegmentRecord segment = (MMJSegmentRecord)this.m_segments.get(i);
                tempList.add(segment);
            }
            this.m_segments = tempList;
        }
    }

    public List getAlternateDataItems() {
        ArrayList<AlternateDataItem> alternateDataItems = new ArrayList<AlternateDataItem>();
        if (this.m_alternateDataItems != null) {
            alternateDataItems.addAll(this.m_alternateDataItems);
        }
        short s = this.m_segments.size();
        for (short currentSegment = 0; currentSegment < s; currentSegment = (short)((short)(currentSegment + 1))) {
            MMJSegmentRecord segment = (MMJSegmentRecord)this.m_segments.get(currentSegment);
            if (segment.getAlternateDataItems() != null) {
                for (AlternateDataItem segmentItem : segment.getAlternateDataItems()) {
                    segmentItem.getAlternateDataRecord().setSegmentNumber(currentSegment);
                    alternateDataItems.add(segmentItem);
                }
            }
            if (segment.getRanges() == null) continue;
            Iterator rangeIterator = segment.getRanges().iterator();
            short currentRange = 0;
            while (rangeIterator.hasNext()) {
                MMJRangeRecord range = (MMJRangeRecord)rangeIterator.next();
                if (range.getAlternateDataItems() != null) {
                    for (AlternateDataItem rangeItem : range.getAlternateDataItems()) {
                        rangeItem.getAlternateDataRecord().setSegmentNumber(currentSegment);
                        rangeItem.getAlternateDataRecord().setRangeNumber(currentRange);
                        alternateDataItems.add(rangeItem);
                    }
                }
                if (range.getRangeUnits() != null) {
                    Iterator unitIterator = range.getRangeUnits().iterator();
                    short currentUnit = 0;
                    while (unitIterator.hasNext()) {
                        MMJRangeUnitRecord unit = (MMJRangeUnitRecord)unitIterator.next();
                        if (unit.getAlternateDataItems() != null) {
                            for (AlternateDataItem unitItem : unit.getAlternateDataItems()) {
                                unitItem.getAlternateDataRecord().setSegmentNumber(currentSegment);
                                unitItem.getAlternateDataRecord().setRangeNumber(currentRange);
                                unitItem.getAlternateDataRecord().setUnitNumber(currentUnit);
                                alternateDataItems.add(unitItem);
                            }
                        }
                        currentUnit = (short)(currentUnit + 1);
                    }
                }
                currentRange = (short)(currentRange + 1);
            }
        }
        return alternateDataItems;
    }

    public List<SpatialIndexValue> getSpatialIndexValues() {
        short s = this.m_segments.size();
        ArrayList<SpatialIndexValue> spatialValues = new ArrayList<SpatialIndexValue>(s);
        for (short currentSegment = 0; currentSegment < s; currentSegment = (short)(currentSegment + 1)) {
            MMJSegmentRecord segment = (MMJSegmentRecord)this.m_segments.get(currentSegment);
            List<SpatialIndexValue> segmentSpatial = segment.getSpatialIndexValues();
            for (SpatialIndexValue value : segmentSpatial) {
                value.setSegmentNumber(currentSegment);
            }
            spatialValues.addAll(segmentSpatial);
        }
        return spatialValues;
    }

    public boolean areSameStreet(MMJStreetRecord thatStreet) {
        if (!this.m_key.equals(thatStreet.getKey())) {
            return false;
        }
        Address thatAddress = thatStreet.getAddress();
        if (!this.equalStrings(this.m_address.getAddressNumber(), thatAddress.getAddressNumber())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getAreaName1(), thatAddress.getAreaName1())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getAreaName2(), thatAddress.getAreaName2())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getAreaName3(), thatAddress.getAreaName3())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getAreaName4(), thatAddress.getAreaName4())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getGenericField1(), thatAddress.getGenericField1())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getGenericField2(), thatAddress.getGenericField2())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getGenericField3(), thatAddress.getGenericField3())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getGenericField4(), thatAddress.getGenericField4())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getMainAddress(), thatAddress.getMainAddress())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getPlaceName(), thatAddress.getPlaceName())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getPostAddress(), thatAddress.getPostAddress())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getPostCode1(), thatAddress.getPostCode1())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getPostCode2(), thatAddress.getPostCode2())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getPostDirectional(), thatAddress.getPostDirectional())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getPostThoroughfareType(), thatAddress.getPostThoroughfareType())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getPreAddress(), thatAddress.getPreAddress())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getPreDirectional(), thatAddress.getPreDirectional())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getPreThoroughfareType(), thatAddress.getPreThoroughfareType())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getUnitType(), thatAddress.getUnitType())) {
            return false;
        }
        if (!this.equalStrings(this.m_address.getUnitValue(), thatAddress.getUnitValue())) {
            return false;
        }
        return this.compareAdditionalFields(this.m_address.getAdditionalFields(), thatAddress.getAdditionalFields());
    }

    private boolean compareAdditionalFields(HashMap fields1, HashMap fields2) {
        if (fields1 == null && fields2 != null) {
            return false;
        }
        if (fields1 != null && fields2 == null) {
            return false;
        }
        if (fields1 == null) {
            return true;
        }
        if (fields1.isEmpty() && !fields2.isEmpty()) {
            return false;
        }
        if (!fields1.isEmpty() && fields2.isEmpty()) {
            return false;
        }
        if (fields1.isEmpty()) {
            return true;
        }
        if (fields1.size() != fields2.size()) {
            return false;
        }
        Set fields1Keys = fields1.keySet();
        for (String key1 : fields1Keys) {
            String value2;
            if (!fields2.containsKey(key1)) {
                return false;
            }
            String value1 = (String)fields1.get(key1);
            if (this.equalStrings(value1, value2 = (String)fields2.get(key1))) continue;
            return false;
        }
        return true;
    }

    private boolean equalStrings(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    protected boolean combineNoPointSegment(MMJSegmentRecord segmentRecord) {
        for (int i = 0; i < this.m_segments.size(); ++i) {
            MMJSegmentRecord oldSegment = (MMJSegmentRecord)this.m_segments.get(i);
            if (oldSegment.getPoints() != null) continue;
            if (this.m_segmentComparer.segmentsCompare(segmentRecord, oldSegment)) {
                for (int j = 0; j < segmentRecord.getRanges().size(); ++j) {
                    oldSegment.addRange((MMJRangeRecord)segmentRecord.getRanges().get(j));
                }
                return true;
            }
            MMJSegmentRecord reversedSegment = this.getCopyOfSegment(segmentRecord);
            reversedSegment.reverse();
            if (!this.m_segmentComparer.segmentsCompare(reversedSegment, oldSegment)) continue;
            for (int j = 0; j < reversedSegment.getRanges().size(); ++j) {
                oldSegment.addRange((MMJRangeRecord)reversedSegment.getRanges().get(j));
            }
            return true;
        }
        return false;
    }
}

