/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import java.util.ArrayList;
import java.util.Collections;

public class StringFrequencyTable {
    private ArrayList m_strings = new ArrayList();

    public void addString(String str) {
        if (str == null) {
            return;
        }
        StringFrequency temp = new StringFrequency(str);
        if (this.m_strings.contains(temp)) {
            int index = this.m_strings.indexOf(temp);
            temp = (StringFrequency)this.m_strings.get(index);
            temp.incrementFrequency();
        } else {
            this.m_strings.add(temp);
        }
    }

    public int getStringCount() {
        return this.m_strings.size();
    }

    public String[] getMostFrequentStrings(int maxNumberOfStrings) {
        Collections.sort(this.m_strings);
        String[] mostFrequent = new String[maxNumberOfStrings];
        int numStrings = 0;
        for (int i = 0; i < this.m_strings.size() && i < maxNumberOfStrings; ++i) {
            StringFrequency temp = (StringFrequency)this.m_strings.get(i);
            mostFrequent[i] = temp.getString();
            ++numStrings;
        }
        if (numStrings < maxNumberOfStrings) {
            String[] temp = new String[numStrings];
            for (int i = 0; i < numStrings; ++i) {
                temp[i] = mostFrequent[i];
            }
            return temp;
        }
        return mostFrequent;
    }

    public int[] getFrequencyStatistics() {
        Collections.sort(this.m_strings);
        StringFrequency temp = (StringFrequency)this.m_strings.get(0);
        int numStrings = this.m_strings.size();
        int[] statistics = new int[temp.getFrequency() + 1];
        for (int i = 0; i < numStrings; ++i) {
            temp = (StringFrequency)this.m_strings.get(i);
            int n = temp.getFrequency();
            statistics[n] = statistics[n] + 1;
        }
        return statistics;
    }

    private class StringFrequency
    implements Comparable {
        private String m_str;
        private int m_frequency;

        public StringFrequency(String str) {
            this.m_str = str;
            this.m_frequency = 1;
        }

        public void incrementFrequency() {
            ++this.m_frequency;
        }

        public String getString() {
            return this.m_str;
        }

        public int getFrequency() {
            return this.m_frequency;
        }

        public int compareTo(Object that) {
            StringFrequency thatFreq = (StringFrequency)that;
            return thatFreq.m_frequency - this.m_frequency;
        }

        public int hashCode() {
            return this.m_str.hashCode();
        }

        public boolean equals(Object that) {
            StringFrequency thatFreq = (StringFrequency)that;
            return this.m_str.equals(thatFreq.m_str);
        }
    }
}

