/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.IInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.INIOInnerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.INIOInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexValue;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import java.io.IOException;

public abstract class AbstractNIOInnerIndex
implements INIOInnerIndex {
    private RandomAccessDataStream m_file;
    private IInnerIndexHelper m_helper;

    public AbstractNIOInnerIndex(RandomAccessDataStream file, IInnerIndexHelper helper) {
        this.m_file = file;
        this.m_helper = helper;
    }

    @Override
    public InnerIndexValue getValueAt(NIOInnerIndexLink link) throws IndexAccessException {
        try {
            RandomAccessDataStream file = this.getIndexFile();
            file.seek(link.getLink());
            NIOInnerIndexValue value = ((INIOInnerIndexHelper)this.getHelper()).getIndexFileValueType();
            value.read(file);
            return value;
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5002, (Throwable)IOEx);
        }
    }

    protected RandomAccessDataStream getIndexFile() {
        return this.m_file;
    }

    protected IInnerIndexHelper getHelper() {
        return this.m_helper;
    }

    protected MapMarkerIndexValue getValueFor(NIOInnerIndexItem item) throws IOException, IndexAccessException {
        if (this.getHelper().supportsMultiValue()) {
            MapMarkerIndexMultiValue multiValue = new MapMarkerIndexMultiValue();
            multiValue.addOffset(((MapMarkerIndexSingleValue)item.getValue().getValue()).getOffset());
            NIOInnerIndexLink link = (NIOInnerIndexLink)item.getValue().getNextValueLink();
            while (link.isLink()) {
                InnerIndexValue value = this.getValueAt(link);
                multiValue.addOffset(((MapMarkerIndexSingleValue)value.getValue()).getOffset());
                link = (NIOInnerIndexLink)value.getNextValueLink();
            }
            return multiValue;
        }
        return item.getValue().getValue();
    }

    protected NIOInnerIndexItem getItemAt(InnerIndexLink link) throws IOException {
        RandomAccessDataStream file = this.getIndexFile();
        file.seek(link.getLink());
        NIOInnerIndexItem item = ((INIOInnerIndexHelper)this.getHelper()).getIndexFileItemType();
        item.read(file);
        return item;
    }

    protected final void updateLink(NIOInnerIndexLink link) throws IOException {
        link.update(this.getIndexFile());
    }

    protected final void addValue(NIOInnerIndexLink link, NIOInnerIndexValue value) throws IOException {
        RandomAccessDataStream file = this.getIndexFile();
        while (link.isLink()) {
            NIOInnerIndexValue tempValue = ((INIOInnerIndexHelper)this.getHelper()).getIndexFileValueType();
            file.seek(link.getLink());
            tempValue.read(file);
            link = (NIOInnerIndexLink)tempValue.getNextValueLink();
        }
        file.seek(file.length());
        link.setLink(file.getFilePointer());
        this.updateLink(link);
        value.write(file);
    }

    protected void addEntry(NIOInnerIndexLink link, NIOInnerIndexItem item) throws IOException {
        RandomAccessDataStream file = this.getIndexFile();
        file.seek(file.length());
        link.setLink(file.getFilePointer());
        item.write(file);
        this.updateLink(link);
    }
}

