/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.BrowseIndexer;
import java.io.File;

public class BrowseIndexerRunner {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: BrowseIndexerRunner [tbxFilePathAndBaseName]");
            System.exit(0);
        }
        System.out.println("args[0]: " + args[0]);
        File tbxFile = new File(args[0] + ".tbx");
        System.out.println("tbxFile: " + tbxFile.getAbsolutePath());
        if (tbxFile.exists()) {
            System.out.println("tbxFile size: " + tbxFile.length() + " bytes");
            File bdxFile = new File(args[0] + ".bdx");
            System.out.println("bdxFile: " + bdxFile.getAbsolutePath());
            DataCreationLogger logger = DataCreationLogger.getLogger();
            logger.setErrorLog(args[0] + ".err", true);
            logger.setInternalErrorLog(args[0] + "_int.err", true);
            logger.setStatusLog(args[0] + ".log", true);
            BrowseIndexer browseConvertor = new BrowseIndexer(tbxFile.getAbsolutePath(), bdxFile.getAbsolutePath());
            try {
                browseConvertor.convert();
            }
            catch (DataCreationException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Could not find " + tbxFile.getAbsolutePath() + ".  Exiting.");
            System.exit(0);
        }
    }
}

