/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;

public class InnerIndexLink
implements MapMarkerIndexValue {
    protected static final long NO_LINK = -1L;
    private long m_link;
    private long m_linkToThis;

    public InnerIndexLink() {
        this(-1L);
    }

    public InnerIndexLink(long link) {
        this.m_link = link;
        this.m_linkToThis = -1L;
    }

    public static InnerIndexLink getNoLinkLink() {
        return new InnerIndexLink();
    }

    public void setLink(long link) {
        this.m_link = link;
    }

    public long getLink() {
        return this.m_link;
    }

    protected void setLinkToLink(long linkToLink) {
        this.m_linkToThis = linkToLink;
    }

    public long getLinkToLink() {
        return this.m_linkToThis;
    }

    public boolean isLink() {
        return this.m_link != -1L;
    }

    public void write(DataOutput out) throws IOException {
        this.m_linkToThis = ((RandomAccessFile)out).getFilePointer();
        out.writeLong(this.m_link);
    }

    public void read(DataInput in) throws IOException {
        this.m_linkToThis = ((RandomAccessFile)in).getFilePointer();
        this.m_link = in.readLong();
    }

    public void update(RandomAccessFile file) throws IOException {
        if (this.m_linkToThis != -1L) {
            long currentOffset = file.getFilePointer();
            file.seek(this.m_linkToThis);
            this.write(file);
            file.seek(currentOffset);
        }
    }

    public boolean equals(Object that) {
        return this.m_link == ((InnerIndexLink)that).m_link;
    }
}

