/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.AbstractFileInnerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.FileInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.FileInnerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.IInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.LinkedListFileInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;

public class LinkedListFileInnerIndex
extends AbstractFileInnerIndex {
    private ListHeader m_header = new ListHeader();

    public LinkedListFileInnerIndex(RandomAccessFile file, IInnerIndexHelper helper) {
        super(file, helper);
    }

    @Override
    public void create(InnerIndexLink link) throws IndexAccessException {
        RandomAccessFile file = this.getIndexFile();
        try {
            file.seek(file.length());
            link.setLink(file.getFilePointer());
            this.m_header.write(file);
            link.update(file);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5000, (Throwable)IOEx);
        }
    }

    @Override
    public void access(InnerIndexLink link) throws IndexAccessException {
        RandomAccessFile file = this.getIndexFile();
        try {
            file.seek(link.getLink());
            this.m_header.read(file);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5002, (Throwable)IOEx);
        }
    }

    @Override
    public boolean insert(MapMarkerIndexKey key, MapMarkerIndexValue value) throws IndexAccessException {
        return this.insert(new LinkedListFileInnerIndexItem(key, new FileInnerIndexValue(value)));
    }

    @Override
    public void write(InnerIndexLink link, RandomAccessFile outputFile) throws IndexAccessException {
        try {
            outputFile.seek(outputFile.length());
            link.setLink(outputFile.getFilePointer());
            outputFile.writeShort(this.m_header.getCount());
            link.update(outputFile);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5002, (Throwable)IOEx);
        }
        InnerIndexLink listLink = this.m_header.getFirstItemLink();
        while (listLink.isLink()) {
            LinkedListFileInnerIndexItem item;
            try {
                item = (LinkedListFileInnerIndexItem)this.getItemAt(listLink);
            }
            catch (IOException IOEx) {
                throw new IndexAccessException(5002, (Throwable)IOEx);
            }
            try {
                item.getKey().write((DataOutput)outputFile);
                this.getValueFor(item).write((DataOutput)outputFile);
                listLink = item.getNextLink();
            }
            catch (IOException IOEx) {
                throw new IndexAccessException(5002, (Throwable)IOEx);
            }
        }
    }

    private boolean insert(LinkedListFileInnerIndexItem item) throws IndexAccessException {
        InnerIndexLink link = this.m_header.getFirstItemLink();
        while (link.isLink()) {
            LinkedListFileInnerIndexItem listItem;
            try {
                listItem = (LinkedListFileInnerIndexItem)this.getItemAt(link);
            }
            catch (IOException IOEx) {
                throw new IndexAccessException(5002, (Throwable)IOEx);
            }
            int keyRelation = item.getKey().compareTo((Object)listItem.getKey());
            if (keyRelation == 0) {
                try {
                    this.addValue(listItem.getValue().getNextValueLink(), (FileInnerIndexValue)item.getValue());
                    return false;
                }
                catch (IOException IOEx) {
                    throw new IndexAccessException(5002, (Throwable)IOEx);
                }
            }
            if (keyRelation > 0) {
                link = listItem.getNextLink();
                continue;
            }
            try {
                item.getNextLink().setLink(link.getLink());
                this.addEntry(link, item);
                return true;
            }
            catch (IOException IOEx) {
                throw new IndexAccessException(5004, (Throwable)IOEx);
            }
        }
        try {
            this.addEntry(link, item);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5004, (Throwable)IOEx);
        }
        return true;
    }

    @Override
    protected void addEntry(InnerIndexLink link, FileInnerIndexItem item) throws IOException {
        super.addEntry(link, item);
        this.m_header.incrementCount();
        this.m_header.update(this.getIndexFile());
    }

    private static class ListHeader {
        private int m_itemCount = 0;
        private InnerIndexLink m_firstItemLink = InnerIndexLink.getNoLinkLink();
        private long m_selfLink;

        private ListHeader() {
        }

        private void incrementCount() {
            ++this.m_itemCount;
        }

        private int getCount() {
            return this.m_itemCount;
        }

        private InnerIndexLink getFirstItemLink() {
            return this.m_firstItemLink;
        }

        private void write(RandomAccessFile file) throws IOException {
            this.m_selfLink = file.getFilePointer();
            file.writeInt(this.m_itemCount);
            this.m_firstItemLink.write(file);
        }

        private void read(RandomAccessFile file) throws IOException {
            this.m_selfLink = file.getFilePointer();
            this.m_itemCount = file.readInt();
            this.m_firstItemLink.read(file);
        }

        private void update(RandomAccessFile file) throws IOException {
            long currentOffset = file.getFilePointer();
            file.seek(this.m_selfLink);
            this.write(file);
            file.seek(currentOffset);
        }
    }
}

