/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.AbstractNIOInnerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.LinkedListNIOInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexValue;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LinkedListNIOInnerIndex
extends AbstractNIOInnerIndex {
    private ListHeader m_header = new ListHeader();

    public LinkedListNIOInnerIndex(RandomAccessDataStream file, IInnerIndexHelper helper) {
        super(file, helper);
    }

    @Override
    public void create(NIOInnerIndexLink link) throws IndexAccessException {
        RandomAccessDataStream file = this.getIndexFile();
        try {
            file.seek(file.length());
            link.setLink(file.getFilePointer());
            this.m_header.write(file);
            link.update(file);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5000, (Throwable)IOEx);
        }
    }

    @Override
    public void access(NIOInnerIndexLink link) throws IndexAccessException {
        RandomAccessDataStream file = this.getIndexFile();
        try {
            file.seek(link.getLink());
            this.m_header.read(file);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5002, (Throwable)IOEx);
        }
    }

    @Override
    public boolean insert(MapMarkerIndexKey key, MapMarkerIndexValue value) throws IndexAccessException {
        return this.insert(new LinkedListNIOInnerIndexItem(key, new NIOInnerIndexValue(value)));
    }

    @Override
    public void write(NIOInnerIndexLink link, RandomAccessDataStream outputFile) throws IndexAccessException {
        try {
            outputFile.seek(outputFile.length());
            link.setLink(outputFile.getFilePointer());
            outputFile.writeShort(this.m_header.getCount());
            link.update(outputFile);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5002, (Throwable)IOEx);
        }
        NIOInnerIndexLink listLink = this.m_header.getFirstItemLink();
        while (listLink.isLink()) {
            LinkedListNIOInnerIndexItem item;
            try {
                item = (LinkedListNIOInnerIndexItem)this.getItemAt(listLink);
            }
            catch (IOException IOEx) {
                throw new IndexAccessException(5002, (Throwable)IOEx);
            }
            try {
                item.getKey().write((DataOutput)outputFile);
                this.getValueFor(item).write((DataOutput)outputFile);
                listLink = (NIOInnerIndexLink)item.getNextLink();
            }
            catch (IOException IOEx) {
                throw new IndexAccessException(5002, (Throwable)IOEx);
            }
        }
    }

    private boolean insert(LinkedListNIOInnerIndexItem item) throws IndexAccessException {
        NIOInnerIndexLink link = this.m_header.getFirstItemLink();
        while (link.isLink()) {
            LinkedListNIOInnerIndexItem listItem;
            try {
                listItem = (LinkedListNIOInnerIndexItem)this.getItemAt(link);
            }
            catch (IOException IOEx) {
                throw new IndexAccessException(5002, (Throwable)IOEx);
            }
            int keyRelation = item.getKey().compareTo((Object)listItem.getKey());
            if (keyRelation == 0) {
                try {
                    this.addValue((NIOInnerIndexLink)listItem.getValue().getNextValueLink(), (NIOInnerIndexValue)item.getValue());
                    return false;
                }
                catch (IOException IOEx) {
                    throw new IndexAccessException(5002, (Throwable)IOEx);
                }
            }
            if (keyRelation > 0) {
                link = (NIOInnerIndexLink)listItem.getNextLink();
                continue;
            }
            try {
                item.getNextLink().setLink(link.getLink());
                this.addEntry(link, item);
                return true;
            }
            catch (IOException IOEx) {
                throw new IndexAccessException(5004, (Throwable)IOEx);
            }
        }
        try {
            this.addEntry(link, item);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5004, (Throwable)IOEx);
        }
        return true;
    }

    @Override
    protected void addEntry(NIOInnerIndexLink link, NIOInnerIndexItem item) throws IOException {
        super.addEntry(link, item);
        this.m_header.incrementCount();
        this.m_header.update(this.getIndexFile());
    }

    private static class ListHeader {
        private int m_itemCount = 0;
        private NIOInnerIndexLink m_firstItemLink = new NIOInnerIndexLink();
        private long m_selfLink;

        private ListHeader() {
        }

        private void incrementCount() {
            ++this.m_itemCount;
        }

        private int getCount() {
            return this.m_itemCount;
        }

        private NIOInnerIndexLink getFirstItemLink() {
            return this.m_firstItemLink;
        }

        private void write(RandomAccessDataStream file) throws IOException {
            this.m_selfLink = file.getFilePointer();
            file.writeInt(this.m_itemCount);
            this.m_firstItemLink.write((DataOutput)file);
        }

        private void read(RandomAccessDataStream file) throws IOException {
            this.m_selfLink = file.getFilePointer();
            this.m_itemCount = file.readInt();
            this.m_firstItemLink.read((DataInput)file);
        }

        private void update(RandomAccessDataStream file) throws IOException {
            long currentOffset = file.getFilePointer();
            file.seek(this.m_selfLink);
            this.write(file);
            file.seek(currentOffset);
        }
    }
}

