/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.BinaryTree;
import com.mapinfo.mapmarker.common.dp.binary.index.BinaryTreeNode;
import com.mapinfo.mapmarker.common.dp.binary.index.DuplicateKeyException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileItem;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeItem;
import com.mapinfo.mapmarker.common.dp.binary.index.WritableRedBlackTree;
import com.mapinfo.mapmarker.common.dp.binary.index.WritableTreeItem;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class MapMarkerBinaryIndexFile {
    protected WritableRedBlackTree tree = null;
    protected RandomAccessFile file = null;
    protected MapMarkerIndexFileMetadata metadata = null;
    protected MapMarkerIndexFileItem indexRoot = null;
    BinaryTree cache = null;
    private static final int CACHE_LEVELS = 8;

    public void open(String fileName) throws IOException {
        this.file = new RandomAccessFile(fileName, "r");
        this.metadata = this.getIndexMetadataType();
        this.metadata.read((DataInput)this.file);
        this.indexRoot = this.getIndexItem();
        this.indexRoot.read(this.file);
        this.createCache();
    }

    public void create(String fileName, MapMarkerIndexFileMetadata metadata) throws IOException {
        File fileRef = new File(fileName);
        if (fileRef.exists() && !fileRef.delete()) {
            System.err.println("Unable to remove file: " + fileName);
        }
        this.file = new RandomAccessFile(fileName, "rw");
        this.tree = new WritableRedBlackTree(this.file);
        this.metadata = metadata;
    }

    public void write() throws IOException {
        this.metadata.write((DataOutput)this.file);
        this.tree.write();
    }

    public void close() throws IOException {
        this.file.close();
        this.indexRoot = null;
        this.metadata = null;
        if (this.tree != null) {
            this.tree.dispose();
            this.tree = null;
        }
        if (this.cache != null) {
            this.cache.dispose();
            this.cache = null;
        }
    }

    public MapMarkerIndexValue search(MapMarkerIndexKey key) throws IOException {
        return this.searchCache(this.cache.root, key);
    }

    private MapMarkerIndexValue searchCache(BinaryTreeNode node, MapMarkerIndexKey key) throws IOException {
        if (node.getItem().getKey().equals(key)) {
            return (MapMarkerIndexValue)node.getItem().getValue();
        }
        if (node.getItem().getKey().compareTo(key) < 0) {
            if (node.getRight() != BinaryTree.z) {
                return this.searchCache(node.getRight(), key);
            }
            return this.search(((WritableTreeItem)node.getItem()).getRightChildPosition(), key);
        }
        if (node.getLeft() != BinaryTree.z) {
            return this.searchCache(node.getLeft(), key);
        }
        return this.search(((WritableTreeItem)node.getItem()).getLeftChildPosition(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapMarkerIndexValue search(long offset, MapMarkerIndexKey key) throws IOException {
        MapMarkerIndexFileItem currentItem;
        if (offset == -1L) {
            return null;
        }
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            this.file.seek(offset);
            currentItem = this.getIndexItem();
            currentItem.read(this.file);
        }
        if (key.equals(currentItem.getKey())) {
            return (MapMarkerIndexValue)currentItem.getValue();
        }
        if (key.compareTo((Object)currentItem.getKey()) < 0) {
            return this.search(currentItem.getLeftChildPosition(), key);
        }
        return this.search(currentItem.getRightChildPosition(), key);
    }

    private void createCache() throws IOException {
        this.cache = new BinaryTree();
        int count = 0;
        this.cache.root = new BinaryTreeNode((TreeItem)this.indexRoot);
        this.cache.root.left = this.getNodeAt(this.indexRoot.getLeftChildPosition(), count);
        this.cache.root.right = this.getNodeAt(this.indexRoot.getRightChildPosition(), count);
    }

    private BinaryTreeNode getNodeAt(long position, int count) throws IOException {
        if (count < 8 && position > 0L) {
            this.file.seek(position);
            MapMarkerIndexFileItem item = this.getIndexItem();
            item.read(this.file);
            BinaryTreeNode itemNode = new BinaryTreeNode((TreeItem)item);
            itemNode.left = this.getNodeAt(item.getLeftChildPosition(), ++count);
            itemNode.right = this.getNodeAt(item.getRightChildPosition(), count);
            return itemNode;
        }
        return BinaryTree.z;
    }

    protected abstract MapMarkerIndexFileMetadata getIndexMetadataType();

    protected abstract MapMarkerIndexFileItem getIndexItem(MapMarkerIndexKey var1, MapMarkerIndexValue var2);

    protected abstract MapMarkerIndexFileItem getIndexItem();

    public void addIndexEntry(MapMarkerIndexKey key, MapMarkerIndexValue value) throws DuplicateKeyException {
        MapMarkerIndexFileItem item = this.getIndexItem(key, value);
        this.tree.insert((TreeItem)item);
    }
}

