/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.DuplicateKeyException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndexItem;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.List;

public abstract class MapMarkerSubIndex {
    protected RandomAccessFile m_indexFile;
    protected long m_indexOrigin;
    protected boolean m_readFully;
    protected boolean m_isTerminal;
    private List m_nextIndexLinks;

    public MapMarkerSubIndex(RandomAccessFile indexFile) {
        this.m_indexFile = indexFile;
        this.m_indexOrigin = -1L;
        this.m_readFully = false;
        this.m_isTerminal = true;
    }

    public MapMarkerSubIndex(long indexOrigin, RandomAccessFile indexFile, boolean readFully) {
        this.m_indexOrigin = indexOrigin;
        this.m_indexFile = indexFile;
        this.m_readFully = readFully;
        this.m_isTerminal = true;
    }

    public boolean isTerminal() {
        return this.m_isTerminal;
    }

    public long getIndexOffset() {
        return -1L;
    }

    public abstract MapMarkerSubIndexItem insert(MapMarkerIndexKey var1, MapMarkerIndexValue var2) throws DuplicateKeyException;

    public abstract Object search(MapMarkerIndexKey var1) throws IOException;

    public abstract MapMarkerSubIndexItem searchForItem(MapMarkerIndexKey var1);

    public abstract long write() throws IOException;

    protected void addSubIndexLink(Object o) {
        if (this.m_nextIndexLinks == null) {
            this.m_nextIndexLinks = new LinkedList();
        }
        this.m_nextIndexLinks.add(o);
    }

    protected List getSubIndexLinks() {
        return this.m_nextIndexLinks;
    }

    protected abstract Comparable getSubIndexKey();

    protected abstract Object getSubIndexValue();

    protected abstract MapMarkerSubIndexItem getIndexItem();

    protected abstract MapMarkerSubIndexItem getIndexItem(Comparable var1, Object var2);
}

