/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.BinaryTree;
import com.mapinfo.mapmarker.common.dp.binary.index.BinaryTreeNode;
import com.mapinfo.mapmarker.common.dp.binary.index.DuplicateKeyException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndexNextIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndexNonTerminalValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerTreeSubIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.RedBlackTree;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeItem;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class MapMarkerTreeSubIndex
extends MapMarkerSubIndex {
    protected RedBlackTree m_createTree;
    protected BinaryTree m_searchTree;

    public MapMarkerTreeSubIndex(long indexOrigin, RandomAccessFile indexFile, boolean readFully) throws IOException {
        super(indexOrigin, indexFile, readFully);
        this.m_searchTree = null;
        this.m_createTree = null;
        if (this.m_readFully) {
            this.readFully();
        }
    }

    public MapMarkerTreeSubIndex(RandomAccessFile indexFile) {
        super(indexFile);
        this.m_createTree = new RedBlackTree();
        this.m_searchTree = null;
    }

    @Override
    public MapMarkerSubIndexItem insert(MapMarkerIndexKey key, MapMarkerIndexValue value) throws DuplicateKeyException {
        MapMarkerTreeSubIndexItem item = (MapMarkerTreeSubIndexItem)this.getIndexItem((Comparable)key, value);
        this.m_createTree.insert((TreeItem)item);
        return item;
    }

    private void readFully() throws IOException {
        this.m_searchTree = new BinaryTree();
        this.m_searchTree.root = this.getNodeAt(this.m_indexOrigin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryTreeNode getNodeAt(long offset) throws IOException {
        if (offset > 0L) {
            MapMarkerTreeSubIndexItem item = (MapMarkerTreeSubIndexItem)this.getIndexItem();
            RandomAccessFile randomAccessFile = this.m_indexFile;
            synchronized (randomAccessFile) {
                this.m_indexFile.seek(offset);
                item.read(this.m_indexFile);
            }
            BinaryTreeNode itemNode = new BinaryTreeNode((TreeItem)item);
            itemNode.left = this.getNodeAt(item.getLeftChildPosition());
            itemNode.right = this.getNodeAt(item.getRightChildPosition());
            return itemNode;
        }
        return BinaryTree.z;
    }

    @Override
    public MapMarkerSubIndexItem searchForItem(MapMarkerIndexKey key) {
        if (this.m_createTree == null) {
            return null;
        }
        return (MapMarkerSubIndexItem)this.searchTree(this.m_createTree.root, key);
    }

    @Override
    public Object search(MapMarkerIndexKey key) throws IOException {
        if (this.m_searchTree != null) {
            TreeItem item = this.searchTree(this.m_searchTree.root, key);
            if (item != null) {
                return item.getValue();
            }
            return null;
        }
        TreeItem item = this.searchFile(this.m_indexOrigin, key);
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    private TreeItem searchTree(BinaryTreeNode node, MapMarkerIndexKey key) {
        if (node == BinaryTree.z) {
            return null;
        }
        TreeItem nodeItem = node.getItem();
        Comparable nodeKey = nodeItem.getKey();
        int keyRelation = nodeKey.compareTo(key);
        if (keyRelation == 0) {
            return nodeItem;
        }
        if (keyRelation < 0) {
            return this.searchTree(node.getRight(), key);
        }
        return this.searchTree(node.getLeft(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeItem searchFile(long offset, MapMarkerIndexKey key) throws IOException {
        if (offset == -1L) {
            return null;
        }
        MapMarkerTreeSubIndexItem item = (MapMarkerTreeSubIndexItem)this.getIndexItem();
        RandomAccessFile randomAccessFile = this.m_indexFile;
        synchronized (randomAccessFile) {
            this.m_indexFile.seek(offset);
            item.read(this.m_indexFile);
        }
        Comparable treeKey = item.getKey();
        int keyRelation = treeKey.compareTo(key);
        if (keyRelation == 0) {
            return item;
        }
        if (keyRelation > 0) {
            return this.searchFile(item.getLeftChildPosition(), key);
        }
        return this.searchFile(item.getRightChildPosition(), key);
    }

    @Override
    public long write() throws IOException {
        if (this.m_isTerminal) {
            return this.writeTerminalNode(this.m_createTree.root);
        }
        return this.writeNonTerminalNode(this.m_createTree.root);
    }

    private long writeTerminalNode(BinaryTreeNode node) throws IOException {
        if (node == BinaryTree.z) {
            return -1L;
        }
        long position = this.m_indexFile.length();
        this.m_indexFile.seek(position);
        ((MapMarkerTreeSubIndexItem)node.getItem()).write(this.m_indexFile);
        long leftPosition = this.writeTerminalNode(node.left);
        long rightPosition = this.writeTerminalNode(node.right);
        ((MapMarkerTreeSubIndexItem)node.getItem()).setLeftChildPosition(leftPosition);
        ((MapMarkerTreeSubIndexItem)node.getItem()).setRightChildPosition(rightPosition);
        this.updateNode(position, node);
        return position;
    }

    private long writeNonTerminalNode(BinaryTreeNode node) throws IOException {
        if (node == BinaryTree.z) {
            return -1L;
        }
        long position = this.m_indexFile.length();
        this.m_indexFile.seek(position);
        MapMarkerTreeSubIndexItem item = (MapMarkerTreeSubIndexItem)this.getIndexItem(node.getItem().getKey(), new MapMarkerSubIndexNextIndexValue());
        BinaryTreeNode newNode = new BinaryTreeNode((TreeItem)item);
        newNode.attachLeft(node.getLeft());
        newNode.attachRight(node.getRight());
        ((MapMarkerTreeSubIndexItem)newNode.getItem()).write(this.m_indexFile);
        long leftPosition = this.writeNonTerminalNode(newNode.left);
        long rightPosition = this.writeNonTerminalNode(newNode.right);
        MapMarkerSubIndexNonTerminalValue subIndexValue = (MapMarkerSubIndexNonTerminalValue)newNode.getItem().getValue();
        subIndexValue.setSubIndex((Object)((MapMarkerSubIndex)node.getItem().getValue()));
        this.addSubIndexLink(newNode.getItem().getValue());
        ((MapMarkerTreeSubIndexItem)newNode.getItem()).setLeftChildPosition(leftPosition);
        ((MapMarkerTreeSubIndexItem)newNode.getItem()).setRightChildPosition(rightPosition);
        this.updateNode(position, newNode);
        return position;
    }

    private void updateNode(long offset, BinaryTreeNode node) throws IOException {
        this.m_indexFile.seek(offset);
        MapMarkerTreeSubIndexItem item = (MapMarkerTreeSubIndexItem)node.getItem();
        item.write(this.m_indexFile);
    }

    @Override
    public MapMarkerSubIndexItem getIndexItem() {
        return new MapMarkerTreeSubIndexItem(this.getSubIndexKey(), this.getSubIndexValue());
    }

    @Override
    public MapMarkerSubIndexItem getIndexItem(Comparable key, Object value) {
        return new MapMarkerTreeSubIndexItem(key, value);
    }
}

