/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.DuplicateKeyException;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.utils.DebugLevel;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class MultiValueIndexFileConvertor
extends IndexFileConvertor {
    protected MultiValueIndexFileConvertor(String originalIndexFileName, String newIndexFileName) {
        super(originalIndexFileName, newIndexFileName);
    }

    @Override
    protected MapMarkerIndexValue getIndexValueType() {
        return null;
    }

    @Override
    public void convert() throws DataCreationException {
        this.m_oldIndex = null;
        this.m_newIndex = this.getIndexFileType();
        try {
            this.m_oldIndex = new RandomAccessFile(this.m_originalIndexFileName, "r");
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to open old index file: " + this.m_originalIndexFileName);
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(-1, (Throwable)e);
        }
        try {
            this.m_newIndex.create(this.m_newIndexFileName, this.getIndexMetadataType());
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to create new index file: " + this.m_newIndexFileName);
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(e);
        }
        LinkedList<IntermediateIndexEntry> entries = new LinkedList<IntermediateIndexEntry>();
        try {
            while (true) {
                MapMarkerIndexKey key = this.getIndexKeyType();
                MapMarkerIndexSingleValue value = new MapMarkerIndexSingleValue();
                key.read((DataInput)this.m_oldIndex);
                value.read((DataInput)this.m_oldIndex);
                IntermediateIndexEntry entry = new IntermediateIndexEntry(key, value);
                entries.add(entry);
            }
        }
        catch (EOFException EOFEx) {
            try {
                this.m_oldIndex.close();
            }
            catch (IOException IOEx) {
                DataCreationLogger.getLogger().logInternalError("ERROR: Unable to close old index file.");
                DataCreationLogger.getLogger().logInternalError(IOEx.getMessage());
                DataCreationLogger.getLogger().logStackTrace(IOEx);
            }
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("An error occurred reading the original index file.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(e);
        }
        DataCreationLogger.getLogger().logStatus("Finished reading old index.");
        if (DebugLevel.getDebugLevel((int)5) >= 1) {
            DataCreationLogger.getLogger().logMemoryUsage();
            DataCreationLogger.getLogger().logStatus("Setting old index to null.");
        }
        this.m_oldIndex = null;
        if (DebugLevel.getDebugLevel((int)5) >= 1) {
            DataCreationLogger.getLogger().logMemoryUsageWithGC();
        }
        Collections.sort(entries);
        if (DebugLevel.getDebugLevel((int)5) >= 1) {
            DataCreationLogger.getLogger().logStatus("Finished sorting.");
        }
        Iterator entryIterator = entries.iterator();
        if (DebugLevel.getDebugLevel((int)5) >= 1) {
            DataCreationLogger.getLogger().logStatus("Got the iterator.");
        }
        boolean firstEntry = true;
        Object currentKey = null;
        MapMarkerIndexMultiValue currentValue = new MapMarkerIndexMultiValue();
        long totalEntries = entries.size();
        long currentEntry = 0L;
        if (DebugLevel.getDebugLevel((int)5) >= 1) {
            DataCreationLogger.getLogger().logStatus("Entering the while loop...");
        }
        while (entryIterator.hasNext()) {
            DataCreationLogger.getLogger().logStatusNoLF("Processing entry: " + ++currentEntry + " of " + totalEntries + "\r");
            IntermediateIndexEntry entry = (IntermediateIndexEntry)entryIterator.next();
            if (firstEntry) {
                firstEntry = false;
                currentKey = entry.getKey();
                currentValue.addOffset(entry.getValue().getOffset());
                entryIterator.remove();
                continue;
            }
            if (currentKey.equals(entry.getKey())) {
                currentValue.addOffset(entry.getValue().getOffset());
            } else {
                try {
                    this.m_newIndex.addIndexEntry((MapMarkerIndexKey)currentKey, (MapMarkerIndexValue)currentValue);
                }
                catch (DuplicateKeyException e) {
                    DataCreationLogger.getLogger().logInternalError("ERROR: Attempt to add duplicate key to new index.");
                    DataCreationLogger.getLogger().logInternalError("\tUnable to add key for entry: " + currentEntry + " of " + totalEntries + " total entries.");
                    DataCreationLogger.getLogger().logInternalError(e.getMessage());
                    DataCreationLogger.getLogger().logStackTrace(e);
                    throw new DataCreationException(e);
                }
                currentKey = entry.getKey();
                currentValue = new MapMarkerIndexMultiValue();
                currentValue.addOffset(entry.getValue().getOffset());
            }
            entryIterator.remove();
        }
        DataCreationLogger.getLogger().logStatus("\nProcessed " + currentEntry + " of " + totalEntries + " entries.");
        try {
            this.m_newIndex.addIndexEntry((MapMarkerIndexKey)currentKey, (MapMarkerIndexValue)currentValue);
        }
        catch (DuplicateKeyException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Attempt to add duplicate key to new index.");
            DataCreationLogger.getLogger().logInternalError("\tUnable to add key for entry: " + currentEntry + " of " + totalEntries + " total entries.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(e);
        }
        DataCreationLogger.getLogger().logStatus("Finished processing index entries.");
        try {
            this.m_newIndex.write();
            this.m_newIndex.close();
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("An error occurred writing the new index file.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(e);
        }
        DataCreationLogger.getLogger().logStatus("Finished converting index file.");
    }

    private class IntermediateIndexEntry
    implements Comparable {
        private MapMarkerIndexKey m_key;
        private MapMarkerIndexSingleValue m_value;

        public IntermediateIndexEntry(MapMarkerIndexKey key, MapMarkerIndexSingleValue value) {
            this.m_key = key;
            this.m_value = value;
        }

        public MapMarkerIndexKey getKey() {
            return this.m_key;
        }

        public MapMarkerIndexSingleValue getValue() {
            return this.m_value;
        }

        public boolean equals(Object that) {
            IntermediateIndexEntry thatEntry = (IntermediateIndexEntry)that;
            return this.m_key.equals(thatEntry.m_key);
        }

        public int compareTo(Object that) {
            if (this.equals(that)) {
                return 0;
            }
            IntermediateIndexEntry thatEntry = (IntermediateIndexEntry)that;
            return this.m_key.compareTo((Object)thatEntry.m_key);
        }
    }
}

