/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.BinaryTreeNode;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.SimpleMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.SimpleMapMarkerIndexNode;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeItem;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import com.mapinfo.mapmarker.utils.SeekableDataInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;

public abstract class NonCacheSimpleLoadableMapMarkerIndex
extends SimpleMapMarkerIndex
implements IMapMarkerReadOnlyIndexFile {
    private static final long NO_OFFSET = -1L;
    private MapMarkerIndexFileMetadata m_metadata = this.getMetadataType();

    public final void open(String filename) throws IOException {
        try (SeekableDataInputStream file = new SeekableDataInputStream(new File(filename));){
            this.m_metadata.read((DataInput)file);
            this.root = this.readNodeAt((SeekableDataInput)file, file.getFilePointer());
        }
    }

    public void close() {
        this.root.dispose();
        this.root = null;
    }

    private BinaryTreeNode readNodeAt(SeekableDataInput file, long offset) throws IOException {
        if (offset == -1L) {
            return SimpleMapMarkerIndex.z;
        }
        MapMarkerIndexKey key = this.getIndexKeyType();
        MapMarkerIndexValue value = this.getIndexValueType();
        file.seek(offset);
        key.read((DataInput)file);
        value.read((DataInput)file);
        long leftNodeOffset = file.readLong();
        long rightNodeOffset = file.readLong();
        SimpleMapMarkerIndexNode node = new SimpleMapMarkerIndexNode(new TreeItem((Comparable)key, (Object)value));
        node.attachLeft(this.readNodeAt(file, leftNodeOffset));
        node.attachRight(this.readNodeAt(file, rightNodeOffset));
        return node;
    }

    protected abstract MapMarkerIndexKey getIndexKeyType();

    protected abstract MapMarkerIndexValue getIndexValueType();

    protected MapMarkerIndexFileMetadata getMetadataType() {
        return new MapMarkerIndexFileMetadata();
    }
}

