/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.FileInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.IFileInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.INonTerminalInnerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeFileInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeFileInnerSubIndex;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.List;

public class NonTerminalTreeFileInnerSubIndex
extends TreeFileInnerSubIndex
implements INonTerminalInnerSubIndex {
    private List m_nextLevelSubIndexLinks = new LinkedList();

    public NonTerminalTreeFileInnerSubIndex(RandomAccessFile file, IFileInnerIndexHelper helper) {
        super(file, helper);
    }

    @Override
    public boolean insert(MapMarkerIndexKey key, MapMarkerIndexValue value) throws IndexAccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InnerIndexLink getNextIndexLevelLink(MapMarkerIndexKey key) throws IndexAccessException {
        InnerIndexLink link = this.getRoot();
        while (!link.equals(this.m_Z.getSelfLink())) {
            TreeFileInnerIndexItem item;
            try {
                item = (TreeFileInnerIndexItem)this.getItemAt(link);
            }
            catch (IOException IOEx) {
                throw new IndexAccessException(5002, (Throwable)IOEx);
            }
            int keyRelation = key.compareTo((Object)item.getKey());
            if (keyRelation == 0) {
                return (InnerIndexLink)item.getValue().getValue();
            }
            if (keyRelation < 0) {
                link = item.getLeftLink();
                continue;
            }
            link = item.getRightLink();
        }
        InnerIndexLink nextLink = new InnerIndexLink();
        FileInnerIndexItem newItem = ((IFileInnerIndexHelper)this.getHelper()).makeIndexFileItem(key, nextLink);
        try {
            this.addEntry(link, newItem);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5004, (Throwable)IOEx);
        }
        return nextLink;
    }

    @Override
    protected MapMarkerIndexValue getValueFor(FileInnerIndexItem item) throws IndexAccessException, IOException {
        MapMarkerIndexValue value = super.getValueFor(item);
        this.m_nextLevelSubIndexLinks.add(value);
        return value;
    }

    @Override
    public List getNextLevelSubIndexLinks() {
        return this.m_nextLevelSubIndexLinks;
    }
}

