/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.INIOInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.INonTerminalInnerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeNIOInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeNIOInnerSubIndex;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class NonTerminalTreeNIOInnerSubIndex
extends TreeNIOInnerSubIndex
implements INonTerminalInnerSubIndex {
    private List m_nextLevelSubIndexLinks = new LinkedList();

    public NonTerminalTreeNIOInnerSubIndex(RandomAccessDataStream file, INIOInnerIndexHelper helper) {
        super(file, helper);
    }

    @Override
    public boolean insert(MapMarkerIndexKey key, MapMarkerIndexValue value) throws IndexAccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InnerIndexLink getNextIndexLevelLink(MapMarkerIndexKey key) throws IndexAccessException {
        NIOInnerIndexLink link = this.getRoot();
        while (!link.equals(this.m_Z.getSelfLink())) {
            TreeNIOInnerIndexItem item;
            try {
                item = (TreeNIOInnerIndexItem)this.getItemAt(link);
            }
            catch (IOException IOEx) {
                throw new IndexAccessException(5002, (Throwable)IOEx);
            }
            int keyRelation = key.compareTo((Object)item.getKey());
            if (keyRelation == 0) {
                return (InnerIndexLink)item.getValue().getValue();
            }
            if (keyRelation < 0) {
                link = item.getLeftLink();
                continue;
            }
            link = item.getRightLink();
        }
        NIOInnerIndexLink nextLink = new NIOInnerIndexLink();
        NIOInnerIndexItem newItem = ((INIOInnerIndexHelper)this.getHelper()).makeIndexFileItem(key, nextLink);
        try {
            this.addEntry(link, newItem);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5004, (Throwable)IOEx);
        }
        return nextLink;
    }

    @Override
    protected MapMarkerIndexValue getValueFor(NIOInnerIndexItem item) throws IndexAccessException, IOException {
        MapMarkerIndexValue value = super.getValueFor(item);
        this.m_nextLevelSubIndexLinks.add(value);
        return value;
    }

    @Override
    public List getNextLevelSubIndexLinks() {
        return this.m_nextLevelSubIndexLinks;
    }
}

