/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.BinaryTreeNIOInnerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.INIOInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.RedBlackTreeNIOInnerIndexItem;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import java.io.IOException;

public class RedBlackTreeNIOInnerIndex
extends BinaryTreeNIOInnerIndex {
    public RedBlackTreeNIOInnerIndex(RandomAccessDataStream file, INIOInnerIndexHelper helper) {
        super(file, helper);
    }

    @Override
    public void create(NIOInnerIndexLink link) throws IndexAccessException {
        super.create(link);
        try {
            this.makeBlack(this.m_Z.getSelfLink());
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5000, (Throwable)IOEx);
        }
    }

    @Override
    protected void addEntry(NIOInnerIndexLink link, NIOInnerIndexItem item) throws IOException {
        super.addEntry(link, item);
        this.findParent((RedBlackTreeNIOInnerIndexItem)item);
        this.balance(item.getSelfLink());
    }

    private void findParent(RedBlackTreeNIOInnerIndexItem item) throws IOException {
        if (item.getSelfLink().equals(this.getRoot())) {
            return;
        }
        NIOInnerIndexLink link = this.getRoot();
        while (true) {
            RedBlackTreeNIOInnerIndexItem parent;
            if ((parent = (RedBlackTreeNIOInnerIndexItem)this.getItemAt(link)).getLeftLink().equals(item.getSelfLink()) || parent.getRightLink().equals(item.getSelfLink())) {
                NIOInnerIndexLink parentLink = item.getParent();
                parentLink.setLink(parent.getSelfLink().getLink());
                this.updateLink(parentLink);
                return;
            }
            int keyRelation = item.getKey().compareTo((Object)parent.getKey());
            if (keyRelation < 0) {
                link = parent.getLeftLink();
                continue;
            }
            if (keyRelation <= 0) continue;
            link = parent.getRightLink();
        }
    }

    private void balance(NIOInnerIndexLink node) throws IOException {
        while (!this.getRoot().equals(node) && this.isRed(this.getParentLink(node))) {
            NIOInnerIndexLink uncle;
            if (this.getParentLink(node).equals(this.getLeftLink(this.getParentLink(this.getParentLink(node))))) {
                uncle = this.getRightLink(this.getParentLink(this.getParentLink(node)));
                if (this.isRed(uncle)) {
                    this.makeBlack(this.getParentLink(node));
                    this.makeBlack(uncle);
                    this.makeRed(this.getParentLink(this.getParentLink(node)));
                    node = this.getParentLink(this.getParentLink(node));
                    continue;
                }
                if (node.equals(this.getRightLink(this.getParentLink(node)))) {
                    node = this.getParentLink(node);
                    this.leftRotate(node);
                }
                this.makeBlack(this.getParentLink(node));
                this.makeRed(this.getParentLink(this.getParentLink(node)));
                this.rightRotate(this.getParentLink(this.getParentLink(node)));
                continue;
            }
            uncle = this.getLeftLink(this.getParentLink(this.getParentLink(node)));
            if (this.isRed(uncle)) {
                this.makeBlack(this.getParentLink(node));
                this.makeBlack(uncle);
                this.makeRed(this.getParentLink(this.getParentLink(node)));
                node = this.getParentLink(this.getParentLink(node));
                continue;
            }
            if (node.equals(this.getLeftLink(this.getParentLink(node)))) {
                node = this.getParentLink(node);
                this.rightRotate(node);
            }
            this.makeBlack(this.getParentLink(node));
            this.makeRed(this.getParentLink(this.getParentLink(node)));
            this.leftRotate(this.getParentLink(this.getParentLink(node)));
        }
        this.makeBlack(this.getRoot());
    }

    private NIOInnerIndexLink updateLink(NIOInnerIndexLink dest, NIOInnerIndexLink src) throws IOException {
        return this.updateLink(dest, src.getLink());
    }

    private NIOInnerIndexLink updateLink(NIOInnerIndexLink dest, long src) throws IOException {
        dest.setLink(src);
        this.updateLink(dest);
        return dest;
    }

    private void leftRotate(NIOInnerIndexLink node) throws IOException {
        NIOInnerIndexLink y = this.getRightLink(node);
        NIOInnerIndexLink t = this.updateLink(this.getRightLink(node), this.getLeftLink(y));
        if (t.isLink()) {
            this.updateLink(this.getParentLink(t), node);
        }
        this.updateLink(this.getParentLink(y), this.getParentLink(node));
        if (!this.getParentLink(node).isLink()) {
            this.updateLink(this.getRoot(), y.getLink());
        } else {
            t = node.equals(this.getLeftLink(this.getParentLink(node))) ? this.getLeftLink(this.getParentLink(node)) : this.getRightLink(this.getParentLink(node));
            this.updateLink(t, y);
        }
        this.updateLink(this.getLeftLink(y), node);
        this.updateLink(this.getParentLink(node), y);
    }

    private void rightRotate(NIOInnerIndexLink node) throws IOException {
        NIOInnerIndexLink y = this.getLeftLink(node);
        NIOInnerIndexLink t = this.updateLink(this.getLeftLink(node), this.getRightLink(y));
        if (t.isLink()) {
            this.updateLink(this.getParentLink(t), node);
        }
        this.updateLink(this.getParentLink(y), this.getParentLink(node));
        if (!this.getParentLink(node).isLink()) {
            this.updateLink(this.getRoot(), y.getLink());
        } else {
            t = node.equals(this.getLeftLink(this.getParentLink(node))) ? this.getLeftLink(this.getParentLink(node)) : this.getRightLink(this.getParentLink(node));
            this.updateLink(t, y);
        }
        this.updateLink(this.getRightLink(y), node);
        this.updateLink(this.getParentLink(node), y);
    }

    private void updateItem(RedBlackTreeNIOInnerIndexItem item) throws IOException {
        RandomAccessDataStream file = this.getIndexFile();
        file.seek(item.getSelfLink().getLink());
        item.write(file);
    }

    private NIOInnerIndexLink getParentLink(NIOInnerIndexLink link) throws IOException {
        return ((RedBlackTreeNIOInnerIndexItem)this.getItemAt(link)).getParent();
    }

    private boolean isRed(NIOInnerIndexLink link) throws IOException {
        return ((RedBlackTreeNIOInnerIndexItem)this.getItemAt(link)).isRed();
    }

    private void makeRed(NIOInnerIndexLink link) throws IOException {
        if (this.isRed(link)) {
            return;
        }
        RedBlackTreeNIOInnerIndexItem item = (RedBlackTreeNIOInnerIndexItem)this.getItemAt(link);
        item.makeRed();
        this.updateItem(item);
    }

    protected void makeBlack(NIOInnerIndexLink link) throws IOException {
        if (!this.isRed(link)) {
            return;
        }
        RedBlackTreeNIOInnerIndexItem item = (RedBlackTreeNIOInnerIndexItem)this.getItemAt(link);
        item.makeBlack();
        this.updateItem(item);
    }
}

