/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial.binary;

import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValue;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RangeCombiningSpatialIndexValueIterator
implements Iterator<SpatialIndexValue>,
Closeable {
    private final int m_valuesPerReturn;
    private final Iterator<SpatialIndexValue> m_iterator;
    private SpatialIndexValue m_leftOver;

    public RangeCombiningSpatialIndexValueIterator(int valuesPerReturn, Iterator<SpatialIndexValue> iterator) {
        if (valuesPerReturn < 1) {
            throw new IllegalArgumentException();
        }
        this.m_valuesPerReturn = valuesPerReturn;
        this.m_iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.m_iterator.hasNext() || this.m_leftOver != null;
    }

    @Override
    public SpatialIndexValue next() throws DataAccessRuntimeException {
        int count = 0;
        SpatialIndexValue returnValue = null;
        if (this.m_leftOver != null) {
            returnValue = this.m_leftOver;
            ++count;
            this.m_leftOver = null;
        }
        while (this.m_iterator.hasNext() && count < this.m_valuesPerReturn) {
            if (returnValue == null) {
                returnValue = this.m_iterator.next();
                ++count;
                continue;
            }
            SpatialIndexValue next = this.m_iterator.next();
            if (next.getStreetOffset() == returnValue.getStreetOffset() && next.getSegmentNumber() == returnValue.getSegmentNumber()) {
                returnValue.addRange(next.getFirstRangeNumber(), next.getBounds());
                ++count;
                continue;
            }
            this.m_leftOver = next;
            break;
        }
        if (returnValue == null) {
            throw new NoSuchElementException();
        }
        return returnValue;
    }

    @Override
    public void remove() {
        this.m_iterator.remove();
    }

    @Override
    public void close() throws IOException {
        if (this.m_iterator instanceof Closeable) {
            ((Closeable)((Object)this.m_iterator)).close();
        }
    }
}

