/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.intermediate;

import com.mapinfo.mapmarker.common.dp.binary.AlternateDataItem;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexStreetDataIndexKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class IntermediateDataItem
extends GenericDataItem {
    private ArrayList m_alternateDataItems;

    public boolean hasAlternateDataItems() {
        return this.m_alternateDataItems != null;
    }

    public void setAlternateDataItems(ArrayList items) {
        this.m_alternateDataItems = items;
    }

    public ArrayList getAlternateDataItems() {
        return this.m_alternateDataItems;
    }

    protected MapMarkerIndexKey getBrowseKey(byte type) {
        return new MapMarkerBrowseMultiLevelIndexKey();
    }

    protected MapMarkerIndexKey getSearchKey(byte type) {
        return new MiSoundexStreetDataIndexKey();
    }

    protected void read(DataInput in) throws IOException, MMJEDataCorruptedException {
        super.read(in, null);
        int count = in.readShort();
        if (count > 0 && this.m_alternateDataItems == null) {
            this.m_alternateDataItems = new ArrayList();
        }
        for (int i = 0; i < count; ++i) {
            byte type = in.readByte();
            boolean hasId = in.readBoolean();
            String id = null;
            if (hasId) {
                id = in.readUTF();
            }
            boolean hasSearchKey = in.readBoolean();
            boolean hasBrowseKey = in.readBoolean();
            MapMarkerIndexKey searchKey = null;
            MapMarkerIndexKey browseKey = null;
            if (hasSearchKey) {
                searchKey = this.getSearchKey(type);
                searchKey.read(in);
            }
            if (hasBrowseKey) {
                browseKey = this.getBrowseKey(type);
                browseKey.read(in);
            }
            AlternateDataRecord record = new AlternateDataRecord();
            record.setAlternateDataID(id);
            AlternateDataItem item = new AlternateDataItem(type, record, searchKey, browseKey);
            this.m_alternateDataItems.add(item);
        }
    }

    protected void write(DataOutput out) throws IOException, MMJEDataCorruptedException {
        super.write(out);
        int count = 0;
        if (this.m_alternateDataItems != null) {
            count = this.m_alternateDataItems.size();
        }
        out.writeShort(count);
        for (int i = 0; i < count; ++i) {
            AlternateDataItem item = (AlternateDataItem)this.m_alternateDataItems.get(i);
            out.writeByte(item.getAlternateSearchType());
            AlternateDataRecord record = item.getAlternateDataRecord();
            String id = record.alternateDataID();
            if (id != null) {
                out.writeBoolean(true);
                out.writeUTF(id);
            } else {
                out.writeBoolean(false);
            }
            MapMarkerIndexKey searchKey = item.getSearchKey();
            MapMarkerIndexKey browseKey = item.getBrowseKey();
            if (searchKey != null) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
            }
            if (browseKey != null) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
            }
            if (searchKey != null) {
                searchKey.write(out);
            }
            if (browseKey == null) continue;
            browseKey.write(out);
        }
    }
}

