/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.intermediate;

import com.mapinfo.mapmarker.common.dp.binary.IDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateRangeDataItem;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class IntermediateSegmentDataItem
extends IntermediateDataItem
implements IDataItem {
    private ArrayList m_ranges = new ArrayList();
    private ArrayList m_points = new ArrayList();

    public void addRange(IntermediateRangeDataItem range) {
        this.m_ranges.add(range);
    }

    public ArrayList getRanges() {
        return this.m_ranges;
    }

    public void addPoint(DirectPosition point) {
        this.m_points.add(point);
    }

    public ArrayList getPoints() {
        return this.m_points;
    }

    protected void writeRanges(DataOutput out) throws IOException, MMJEDataCorruptedException {
        ArrayList ranges = this.getRanges();
        int numRanges = ranges.size();
        out.writeShort(numRanges);
        for (int i = 0; i < numRanges; ++i) {
            IntermediateRangeDataItem range = (IntermediateRangeDataItem)((Object)ranges.get(i));
            range.write(out);
        }
    }

    protected void writePoints(DataOutput out) throws IOException, MMJEDataCorruptedException {
        ArrayList points = this.getPoints();
        int numPoints = points.size();
        out.writeShort(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            DirectPosition point = (DirectPosition)points.get(i);
            out.writeDouble(point.getX());
            out.writeDouble(point.getY());
        }
    }

    @Override
    public void write(DataOutput out) throws IOException, MMJEDataCorruptedException {
        super.write(out);
        this.writePoints(out);
        this.writeRanges(out);
    }

    protected IntermediateRangeDataItem getIntermediateRangeDataItemType() {
        return new IntermediateRangeDataItem();
    }

    protected void readRanges(DataInput in) throws IOException, MMJEDataCorruptedException {
        int numRanges = in.readUnsignedShort();
        for (int i = 0; i < numRanges; ++i) {
            IntermediateRangeDataItem range = this.getIntermediateRangeDataItemType();
            range.read(in);
            this.addRange(range);
        }
    }

    protected void readPoints(DataInput in) throws IOException, MMJEDataCorruptedException {
        int numPoints = in.readUnsignedShort();
        for (int i = 0; i < numPoints; ++i) {
            DirectPosition point = new DirectPosition(in.readDouble(), in.readDouble());
            this.addPoint(point);
        }
    }

    @Override
    public void read(DataInput in) throws IOException, MMJEDataCorruptedException {
        super.read(in);
        this.readPoints(in);
        this.readRanges(in);
    }
}

