/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.intermediate;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.BlobAdditionalFieldsFactory;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GenericIINtermediateRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.intermediate.IDataRecordID;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateFileStreetDataRecordID;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateRangeDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateSegmentDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateUnitDataItem;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class IntermediateStreetDataFileFormatHandler
implements IIntermediateDataHandler {
    private File m_file;
    private RandomAccessDataStream m_stream;

    public IntermediateStreetDataFileFormatHandler(String fileName) {
        this.m_file = new File(fileName);
    }

    @Override
    public void open() throws DataSourceException {
        this.delete();
        try {
            this.m_stream = new RandomAccessDataStream(this.m_file);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(14, (Throwable)IOEx);
        }
    }

    @Override
    public void close() throws DataSourceException {
        if (this.m_stream != null) {
            try {
                this.m_stream.close();
                this.m_stream = null;
            }
            catch (IOException IOEx) {
                throw new DataSourceException(14, (Throwable)IOEx);
            }
        }
    }

    @Override
    public void cleanUp() throws DataSourceException {
        this.delete();
    }

    private void delete() throws DataSourceException {
        if (DebugLevel.getDebugLevel((int)5) == 0) {
            if (this.m_file.exists()) {
                if (!this.m_file.delete()) {
                    DataCreationLogger.getLogger().logInternalError("AbstractUDDataProvider:: delete(): ");
                    DataCreationLogger.getLogger().logError("Unable to delete file: " + this.m_file.getAbsolutePath());
                    throw new DataSourceException(14);
                }
            } else {
                DataCreationLogger.getLogger().logStatus("Tried to delete " + this.m_file.getAbsolutePath() + " but it did not exist.");
            }
        } else {
            DataCreationLogger.getLogger().logStatus("Did not attempt to delete " + this.m_file.getAbsolutePath() + " due to current DebugLevel.");
        }
    }

    protected long getFilePointer() throws IOException {
        return this.m_stream.getFilePointer();
    }

    protected void seek(long offset) throws IOException {
        this.m_stream.seek(offset);
    }

    protected DataOutput getOutput() {
        return this.m_stream;
    }

    protected DataInput getInput() throws DataSourceException {
        return this.m_stream;
    }

    @Override
    public IDataRecordID putIntermediateData(Object record) throws DataSourceException {
        MMJStreetRecord street = (MMJStreetRecord)record;
        try {
            IntermediateFileStreetDataRecordID ID = new IntermediateFileStreetDataRecordID(this.getFilePointer());
            IntermediateStreetDataItem dataItem = this.makeStreetDataItem(street);
            dataItem.write(this.getOutput());
            return ID;
        }
        catch (IOException e) {
            throw new DataSourceException(13, (Throwable)e);
        }
        catch (MMJEDataCorruptedException e) {
            throw new DataSourceException(13, (Throwable)e);
        }
    }

    protected IntermediateStreetDataItem getIntermediateStreetDataItemType() {
        return new IntermediateStreetDataItem();
    }

    @Override
    public Object getIntermediateData(IDataRecordID ID) throws DataSourceException {
        try {
            IntermediateFileStreetDataRecordID interID = (IntermediateFileStreetDataRecordID)ID;
            this.seek(interID.getOffset());
            IntermediateStreetDataItem dataItem = this.getIntermediateStreetDataItemType();
            dataItem.read(this.getInput());
            return this.makeStreetDataRecord(dataItem);
        }
        catch (IOException e) {
            throw new DataSourceException(13, (Throwable)e);
        }
        catch (MMJEDataCorruptedException e) {
            throw new DataSourceException(13, (Throwable)e);
        }
    }

    protected String prepareStringForDataItem(String item) {
        if (item == null) {
            return null;
        }
        if ((item = item.trim()).length() > 0) {
            return item;
        }
        return null;
    }

    protected void convertUnitRecord2DataItem(MMJRangeUnitRecord record, IntermediateUnitDataItem item) throws DataSourceException {
        try {
            String unitItem = this.prepareStringForDataItem(record.getHighUnit());
            if (unitItem != null) {
                item.putString(1, unitItem);
            }
            if ((unitItem = this.prepareStringForDataItem(record.getLowUnit())) != null) {
                item.putString(0, unitItem);
            }
            if ((unitItem = this.prepareStringForDataItem(record.getPlaceName())) != null) {
                item.putString(3, unitItem);
            }
            if ((unitItem = this.prepareStringForDataItem(record.getUnitType())) != null) {
                item.putString(2, unitItem);
            }
            if (record.hasAlternateDataItems()) {
                item.setAlternateDataItems(record.getAlternateDataItems());
            }
            if (record.hasAdditionalFields()) {
                item.putBlob(0, BlobAdditionalFieldsFactory.createBlob(record.getAdditionalFields()));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range unit data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(14, (Throwable)e);
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range unit data.");
            DataCreationLogger.getLogger().logInternalError(IOEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace(IOEx);
            throw new DataSourceException(14, (Throwable)IOEx);
        }
    }

    protected IntermediateUnitDataItem makeUnitDataItem(MMJRangeUnitRecord unit) throws DataSourceException {
        IntermediateUnitDataItem item = new IntermediateUnitDataItem();
        this.convertUnitRecord2DataItem(unit, item);
        return item;
    }

    protected void convertRangeRecord2DataItem(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        try {
            String rangeItem;
            ParsedNumber number = record.getFromHouse();
            if (number != null && (rangeItem = this.prepareStringForDataItem(number.getCombinedAddressNumber())) != null) {
                item.putString(1, rangeItem);
            }
            if ((number = record.getToHouse()) != null && (rangeItem = this.prepareStringForDataItem(number.getCombinedAddressNumber())) != null) {
                item.putString(0, rangeItem);
            }
            if ((rangeItem = this.prepareStringForDataItem(record.getPlaceName())) != null) {
                item.putString(2, rangeItem);
            }
            item.putByte(0, (byte)record.getOddEven());
            if (record.isLeft()) {
                item.putBoolean(0, true);
            }
            if (record.hasAlternateDataItems()) {
                item.setAlternateDataItems(record.getAlternateDataItems());
            }
            if (record.getIntermediateDataRecordArray() != null) {
                item.putBlob(0, new GenericIINtermediateRangeRecord(record.getIntermediateDataRecordArray()).toByteArray());
            }
            if (record.getPoint() != null) {
                item.putDouble(0, record.getPoint().getX());
                item.putDouble(1, record.getPoint().getY());
            }
            if (record.hasAdditionalFields()) {
                item.putBlob(1, BlobAdditionalFieldsFactory.createBlob(record.getAdditionalFields()));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(14, (Throwable)e);
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected IntermediateRangeDataItem makeRangeDataItem(MMJRangeRecord range) throws DataSourceException {
        IntermediateRangeDataItem item = new IntermediateRangeDataItem();
        ArrayList units = (ArrayList)range.getRangeUnits();
        if (units != null) {
            for (int i = 0; i < units.size(); ++i) {
                MMJRangeUnitRecord unit = (MMJRangeUnitRecord)units.get(i);
                item.addUnit(this.makeUnitDataItem(unit));
            }
        }
        this.convertRangeRecord2DataItem(range, item);
        return item;
    }

    protected void convertSegmentRecord2DataItem(MMJSegmentRecord record, IntermediateSegmentDataItem item) throws DataSourceException {
        try {
            String segmentItem = this.prepareStringForDataItem(record.getLeftAreaName1());
            if (segmentItem != null) {
                item.putString(4, segmentItem);
            }
            if ((segmentItem = this.prepareStringForDataItem(record.getLeftAreaName2())) != null) {
                item.putString(6, segmentItem);
            }
            if ((segmentItem = this.prepareStringForDataItem(record.getLeftAreaName3())) != null) {
                item.putString(8, segmentItem);
            }
            if ((segmentItem = this.prepareStringForDataItem(record.getLeftAreaName4())) != null) {
                item.putString(10, segmentItem);
            }
            if ((segmentItem = this.prepareStringForDataItem(record.getLeftPostalCode1())) != null) {
                item.putString(0, segmentItem);
            }
            if ((segmentItem = this.prepareStringForDataItem(record.getLeftPostalCode2())) != null) {
                item.putString(2, segmentItem);
            }
            if ((segmentItem = this.prepareStringForDataItem(record.getRightAreaName1())) != null) {
                item.putString(5, segmentItem);
            }
            if ((segmentItem = this.prepareStringForDataItem(record.getRightAreaName2())) != null) {
                item.putString(7, segmentItem);
            }
            if ((segmentItem = this.prepareStringForDataItem(record.getRightAreaName3())) != null) {
                item.putString(9, segmentItem);
            }
            if ((segmentItem = this.prepareStringForDataItem(record.getRightAreaName4())) != null) {
                item.putString(11, segmentItem);
            }
            if ((segmentItem = this.prepareStringForDataItem(record.getRightPostalCode1())) != null) {
                item.putString(1, segmentItem);
            }
            if ((segmentItem = this.prepareStringForDataItem(record.getRightPostalCode2())) != null) {
                item.putString(3, segmentItem);
            }
            if ((segmentItem = this.prepareStringForDataItem(record.getId())) != null) {
                item.putString(12, segmentItem);
            }
            if (record.hasAlternateDataItems()) {
                item.setAlternateDataItems(record.getAlternateDataItems());
            }
            if (record.isPointHouseSegment()) {
                item.putBoolean(0, true);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected IntermediateSegmentDataItem makeSegmentDataItem(MMJSegmentRecord segment) throws DataSourceException {
        ArrayList points;
        IntermediateSegmentDataItem item = new IntermediateSegmentDataItem();
        ArrayList ranges = (ArrayList)segment.getRanges();
        if (ranges != null) {
            for (int i = 0; i < ranges.size(); ++i) {
                MMJRangeRecord range = (MMJRangeRecord)ranges.get(i);
                item.addRange(this.makeRangeDataItem(range));
            }
        }
        if ((points = (ArrayList)segment.getPoints()) != null) {
            for (int i = 0; i < points.size(); ++i) {
                item.addPoint((DirectPosition)points.get(i));
            }
        }
        this.convertSegmentRecord2DataItem(segment, item);
        return item;
    }

    protected void convertStreetRecord2DataItem(MMJStreetRecord record, IntermediateStreetDataItem item) throws DataSourceException {
        Address address = record.getAddress();
        try {
            item.putInt(0, record.getSac());
            String streetItem = this.prepareStringForDataItem(address.getGenericField1());
            if (streetItem != null) {
                item.putString(0, streetItem);
            }
            if ((streetItem = this.prepareStringForDataItem(address.getGenericField2())) != null) {
                item.putString(1, streetItem);
            }
            if ((streetItem = this.prepareStringForDataItem(address.getGenericField3())) != null) {
                item.putString(2, streetItem);
            }
            if ((streetItem = this.prepareStringForDataItem(address.getGenericField4())) != null) {
                item.putString(3, streetItem);
            }
            if ((streetItem = this.prepareStringForDataItem(address.getPreAddress())) != null) {
                item.putString(4, streetItem);
            }
            if ((streetItem = this.prepareStringForDataItem(address.getPreDirectional())) != null) {
                item.putString(5, streetItem);
            }
            if ((streetItem = this.prepareStringForDataItem(address.getPreThoroughfareType())) != null) {
                item.putString(6, streetItem);
            }
            if ((streetItem = this.prepareStringForDataItem(address.getMainAddress())) != null) {
                item.putString(7, streetItem);
            }
            if ((streetItem = this.prepareStringForDataItem(address.getPostThoroughfareType())) != null) {
                item.putString(8, streetItem);
            }
            if ((streetItem = this.prepareStringForDataItem(address.getPostDirectional())) != null) {
                item.putString(9, streetItem);
            }
            if ((streetItem = this.prepareStringForDataItem(address.getPostAddress())) != null) {
                item.putString(10, streetItem);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate street data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(14, (Throwable)e);
        }
        item.setBrowseKeys((ArrayList)record.getBrowseKeys());
        if (record.hasAlternateDataItems()) {
            item.setAlternateDataItems(record.getAlternateDataItems());
        }
    }

    protected IntermediateStreetDataItem makeStreetDataItem(MMJStreetRecord street) throws DataSourceException {
        IntermediateStreetDataItem item = new IntermediateStreetDataItem();
        item.setSegment(this.makeSegmentDataItem(street.getSegment()));
        this.convertStreetRecord2DataItem(street, item);
        return item;
    }

    protected void convertUnitDataItem2Record(MMJRangeUnitRecord record, IntermediateUnitDataItem item) throws DataSourceException {
        try {
            if (item.hasString(1)) {
                record.setHighUnit(item.getString(1));
            }
            if (item.hasString(0)) {
                record.setLowUnit(item.getString(0));
            }
            if (item.hasString(3)) {
                record.setPlaceName(item.getString(3));
            }
            if (item.hasString(2)) {
                record.setUnitType(item.getString(2));
            }
            if (item.hasAlternateDataItems()) {
                record.setAlternateDataItems(item.getAlternateDataItems());
            }
            if (item.hasBlob(0)) {
                record.setAdditionalFields(BlobAdditionalFieldsFactory.createAdditionalFields((byte[])item.getBlob(0)));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range unit data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(14, (Throwable)e);
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range unit data.");
            DataCreationLogger.getLogger().logInternalError(IOEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace(IOEx);
            throw new DataSourceException(14, (Throwable)IOEx);
        }
    }

    protected MMJRangeUnitRecord makeUnitRecord(IntermediateUnitDataItem item) throws DataSourceException {
        MMJRangeUnitRecord unit = this.getUnitRecordType();
        this.convertUnitDataItem2Record(unit, item);
        return unit;
    }

    protected void convertRangeDataItem2Record(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        try {
            if (item.hasString(1)) {
                record.setFromHouse(item.getString(1));
            }
            if (item.hasString(0)) {
                record.setToHouse(item.getString(0));
            }
            if (item.hasString(2)) {
                record.setPlaceName(item.getString(2));
            }
            if (item.hasByte(0)) {
                record.setOddEven(item.getByte(0));
            }
            if (item.hasBoolean(0)) {
                record.setLeft();
            } else {
                record.setRight();
            }
            if (item.hasAlternateDataItems()) {
                record.setAlternateDataItems(item.getAlternateDataItems());
            }
            if (item.hasBlob(0)) {
                record.setIntermediateDataRecordArray(new GenericIINtermediateRangeRecord().getRecord(item.getBlob(0)));
            }
            if (item.hasDouble(0) && item.hasDouble(1)) {
                record.setPoint(new DirectPosition(item.getDouble(0), item.getDouble(1)));
            }
            if (item.hasBlob(1)) {
                record.setAdditionalFields(BlobAdditionalFieldsFactory.createAdditionalFields((byte[])item.getBlob(1)));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(14, (Throwable)e);
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected MMJRangeRecord makeRangeRecord(IntermediateRangeDataItem item) throws DataSourceException {
        MMJRangeRecord range = this.getRangeRecordType();
        ArrayList units = item.getUnits();
        for (int i = 0; i < units.size(); ++i) {
            range.addRangeUnit(this.makeUnitRecord((IntermediateUnitDataItem)((Object)units.get(i))));
        }
        this.convertRangeDataItem2Record(range, item);
        return range;
    }

    protected void convertSegmentDataItem2Record(MMJSegmentRecord record, IntermediateSegmentDataItem item) throws DataSourceException {
        try {
            if (item.hasString(4)) {
                record.setLeftAreaName1(item.getString(4));
            }
            if (item.hasString(6)) {
                record.setLeftAreaName2(item.getString(6));
            }
            if (item.hasString(8)) {
                record.setLeftAreaName3(item.getString(8));
            }
            if (item.hasString(10)) {
                record.setLeftAreaName4(item.getString(10));
            }
            if (item.hasString(0)) {
                record.setLeftPostalCode1(item.getString(0));
            }
            if (item.hasString(2)) {
                record.setLeftPostalCode2(item.getString(2));
            }
            if (item.hasString(5)) {
                record.setRightAreaName1(item.getString(5));
            }
            if (item.hasString(7)) {
                record.setRightAreaName2(item.getString(7));
            }
            if (item.hasString(9)) {
                record.setRightAreaName3(item.getString(9));
            }
            if (item.hasString(11)) {
                record.setRightAreaName4(item.getString(11));
            }
            if (item.hasString(1)) {
                record.setRightPostalCode1(item.getString(1));
            }
            if (item.hasString(3)) {
                record.setRightPostalCode2(item.getString(3));
            }
            if (item.hasString(12)) {
                record.setId(item.getString(12));
            }
            if (item.hasAlternateDataItems()) {
                record.setAlternateDataItems(item.getAlternateDataItems());
            }
            if (item.hasBoolean(0) && item.getBoolean(0)) {
                record.setIsPointHouseSegment();
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected MMJSegmentRecord makeSegmentRecord(IntermediateSegmentDataItem item) throws DataSourceException {
        MMJSegmentRecord segment = this.getSegmentRecordType();
        ArrayList points = item.getPoints();
        for (int i = 0; i < points.size(); ++i) {
            segment.addPoint((DirectPosition)points.get(i));
        }
        ArrayList ranges = item.getRanges();
        for (int i = 0; i < ranges.size(); ++i) {
            segment.addRange(this.makeRangeRecord((IntermediateRangeDataItem)((Object)ranges.get(i))));
        }
        this.convertSegmentDataItem2Record(segment, item);
        return segment;
    }

    protected void convertStreetDataItem2Record(MMJStreetRecord record, IntermediateStreetDataItem item) throws DataSourceException {
        record.setAddress((Address)new AddressImpl());
        Address address = record.getAddress();
        try {
            if (item.hasInteger(0)) {
                record.setSac(item.getInt(0));
            }
            if (item.hasString(0)) {
                address.setGenericField1(item.getString(0));
            }
            if (item.hasString(1)) {
                address.setGenericField2(item.getString(1));
            }
            if (item.hasString(2)) {
                address.setGenericField3(item.getString(2));
            }
            if (item.hasString(3)) {
                address.setGenericField4(item.getString(3));
            }
            if (item.hasString(4)) {
                address.setPreAddress(item.getString(4));
            }
            if (item.hasString(5)) {
                address.setPreDirectional(item.getString(5));
            }
            if (item.hasString(6)) {
                address.setPreThoroughfareType(item.getString(6));
            }
            if (item.hasString(7)) {
                address.setMainAddress(item.getString(7));
            }
            if (item.hasString(8)) {
                address.setPostThoroughfareType(item.getString(8));
            }
            if (item.hasString(9)) {
                address.setPostDirectional(item.getString(9));
            }
            if (item.hasString(10)) {
                address.setPostAddress(item.getString(10));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate street data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(14, (Throwable)e);
        }
        record.setBrowseKeys(item.getBrowseKeys());
        if (item.hasAlternateDataItems()) {
            record.setAlternateDataItems(item.getAlternateDataItems());
        }
    }

    protected MMJStreetRecord makeStreetDataRecord(IntermediateStreetDataItem item) throws DataSourceException {
        MMJStreetRecord street = this.getStreetRecordType();
        street.setSegment(this.makeSegmentRecord(item.getSegment()));
        this.convertStreetDataItem2Record(street, item);
        return street;
    }

    protected MMJStreetRecord getStreetRecordType() {
        return new MMJStreetRecord();
    }

    protected MMJSegmentRecord getSegmentRecordType() {
        return new MMJSegmentRecord();
    }

    protected MMJRangeRecord getRangeRecordType() {
        return new MMJRangeRecord();
    }

    protected MMJRangeUnitRecord getUnitRecordType() {
        return new MMJRangeUnitRecord();
    }
}

