/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.jdbc;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.jdbc.JDBCDataSourceRecordObjects;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public abstract class JDBCDataSource
implements IDataSource {
    public static final String KEY_CONNECTION_URL = "connection_url";
    public static final String KEY_USER = "connection_user";
    public static final String KEY_PASSWORD = "connection_password";
    public static final String KEY_SELECT_STATEMENT = "selectStatement";
    protected Properties m_properties;
    protected Connection m_conn;
    protected PreparedStatement m_statement;
    protected ResultSet m_rs;
    private int m_recordCount = -1;

    protected JDBCDataSource(Properties props) {
        this.m_properties = props;
    }

    @Override
    public void open(String[] args) throws DataSourceException {
        if (StringUtilities.isEmpty((String)args[3])) {
            throw new DataSourceException(11, "No select statement given");
        }
        try {
            this.m_conn = this.getConnection(args[0], args[1], args[2]);
            this.m_statement = this.m_conn.prepareStatement(args[3], 1003, 1007);
            this.m_statement.setFetchSize(1000);
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(11, (Throwable)SQLEx);
        }
        try {
            this.m_rs = this.m_statement.executeQuery();
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(10, (Throwable)SQLEx);
        }
        this.determineRecordCount(args[3]);
    }

    protected abstract Connection getConnection(String var1, String var2, String var3) throws SQLException, DataSourceException;

    @Override
    public IDataSourceRecordObjects getNextDataSourceRecordObjects() throws DataSourceException {
        if (this.m_rs == null) {
            return null;
        }
        try {
            if (this.m_rs.next()) {
                return this.makeDataSourceRecordObjects(this.m_rs, this.m_properties);
            }
            return null;
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(13, (Throwable)SQLEx);
        }
    }

    protected IDataSourceRecordObjects makeDataSourceRecordObjects(ResultSet rs, Properties props) {
        return new JDBCDataSourceRecordObjects(rs, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws DataSourceException {
        boolean bNoPreviousException = false;
        try {
            if (this.m_rs != null) {
                this.m_rs.close();
            }
            if (this.m_statement != null) {
                this.m_statement.close();
            }
            bNoPreviousException = true;
            return;
        }
        catch (SQLException SQLEx) {
            throw new DataSourceException(12, (Throwable)SQLEx);
        }
        finally {
            this.m_rs = null;
            this.m_statement = null;
            if (this.m_conn != null) {
                try {
                    this.m_conn.close();
                }
                catch (SQLException SQLEx) {
                    if (bNoPreviousException) {
                        throw new DataSourceException(12, (Throwable)SQLEx);
                    }
                }
                finally {
                    this.m_conn = null;
                }
            }
        }
    }

    @Override
    public int getRecordCount() throws DataSourceException {
        return this.m_recordCount;
    }

    protected void determineRecordCount(String selectStatementText) {
        String tableName = this.findTableName(selectStatementText);
        if (tableName == null) {
            return;
        }
        String whereClause = this.findWhereClause(selectStatementText);
        try {
            PreparedStatement recordCountStatement = this.m_conn.prepareStatement(("SELECT COUNT(*) FROM " + tableName + " " + whereClause).trim(), 1003, 1007);
            ResultSet rs = recordCountStatement.executeQuery();
            if (rs.next()) {
                this.m_recordCount = rs.getInt(1);
            }
            rs.close();
            recordCountStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private String findTableName(String statement) {
        StringWithTokens tokens = new StringWithTokens(statement);
        for (int i = 0; i < tokens.size(); ++i) {
            if (!tokens.getToken(i).equalsIgnoreCase("FROM") || i + 1 >= tokens.size()) continue;
            return tokens.getToken(i + 1);
        }
        return null;
    }

    private String findWhereClause(String statement) {
        StringWithTokens tokens = new StringWithTokens(statement);
        for (int i = 0; i < tokens.size(); ++i) {
            if (!tokens.getToken(i).equalsIgnoreCase("WHERE")) continue;
            StringBuilder builder = new StringBuilder();
            for (int j = i; j < tokens.size(); ++j) {
                builder.append(tokens.getToken(j));
                builder.append(' ');
            }
            return builder.toString().trim();
        }
        return "";
    }
}

