/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.tab;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecordObjects;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.data.ITableMetadata;
import com.mapinfo.midev.feature.AttributeType;
import com.mapinfo.midev.feature.IAttributeDefinition;
import com.mapinfo.midev.feature.IFeature;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IPoint;
import java.util.ArrayList;
import java.util.Properties;

public class TabDataSourceRecord
implements IDataSourceRecord {
    private IFeature m_records;
    private ITableMetadata m_tabMetaData;
    private Properties m_properties;
    private ArrayList m_convertedPoints;
    private String geometryColumn = null;
    private CoordSys m_coordSys;

    public TabDataSourceRecord(TabDataSourceRecordObjects objects) {
        this.m_records = objects.getRecordSet();
        this.m_tabMetaData = objects.getMetaData();
        this.m_properties = objects.getProperties();
        this.geometryColumn = objects.getGeometryColumnName();
        this.m_coordSys = objects.getCoordSys();
        this.m_convertedPoints = null;
    }

    protected String getFieldStringValue(String fldName) throws DataSourceException {
        try {
            if (this.isZeroPrecisionDecimal(fldName)) {
                return String.valueOf((long)this.m_records.getDouble(fldName));
            }
            return this.m_records.getString(fldName);
        }
        catch (Exception e) {
            DataCreationLogger.getLogger().logInternalError("TabSourceRecord:: Unable to get String value for field: " + fldName);
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(7, fldName, (Throwable)e);
        }
    }

    protected int getFieldIntValue(String fldName) throws DataSourceException {
        try {
            AttributeType type = this.m_records.getMetadata().getAttributeDefinitions().get(fldName).getDataType();
            if (type == AttributeType.STRING) {
                String value = this.m_records.getString(fldName);
                return Integer.valueOf(value);
            }
            return this.m_records.getInt(fldName);
        }
        catch (Exception e) {
            DataCreationLogger.getLogger().logInternalError("TabSourceRecord:: Unable to get int value for field: " + fldName);
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(5, fldName, (Throwable)e);
        }
    }

    protected double getFieldDoubleValue(String fldName) throws DataSourceException {
        try {
            return this.m_records.getDouble(fldName);
        }
        catch (Exception e) {
            DataCreationLogger.getLogger().logInternalError("TabSourceRecord:: Unable to get double value for field: " + fldName);
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(3, fldName, (Throwable)e);
        }
    }

    protected boolean getFieldBooleanValue(String fldName) throws DataSourceException {
        try {
            return this.m_records.getBoolean(fldName);
        }
        catch (Exception e) {
            DataCreationLogger.getLogger().logInternalError("TabSourceRecord:: Unable to get boolean value for field: " + fldName);
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(0, fldName, (Throwable)e);
        }
    }

    protected short getFieldShortValue(String fldName) throws DataSourceException {
        try {
            return this.m_records.getShort(fldName);
        }
        catch (Exception e) {
            DataCreationLogger.getLogger().logInternalError("TabSourceRecord:: Unable to get short value for field: " + fldName);
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(6, fldName, (Throwable)e);
        }
    }

    protected float getFieldFloatValue(String fldName) throws DataSourceException {
        try {
            return this.m_records.getFloat(fldName);
        }
        catch (Exception e) {
            DataCreationLogger.getLogger().logInternalError("TabSourceRecord:: Unable to get float value for field: " + fldName);
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataSourceException(4, fldName, (Throwable)e);
        }
    }

    protected DirectPosition getRecordPoint() throws DataSourceException {
        DirectPosition pos;
        if (this.geometryColumn == null || this.m_records.isNull(this.geometryColumn)) {
            DataCreationLogger.getLogger().logError("No geometry column for record: " + this.m_records.getKey());
            return null;
        }
        IFeatureGeometry geom = this.m_records.getFeatureGeometry(this.geometryColumn);
        if (geom == null) {
            DataCreationLogger.getLogger().logError("No geometry for record: " + this.m_records.getKey());
            return null;
        }
        if (geom.getType() == GeometryType.POINT && (pos = geom.getRepresentativePoint()) != null) {
            return CoordConvertor.transformPointToWGS84((CoordSys)geom.getCoordSys(), (DirectPosition)pos);
        }
        return null;
    }

    protected ArrayList getRecordPoints() throws DataSourceException {
        return this.convertGeometryToPoints();
    }

    protected ArrayList convertGeometryToPoints() throws DataSourceException {
        ArrayList points;
        block7: {
            if (this.m_convertedPoints != null) {
                return this.m_convertedPoints;
            }
            points = new ArrayList();
            try {
                IFeatureGeometry geom = null;
                if (this.geometryColumn != null && !this.m_records.isNull(this.geometryColumn)) {
                    geom = this.m_records.getFeatureGeometry(this.geometryColumn);
                }
                if (geom == null) {
                    DataCreationLogger.getLogger().logError("No geometry for record: " + this.m_records.getKey());
                    return null;
                }
                if (geom.getType() == GeometryType.POINT) {
                    IPoint pntGeometry = (IPoint)geom;
                    DirectPosition dblpnt = CoordConvertor.transformPointToWGS84((CoordSys)this.m_coordSys, (DirectPosition)pntGeometry.getDirectPosition());
                    points.add(dblpnt);
                    break block7;
                }
                if (geom.getType() == GeometryType.MULTI_CURVE) {
                    points = MidevConversionUtils.getPoints((IMultiCurve)((IMultiCurve)geom), (CoordSys)this.m_coordSys);
                    break block7;
                }
                DataCreationLogger.getLogger().logError("Geometry is not point or line.");
                return null;
            }
            catch (Exception e) {
                DataCreationLogger.getLogger().logInternalError("TabDataSourceRecord:: Problem getting points from Geometry.");
                DataCreationLogger.getLogger().logInternalError(e.getMessage());
                DataCreationLogger.getLogger().logStackTrace(e);
                throw new DataSourceException(8, (Throwable)e);
            }
        }
        this.m_convertedPoints = points;
        return points;
    }

    protected boolean hasField(String fieldKey) {
        if (fieldKey == null) {
            return false;
        }
        String fldValue = this.getFieldName(fieldKey);
        return fldValue != null && !fldValue.equals("NONE");
    }

    protected String getFieldName(String fieldKey) {
        return this.m_properties.getProperty(fieldKey);
    }

    private boolean isZeroPrecisionDecimal(String fldName) {
        IAttributeDefinition metadata = this.m_tabMetaData.getAttributeDefinitions().get(fldName);
        return metadata != null && metadata.getDataType().equals((Object)AttributeType.DBASE_DECIMAL) && metadata.getDecimals() == 0;
    }
}

