/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.tab;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IIntermediateDataFileFormatHandler;
import com.mapinfo.mapmarker.common.dp.IIntermediateDataRecord;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUnitDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.TAIntermediateRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.tab.TabIntermediateRangeDataSourceRecordImpl;
import com.mapinfo.mapmarker.common.dp.tab.TabStreetDataSourceRecord;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class TabIntermediateStreetDataSourceRecord
extends TabStreetDataSourceRecord {
    public TabIntermediateStreetDataSourceRecord(TabDataSourceRecordObjects objects, IIntermediateDataFileFormatHandler dataFileHandler) {
        super(objects, dataFileHandler);
    }

    @Override
    protected ISegmentDataSourceRecord makeSegmentRecord(TabDataSourceRecordObjects objects) {
        boolean hasRightIrregularRange;
        IUnitDataSourceRecord leftUnitRecord = this.makeLeftUnitRecord(objects);
        ArrayList<IUnitDataSourceRecord> leftUnits = new ArrayList<IUnitDataSourceRecord>(1);
        leftUnits.add(leftUnitRecord);
        IUnitDataSourceRecord rightUnitRecord = this.makeRightUnitRecord(objects);
        ArrayList<IUnitDataSourceRecord> rightUnits = new ArrayList<IUnitDataSourceRecord>(1);
        rightUnits.add(rightUnitRecord);
        IIntermediateDataRecord[] leftIntermediateArray = null;
        IIntermediateDataRecord[] rightIntermediateArray = null;
        boolean hasLeftIntermediateHouses = this.hasIntermediateHouseNumbers(objects, 0);
        boolean hasRightIntermediateHouses = this.hasIntermediateHouseNumbers(objects, 1);
        Collection intermediateHouses = null;
        if (hasLeftIntermediateHouses || hasRightIntermediateHouses) {
            intermediateHouses = this.getIrregularHouseNumbers(objects);
        }
        boolean hasLeftIrregularRange = this.getRangeStatus(objects, 0) == 5;
        boolean bl = hasRightIrregularRange = this.getRangeStatus(objects, 1) == 5;
        if (hasLeftIntermediateHouses || hasLeftIrregularRange) {
            leftIntermediateArray = this.makeIntermediateArray(objects, intermediateHouses, 0, hasLeftIrregularRange);
        }
        if (hasRightIntermediateHouses || hasRightIrregularRange) {
            rightIntermediateArray = this.makeIntermediateArray(objects, intermediateHouses, 1, hasRightIrregularRange);
        }
        IRangeDataSourceRecord leftRangeRecord = this.makeLeftRangeRecord(objects, leftUnits, leftIntermediateArray);
        IRangeDataSourceRecord rightRangeRecord = this.makeRightRangeRecord(objects, rightUnits, rightIntermediateArray);
        ArrayList<IRangeDataSourceRecord> ranges = new ArrayList<IRangeDataSourceRecord>(2);
        ranges.add(leftRangeRecord);
        ranges.add(rightRangeRecord);
        return this.makeSegmentRecord(objects, ranges);
    }

    private IIntermediateDataRecord[] makeIntermediateArray(TabDataSourceRecordObjects objects, Collection intermediateRecords, int segmentSide, boolean makeArrayWithoutIntermediates) {
        String to;
        TAIntermediateRecord record2;
        String from;
        String toKey;
        String fromKey;
        boolean isLeft;
        LinkedList<TAIntermediateRecord> records = new LinkedList<TAIntermediateRecord>();
        if (segmentSide == 0) {
            isLeft = true;
            fromKey = "street_fromLeft";
            toKey = "street_toLeft";
        } else {
            isLeft = false;
            fromKey = "street_fromRight";
            toKey = "street_toRight";
        }
        String fromColumn = objects.getProperties().getProperty(fromKey);
        String toColumn = objects.getProperties().getProperty(toKey);
        TabDataSourceRecord tabRecord = new TabDataSourceRecord(objects);
        if (!tabRecord.hasField(fromKey) || !tabRecord.hasField(toKey)) {
            DataCreationLogger.getLogger().logInternalError("Unable to create intermediate array, no from or too mapped");
            DataCreationLogger.getLogger().logInternalError("fromColumn: " + fromColumn);
            DataCreationLogger.getLogger().logInternalError("toColumn: " + toColumn);
            return null;
        }
        try {
            from = tabRecord.getFieldStringValue(fromColumn);
        }
        catch (DataSourceException DSEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to get from: " + fromColumn);
            DataCreationLogger.getLogger().logStackTrace(DSEx);
            return null;
        }
        if (!StringUtilities.isEmpty((String)from)) {
            record2 = new TAIntermediateRecord();
            record2.setHnr(from);
            record2.setSeqNum((short)0);
            records.addFirst(record2);
        }
        boolean foundIntermediates = false;
        if (intermediateRecords != null && !intermediateRecords.isEmpty()) {
            for (TAIntermediateRecord record2 : intermediateRecords) {
                if (isLeft != record2.isLeft()) continue;
                records.add(record2);
                foundIntermediates = true;
            }
        }
        if (!makeArrayWithoutIntermediates && !foundIntermediates) {
            return null;
        }
        Collections.sort(records, new IntermediateDataRecordSequenceNumberComparator());
        for (int i = 0; i < records.size(); ++i) {
            ((IIntermediateDataRecord)records.get(i)).setSeqNum((short)(i + 1));
        }
        try {
            to = tabRecord.getFieldStringValue(toColumn);
        }
        catch (DataSourceException DSEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to get to: " + toColumn);
            DataCreationLogger.getLogger().logStackTrace(DSEx);
            return null;
        }
        if (!StringUtilities.isEmpty((String)to)) {
            record2 = new TAIntermediateRecord();
            record2.setHnr(to);
            record2.setSeqNum((short)(records.size() + 1));
            records.addLast(record2);
        }
        return records.toArray(new IIntermediateDataRecord[records.size()]);
    }

    protected boolean hasIntermediateHouseNumbers(TabDataSourceRecordObjects objects, int segmentSide) {
        return this.getRangeStatus(objects, segmentSide) == 5;
    }

    private int getRangeStatus(TabDataSourceRecordObjects objects, int segmentSide) {
        String statusKey = "";
        statusKey = segmentSide == 0 ? "street_leftRangeStatus" : "street_rightRangeStatus";
        if (!objects.getProperties().containsKey(statusKey)) {
            return 0;
        }
        return objects.getRecordSet().getInt(objects.getProperties().getProperty(statusKey));
    }

    private Collection getIrregularHouseNumbers(TabDataSourceRecordObjects objects) {
        String recordID = objects.getRecordSet().getString(objects.getProperties().getProperty("ta_id_column"));
        List records = this.m_IntermediateFileHandler.getIntermediateRecords(recordID);
        if (records == null || records.isEmpty()) {
            DataCreationLogger.getLogger().logInternalError("Unable to get Irregular House Number records for ID: " + recordID);
        }
        return records;
    }

    protected IRangeDataSourceRecord makeLeftRangeRecord(TabDataSourceRecordObjects objects, ArrayList leftUnits, IIntermediateDataRecord[] recordArray) {
        return new TabIntermediateRangeDataSourceRecordImpl(objects, "street_fromLeft", "street_toLeft", "street_leftRangeStatus", "street_leftPlaceName", leftUnits, true, recordArray);
    }

    protected IRangeDataSourceRecord makeRightRangeRecord(TabDataSourceRecordObjects objects, ArrayList rightUnits, IIntermediateDataRecord[] recordArray) {
        return new TabIntermediateRangeDataSourceRecordImpl(objects, "street_fromRight", "street_toRight", "street_rightRangeStatus", "street_rightPlaceName", rightUnits, false, recordArray);
    }

    private class IntermediateDataRecordSequenceNumberComparator
    implements Comparator<IIntermediateDataRecord> {
        private IntermediateDataRecordSequenceNumberComparator() {
        }

        @Override
        public int compare(IIntermediateDataRecord record1, IIntermediateDataRecord record2) {
            return record1.getSeqNum() - record2.getSeqNum();
        }
    }
}

