/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.tab;

import com.mapinfo.mapmarker.common.dp.tab.TabGeo2SacDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.tab.TabGeoInfoDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.tab.TabPost2SacDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.tab.TabPostInfoDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.tab.TabStreetDataSourceRecord;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class TabSamplePropertiesWriter {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: TabSamplePropertiesWriter <output properties file>");
            System.exit(1);
        }
        TabSamplePropertiesWriter sampleProps = new TabSamplePropertiesWriter();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileOutputStream(args[0]), true);
        }
        catch (IOException IOEx) {
            System.err.println("ERROR: Unable to create output properties file: " + args[0]);
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            System.exit(1);
        }
        writer.println("## Sample processing properties file");
        writer.println();
        writer.println("COUNTRY=<3 char country code>");
        writer.println("useConsole=true");
        writer.println("## Provide full path and file name if you want the log files somewhere other than the working directory.");
        writer.println("statusLog=<status log file name>");
        writer.println("errorLog=<error log file name>");
        writer.println("internalErrorLog=<internal error log file name>");
        writer.println();
        sampleProps.writeStreetProcessingProperties(writer);
        sampleProps.writePost2SacProcessingProperties(writer);
        sampleProps.writeGeo2SacProcessingProperties(writer);
        sampleProps.writePostInfoProcessingProperties(writer);
        sampleProps.writeGeoInfoProcessingProperties(writer);
        writer.close();
    }

    protected void writeStreetProcessingProperties(PrintWriter writer) {
        writer.println("## Street processing properties");
        writer.println("## The street_create property shoud be set to YES to enable street processing");
        writer.println("street_create=NO");
        writer.println("street_outputFile=<output street data file base name e.g. deu0>");
        writer.println("street_outputFilePath=<output street data file path.>");
        writer.println("dataSetPath=<path to the address dictionary.  Used for UDs.>");
        writer.println("street_inputTable=<input tab data file name>");
        writer.println("## startRow and endRow=0 will read all rows from tab file.");
        writer.println("startRow=0");
        writer.println("endRow=0");
        TabStreetDataSourceRecord.writeSampleProperties(writer);
        writer.println();
    }

    protected void writePost2SacProcessingProperties(PrintWriter writer) {
        writer.println("## Post2Sac processing properties");
        writer.println("## The post2sac_create property shoud be set to YES to enable post2sac processing");
        writer.println("## The post2sac.mmj file is the name of the post2sac file and cannot be changed");
        writer.println("post2sac_create=NO");
        writer.println("post2sac_outputFilePath=<output post2sac data file path.>");
        writer.println("post2sac_inputTable=<input tab data file name>");
        TabPost2SacDataSourceRecord.writeSampleProperties(writer);
        writer.println();
    }

    protected void writeGeo2SacProcessingProperties(PrintWriter writer) {
        writer.println("## Geo2Sac processing properties");
        writer.println("## The geo2sac_create property shoud be set to YES to enable geo2sac processing");
        writer.println("## The geo2sac.mmj file is the name of the geo2sac file and cannot be changed");
        writer.println("geo2sac_create=NO");
        writer.println("geo2sac_outputFilePath=<output geo2sac data file path.>");
        writer.println("geo2sac_inputTable=<input tab data file name>");
        TabGeo2SacDataSourceRecord.writeSampleProperties(writer);
        writer.println();
    }

    protected void writePostInfoProcessingProperties(PrintWriter writer) {
        writer.println("## PostInfo processing properties");
        writer.println("## The postInfo_create property shoud be set to YES to enable postInfo processing");
        writer.println("postInfo_create=NO");
        writer.println("postInfo_outputFile=postinfo");
        writer.println("postInfo_outputFilePath=<output postinfo data file path.>");
        writer.println("postInfo_inputTable=<input tab data file name>");
        TabPostInfoDataSourceRecord.writeSampleProperties(writer);
        writer.println();
    }

    protected void writeGeoInfoProcessingProperties(PrintWriter writer) {
        writer.println("## Sample geoInfo processing properties");
        writer.println("## The geoInfo_create property shoud be set to YES to enable geoInfo processing");
        writer.println("geoInfo_create=NO");
        writer.println("geoInfo_outputFile=geoinfo");
        writer.println("geoInfo_outputFilePath=<output geoinfo data file path.>");
        writer.println("geoInfo_inputTable=<input tab data file name>");
        TabGeoInfoDataSourceRecord.writeSampleProperties(writer);
    }
}

