/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class AbbreviationHandler {
    private static final String DEFAULT_DELIMITERS = " \t\n\r\f";

    public static List applyAbbreviations(Map ABBREVIATIONS, String s) {
        return AbbreviationHandler.applyAbbreviations(ABBREVIATIONS, s, DEFAULT_DELIMITERS);
    }

    public static List applyAbbreviations(Map ABBREVIATIONS, String s, String delimiters) throws IllegalStateException {
        if (ABBREVIATIONS == null) {
            throw new IllegalArgumentException("No abbreivations given.");
        }
        if (ABBREVIATIONS.isEmpty()) {
            throw new IllegalArgumentException("Empty abbreviations given.");
        }
        if (s == null) {
            throw new IllegalArgumentException("No string s given.");
        }
        if (delimiters == null) {
            delimiters = "";
        }
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters, true);
        ArrayList results = new ArrayList();
        AbbreviationHandler.apply(ABBREVIATIONS, tokenizer, results);
        return results;
    }

    private static void apply(Map ABBREVIATIONS, StringTokenizer tokens, List currentResults) {
        if (!tokens.hasMoreTokens()) {
            return;
        }
        String token = tokens.nextToken();
        String abbrev = (String)ABBREVIATIONS.get(token);
        List plain = AbbreviationHandler.buildResults(currentResults, token);
        List withAbbrev = AbbreviationHandler.buildResults(currentResults, abbrev);
        currentResults.clear();
        currentResults.addAll(plain);
        currentResults.addAll(withAbbrev);
        AbbreviationHandler.apply(ABBREVIATIONS, tokens, currentResults);
    }

    private static List buildResults(List currentResults, String token) {
        if (token == null) {
            return Collections.EMPTY_LIST;
        }
        if (currentResults.isEmpty()) {
            ArrayList<String> results = new ArrayList<String>();
            results.add(token);
            return results;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (String current : currentResults) {
            results.add(current + token);
        }
        return results;
    }
}

