/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.index.rtree;

import com.mapinfo.midev.index.rtree.IRTreeNode;
import com.mapinfo.midev.index.rtree.IVisitor;

public final class RTreeTraverser {
    private RTreeTraverser() {
    }

    public static <T> void visitAll(IRTreeNode node, IVisitor<T> visitor) {
        if (node.isLeaf()) {
            RTreeTraverser.visitLeafNode(node, visitor);
        } else {
            for (int i = 0; i < node.size(); ++i) {
                IRTreeNode childNode = (IRTreeNode)node.getChild(i);
                RTreeTraverser.visitAll(childNode, visitor);
            }
        }
    }

    private static <T> void visitLeafNode(IRTreeNode node, IVisitor<T> visitor) {
        for (int i = 0; i < node.size(); ++i) {
            Object child = node.getChild(i);
            RTreeTraverser.visitGeometry(child, visitor);
        }
    }

    private static <T> void visitGeometry(T node, IVisitor<T> visitor) {
        visitor.visit(node);
    }
}

