/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.index.rtree;

import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.index.rtree.IEnvelopeDecorator;
import com.mapinfo.midev.index.rtree.IRTreeHelper;
import com.mapinfo.midev.index.rtree.IRTreeNode;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class RTreeUtilities<E> {
    private final IRTreeHelper m_helper;
    private final IEnvelopeDecorator<E> m_decorator;

    RTreeUtilities(IRTreeHelper helper, IEnvelopeDecorator<E> decorator) {
        this.m_helper = helper;
        this.m_decorator = decorator;
    }

    void insert(E data) {
        IRTreeNode newRoot;
        IRTreeNode root = this.m_helper.getRootNode();
        if (root != (newRoot = this.insert(root, data))) {
            this.m_helper.setAsRootNode(newRoot);
        }
    }

    IRTreeNode insert(IRTreeNode node, Object data) {
        if (node.isLeaf()) {
            if (node.size() < this.m_helper.getMaxNodeCapacity()) {
                node.addChild(data);
                Object data1 = data;
                if (node.getBounds() == null) {
                    node.setBounds(this.m_decorator.getEnvelope(data1).getCopy());
                } else {
                    Envelope bounds = node.getBounds();
                    bounds.extend(this.m_decorator.getEnvelope(data1));
                    node.setBounds(bounds);
                }
                if (!node.isRoot()) {
                    RTreeUtilities.enlargeEnvelope(node.getParent(), this.m_decorator.getEnvelope(data1));
                }
            } else if (node.isRoot()) {
                IRTreeNode child = node;
                node = this.m_helper.createNode();
                node.setLevel(1);
                IRTreeNode newChildren = this.splitLeaf(child, data, node);
                this.insertNode(node, child);
                this.insertNode(node, newChildren);
                this.m_helper.setAsRootNode(node);
            } else {
                IRTreeNode splitNode = this.splitLeaf(node, data, node.getParent());
                this.insertNode(node.getParent(), splitNode);
            }
        } else {
            Object data1 = data;
            this.insert((IRTreeNode)this.chooseNode(node, this.m_decorator.getEnvelope(data1)), data);
        }
        return node;
    }

    void delete(E data) {
        ArrayList<Object> stack = new ArrayList<Object>();
        IRTreeNode node = this.m_helper.getRootNode();
        if (this.delete(node, data, stack)) {
            while (node.size() == 1 && !node.isLeaf()) {
                IRTreeNode oldRoot = node;
                node = (IRTreeNode)node.getChild(0);
                node.setParent(null);
                this.m_helper.setAsRootNode(node);
                this.m_helper.deleteNode(oldRoot);
            }
            while (!stack.isEmpty()) {
                Object item = stack.remove(0);
                if (item instanceof IRTreeNode) {
                    this.insertNode(this.findEntry(node, (IRTreeNode)item), (IRTreeNode)item);
                    continue;
                }
                this.insert(node, item);
            }
        }
    }

    void insertNode(IRTreeNode node, IRTreeNode newNode) {
        if (node.size() < this.m_helper.getMaxNodeCapacity()) {
            node.addChild(newNode);
            newNode.setParent(node);
            RTreeUtilities.enlargeEnvelope(node, newNode.getBounds());
        } else {
            this.splitEntry(node, newNode);
        }
    }

    private boolean delete(IRTreeNode node, Object data, List<Object> stack) {
        if (node.isLeaf()) {
            for (int n = 0; n < node.size(); ++n) {
                if (!node.getChild(n).equals(data)) continue;
                node.removeChild(n);
                if (node.size() < this.m_helper.getMinNodeCapacity() && !node.isRoot()) {
                    for (int i = node.size() - 1; i >= 0; --i) {
                        stack.add(node.getChild(i));
                        node.removeChild(i);
                    }
                } else {
                    this.resetEnvelope(node);
                }
                return true;
            }
            return false;
        }
        for (int n = 0; n < node.size(); ++n) {
            Object data1 = data;
            if (!((IRTreeNode)node.getChild(n)).getBounds().contains(this.m_decorator.getEnvelope(data1)) || !this.delete((IRTreeNode)node.getChild(n), data, stack)) continue;
            if (((IRTreeNode)node.getChild(n)).size() == 0) {
                this.delete(node, n, stack);
            }
            return true;
        }
        return false;
    }

    void delete(IRTreeNode node, int n, List<Object> stack) {
        IRTreeNode deleted = (IRTreeNode)node.getChild(n);
        node.removeChild(n);
        this.m_helper.deleteNode(deleted);
        if (node.size() < this.m_helper.getMinNodeCapacity() && !node.isRoot()) {
            for (int i = node.size() - 1; i >= 0; --i) {
                stack.add(node.getChild(i));
                node.removeChild(i);
            }
        } else {
            this.resetEnvelope(node);
        }
    }

    private IRTreeNode findEntry(IRTreeNode node, IRTreeNode newNode) {
        IRTreeNode result = node;
        while (newNode.getLevel() + 1 < result.getLevel()) {
            result = (IRTreeNode)this.chooseNode(result, newNode.getBounds());
        }
        return result;
    }

    Object chooseNode(IRTreeNode node, Envelope env) {
        int size = node.size();
        Object result = node.getChild(0);
        double areaIncrease = RTreeUtilities.getAreaIncrease(this.getSubEnvelope(node, 0), env);
        for (int n = 1; n < size; ++n) {
            double testArea = RTreeUtilities.getAreaIncrease(this.getSubEnvelope(node, n), env);
            if (testArea < areaIncrease) {
                result = node.getChild(n);
                areaIncrease = testArea;
                continue;
            }
            if (testArea != areaIncrease || ((IRTreeNode)node.getChild(n)).size() >= ((IRTreeNode)result).size()) continue;
            result = node.getChild(n);
        }
        return result;
    }

    int[] pickSeeds(Object[] nodes, boolean isLeaf) {
        double inefficiency = Double.NEGATIVE_INFINITY;
        int seed1 = 0;
        int seed2 = 0;
        Envelope e = this.getEnvelope(nodes[0], isLeaf).getCopy();
        for (int i = 0; i < nodes.length; ++i) {
            for (int j = i + 1; j < nodes.length; ++j) {
                e.setEmpty();
                Envelope envelopei = this.getEnvelope(nodes[i], isLeaf);
                Envelope envelopej = this.getEnvelope(nodes[j], isLeaf);
                e.extend(envelopei);
                e.extend(envelopej);
                double d = e.getExtentX() * e.getExtentY() - envelopei.getExtentX() * envelopei.getExtentY() - envelopej.getExtentX() * envelopej.getExtentY();
                if (!(d > inefficiency)) continue;
                inefficiency = d;
                seed1 = i;
                seed2 = j;
            }
        }
        return new int[]{seed1, seed2};
    }

    IRTreeNode splitLeaf(IRTreeNode leaf, Object newDataItem, IRTreeNode parent) {
        Object[] newChildren = new Object[leaf.size() + 1];
        for (int i = 0; i < leaf.size(); ++i) {
            newChildren[i] = leaf.getChild(i);
        }
        newChildren[leaf.size()] = newDataItem;
        int[][] group = this.quadraticSplit(newChildren, this.m_helper.getMinNodeCapacity(), true);
        this.clearNode(leaf);
        leaf.setParent(parent);
        for (int i = 0; i < group[0].length; ++i) {
            Object newChild = newChildren[group[0][i]];
            this.insert(leaf, newChild);
        }
        IRTreeNode secondLeaf = this.m_helper.createNode();
        secondLeaf.setParent(parent);
        for (int i = 0; i < group[1].length; ++i) {
            this.insert(secondLeaf, newChildren[group[1][i]]);
        }
        return secondLeaf;
    }

    void splitEntry(IRTreeNode node, IRTreeNode newNode) {
        int i;
        IRTreeNode node2;
        IRTreeNode node1;
        IRTreeNode parent = node.getParent();
        int maxCapacity = this.m_helper.getMaxNodeCapacity();
        Object[] newChildren = new IRTreeNode[node.size() + 1];
        for (int i2 = 0; i2 < node.size(); ++i2) {
            newChildren[i2] = (IRTreeNode)node.getChild(i2);
        }
        newChildren[node.size()] = newNode;
        int[][] group = this.quadraticSplit(newChildren, maxCapacity / 2, false);
        if (parent == null) {
            node1 = this.m_helper.createNode();
            node1.setParent(node);
            node1.setLevel(node.getLevel());
            node2 = this.m_helper.createNode();
            node2.setParent(node);
            node2.setLevel(node.getLevel());
            this.clearNode(node);
            node.setLevel(node.getLevel() + 1);
        } else {
            node1 = node;
            this.clearNode(node1);
            node1.setParent(parent);
            node2 = this.m_helper.createNode();
            node2.setParent(parent);
            node2.setLevel(node.getLevel());
        }
        for (i = 0; i < group[0].length; ++i) {
            this.insertNode(node1, (IRTreeNode)newChildren[group[0][i]]);
        }
        for (i = 0; i < group[1].length; ++i) {
            this.insertNode(node2, (IRTreeNode)newChildren[group[1][i]]);
        }
        if (parent == null) {
            this.insertNode(node, node1);
            this.insertNode(node, node2);
        } else {
            this.insertNode(parent, node2);
        }
    }

    private static double getAreaIncrease(Envelope ori, Envelope addition) {
        Envelope tr = ori.getCopy();
        tr.extend(addition);
        return tr.getExtentX() * tr.getExtentY() - ori.getExtentX() * ori.getExtentY();
    }

    private int[][] quadraticSplit(Object[] nodes, int minCapacity, boolean isLeaf) {
        int[] mark = new int[nodes.length];
        Arrays.fill(mark, 1);
        int rem = nodes.length;
        TIntArrayList g1 = new TIntArrayList(minCapacity);
        TIntArrayList g2 = new TIntArrayList(minCapacity);
        int[] seed = this.pickSeeds(nodes, isLeaf);
        g1.add(seed[0]);
        g2.add(seed[1]);
        rem -= 2;
        mark[g1.get((int)0)] = -1;
        mark[g2.get((int)0)] = -1;
        Envelope env1 = this.getEnvelope(nodes[seed[0]], isLeaf).getCopy();
        Envelope env2 = this.getEnvelope(nodes[seed[1]], isLeaf).getCopy();
        while (rem > 0) {
            if (g1.size() + rem == minCapacity) {
                for (int i = 0; i < nodes.length; ++i) {
                    if (mark[i] == -1) continue;
                    g1.add(i);
                    mark[i] = -1;
                    --rem;
                }
                continue;
            }
            if (g2.size() + rem == minCapacity) {
                for (int i = 0; i < nodes.length; ++i) {
                    if (mark[i] == -1) continue;
                    g2.add(i);
                    mark[i] = -1;
                    --rem;
                }
                continue;
            }
            double dif = Double.NEGATIVE_INFINITY;
            int sel = -1;
            double savedD1 = 0.0;
            double savedD2 = 0.0;
            for (int i = 0; i < nodes.length; ++i) {
                if (mark[i] == -1) continue;
                Envelope a = env1.getCopy();
                a.extend(this.getEnvelope(nodes[i], isLeaf));
                double d1 = a.getExtentX() * a.getExtentY() - env1.getExtentX() * env1.getExtentY();
                Envelope b = env2.getCopy();
                b.extend(this.getEnvelope(nodes[i], isLeaf));
                double d2 = b.getExtentX() * b.getExtentY() - env2.getExtentX() * env2.getExtentY();
                if (!(Math.abs(d1 - d2) > dif)) continue;
                dif = Math.abs(d1 - d2);
                sel = i;
                savedD1 = d1;
                savedD2 = d2;
            }
            if (savedD1 < savedD2 || savedD1 == savedD2 && (env1.getExtentX() * env1.getExtentY() < env2.getExtentX() * env2.getExtentY() || env1.getExtentX() * env1.getExtentY() == env2.getExtentX() * env2.getExtentY() && g1.size() <= g2.size())) {
                g1.add(sel);
                env1.extend(this.getEnvelope(nodes[sel], isLeaf));
            } else {
                g2.add(sel);
                env2.extend(this.getEnvelope(nodes[sel], isLeaf));
            }
            mark[sel] = -1;
            --rem;
        }
        return new int[][]{g1.toArray(), g2.toArray()};
    }

    private void clearNode(IRTreeNode node) {
        int level = node.getLevel();
        node.clear();
        node.setLevel(level);
        if (!node.isRoot()) {
            this.resetEnvelope(node.getParent());
        }
    }

    private void resetEnvelope(IRTreeNode node) {
        if (node.size() > 0) {
            node.setBounds(this.getSubEnvelope(node, 0).getCopy());
            Envelope bounds = node.getBounds();
            for (int n = 1; n < node.size(); ++n) {
                bounds.extend(this.getSubEnvelope(node, n));
            }
            node.setBounds(bounds);
        } else if (node.getBounds() != null) {
            Envelope bounds = node.getBounds();
            bounds.setEmpty();
            node.setBounds(bounds);
        }
        if (!node.isRoot()) {
            this.resetEnvelope(node.getParent());
        }
    }

    private static void enlargeEnvelope(IRTreeNode node, Envelope env) {
        if (node.getBounds() == null) {
            node.setBounds(env.getCopy());
        } else {
            Envelope bounds = node.getBounds();
            bounds.extend(env);
            node.setBounds(bounds);
        }
        if (!node.isRoot()) {
            RTreeUtilities.enlargeEnvelope(node.getParent(), env);
        }
    }

    Envelope getSubEnvelope(IRTreeNode node, int idx) {
        return this.getEnvelope(node.getChild(idx), node.isLeaf());
    }

    Envelope getEnvelope(Object o, boolean isLeaf) {
        return isLeaf ? this.m_decorator.getEnvelope(o) : ((IRTreeNode)o).getBounds();
    }
}

