/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys;

import com.mapinfo.coordsys.AffineTransform;
import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.GeodeticSpatialReferenceSystem;
import com.mapinfo.coordsys.GeographicCoordinateSystem;
import com.mapinfo.coordsys.HorizontalDatum;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.NonEarthCoordinateSystem;
import com.mapinfo.coordsys.PrimeMeridian;
import com.mapinfo.coordsys.ProjectedCoordinateSystem;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.coordsys.SpatialReferenceSystem;
import com.mapinfo.coordsys.VersionInfo;
import com.mapinfo.coordsys.proj.AlbersEqualAreaConic;
import com.mapinfo.coordsys.proj.AzimuthalEquidistant;
import com.mapinfo.coordsys.proj.CassiniSoldner;
import com.mapinfo.coordsys.proj.CylindricalEqualArea;
import com.mapinfo.coordsys.proj.DoubleStereographic;
import com.mapinfo.coordsys.proj.EckertIV;
import com.mapinfo.coordsys.proj.EckertVI;
import com.mapinfo.coordsys.proj.EquidistantConic;
import com.mapinfo.coordsys.proj.Gall;
import com.mapinfo.coordsys.proj.HotineObliqueMercator;
import com.mapinfo.coordsys.proj.LambertAzimuthalEqualArea;
import com.mapinfo.coordsys.proj.LambertConformalConic;
import com.mapinfo.coordsys.proj.Mercator;
import com.mapinfo.coordsys.proj.Miller;
import com.mapinfo.coordsys.proj.Mollweide;
import com.mapinfo.coordsys.proj.NewZealandMapGrid;
import com.mapinfo.coordsys.proj.Polyconic;
import com.mapinfo.coordsys.proj.Robinson;
import com.mapinfo.coordsys.proj.Sinusoidal;
import com.mapinfo.coordsys.proj.Stereographic;
import com.mapinfo.coordsys.proj.SwissObliqueMercator;
import com.mapinfo.coordsys.proj.TransverseMercator;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.UnitFactory;
import com.mapinfo.unit.UnitUtil;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.DoubleRect;
import com.mapinfo.util.MathUtil;
import com.mapinfo.util.Tokenizer;
import com.mapinfo.xmlprot.csys.CoordSysXMLCreator;
import java.io.Serializable;

public class CoordSys
implements Serializable {
    static final String a = "Noninvertible affine transform";
    private static final String b = "coordsys";
    private static final String c = ", ";
    private static final String d = "epsg";
    static final long serialVersionUID = 8000041693546267866L;
    private SpatialReferenceSystem e;
    private AffineTransform f;
    private int g;
    private double h;
    private Projection i;
    private GeographicCoordinateSystem j;
    private String k;
    private String l = "";
    private String m = "";
    private String n = "";
    public static final CoordSys longLatDatumless;
    public static final CoordSys longLatNAD27;
    public static final CoordSys longLatNAD83;
    public static final CoordSys longLatWGS84;

    private void a(AffineTransform affineTransform) throws Exception {
        if (!affineTransform.isInvertible()) {
            throw new Exception(a);
        }
    }

    private void a(SpatialReferenceSystem spatialReferenceSystem, AffineTransform affineTransform, int n, double d2) {
        this.e = spatialReferenceSystem;
        this.f = affineTransform;
        this.g = n;
        this.h = d2;
        if (this.e instanceof ProjectedCoordinateSystem) {
            this.i = ((ProjectedCoordinateSystem)this.e).getProjection();
        }
        if (this.e instanceof GeodeticSpatialReferenceSystem) {
            this.j = ((GeodeticSpatialReferenceSystem)this.e).getGeographicCoordinateSystem();
        }
    }

    public CoordSys(SpatialReferenceSystem spatialReferenceSystem, AffineTransform affineTransform, int n, double d2) throws Exception {
        this.a(affineTransform);
        this.a(spatialReferenceSystem, affineTransform, n, d2);
    }

    public CoordSys(SpatialReferenceSystem spatialReferenceSystem, AffineTransform affineTransform, int n) throws Exception {
        this(spatialReferenceSystem, affineTransform, n, 1.0E-10);
    }

    public CoordSys(SpatialReferenceSystem spatialReferenceSystem, AffineTransform affineTransform) throws Exception {
        this(spatialReferenceSystem, affineTransform, 1);
    }

    public CoordSys(SpatialReferenceSystem spatialReferenceSystem, AffineTransform affineTransform, String string, String string2) throws Exception {
        this(spatialReferenceSystem, affineTransform, 1);
        this.m = string;
        this.n = string2;
        this.l = string2 + ":" + string;
    }

    private CoordSys(SpatialReferenceSystem spatialReferenceSystem, String string, String string2) {
        this.a(spatialReferenceSystem, AffineTransform.identity, 1, 1.0E-10);
        this.m = string;
        this.n = string2;
        this.l = string2 + ":" + string;
    }

    public CoordSys(SpatialReferenceSystem spatialReferenceSystem, int n) {
        this.a(spatialReferenceSystem, AffineTransform.identity, n, 1.0E-10);
    }

    public CoordSys(SpatialReferenceSystem spatialReferenceSystem) {
        this(spatialReferenceSystem, 1);
    }

    public CoordSys(CoordSys coordSys, AffineTransform affineTransform, int n, double d2) throws Exception {
        this(coordSys.e, new AffineTransform(coordSys.f, affineTransform), n, d2);
    }

    public CoordSys(CoordSys coordSys, AffineTransform affineTransform, int n) throws Exception {
        this(coordSys, affineTransform, n, coordSys.h);
    }

    public CoordSys(CoordSys coordSys, AffineTransform affineTransform) throws Exception {
        this(coordSys, affineTransform, coordSys.g);
    }

    public CoordSys(CoordSys coordSys, DoubleRect doubleRect, DoubleRect doubleRect2, int n, boolean bl, boolean bl2, double d2, int n2) throws Exception {
        if (bl) {
            double d3;
            double d4;
            double d5 = 1.0;
            if (bl2 && coordSys.isLongLat() && coordSys.getAffineTransform().isIdentity()) {
                d5 = Math.cos(AngularUnit.radian.convertClip(d2, coordSys.getAngularUnit(), -80.0, 80.0));
            }
            if ((d4 = (doubleRect = new DoubleRect(doubleRect)).height() * doubleRect2.width()) > (d3 = doubleRect.width() * doubleRect2.height() * d5)) {
                doubleRect.expand(d4 / d5 / doubleRect2.height() - doubleRect.width(), 0.0);
            } else {
                doubleRect.expand(0.0, d3 / doubleRect2.width() - doubleRect.height());
            }
        }
        boolean bl3 = (n == 1 || n == 4) != (coordSys.g == 1 || coordSys.g == 4);
        boolean bl4 = (n == 1 || n == 2) != (coordSys.g == 1 || coordSys.g == 2);
        AffineTransform affineTransform = new AffineTransform(doubleRect, doubleRect2, bl3, bl4);
        AffineTransform affineTransform2 = new AffineTransform(coordSys.f, affineTransform);
        this.a(affineTransform2);
        this.a(coordSys.e, affineTransform2, n, n2);
    }

    public CoordSys(CoordSys coordSys, DoubleRect doubleRect, DoubleRect doubleRect2) throws Exception {
        this(coordSys, doubleRect, doubleRect2, 4, true, true, doubleRect.center().y, 1);
    }

    public boolean equals(Object object) {
        if (object instanceof CoordSys) {
            return this.equals((CoordSys)object);
        }
        return false;
    }

    public boolean equals(CoordSys coordSys) {
        if (this == coordSys) {
            return true;
        }
        return this.equivalent(coordSys) && this.m.equals(coordSys.getCode()) && this.n.equals(coordSys.getCodeSpace());
    }

    public boolean equivalent(CoordSys coordSys) {
        return this.e.equivalent(coordSys.e) && this.f.equivalent(coordSys.f) && this.g == coordSys.g && this.h == coordSys.h;
    }

    public boolean isProjected() {
        return this.i != null;
    }

    public boolean isNonEarth() {
        return this.j == null;
    }

    public boolean isLongLat() {
        return !this.isProjected() && !this.isNonEarth();
    }

    public Projection getProjection() {
        return this.i;
    }

    public GeographicCoordinateSystem getGeographicCoordinateSystem() {
        return this.j;
    }

    public SpatialReferenceSystem getReferenceSystem() {
        return this.e;
    }

    public AffineTransform getAffineTransform() {
        return this.f;
    }

    public int getQuadrant() {
        return this.g;
    }

    public double getPrecision() {
        return this.h;
    }

    public AngularUnit getAngularUnit() {
        return this.e.getAngularUnit();
    }

    public LinearUnit getLinearUnit() {
        return this.e.getLinearUnit();
    }

    void a(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (this.i != null) {
            this.i.forward(dArray, n, dArray2, n2, n3);
            dArray = dArray2;
            n = n2;
        }
        this.f.forward(dArray, n, dArray2, n2, n3);
    }

    void b(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.f.safeInverse(dArray, n, dArray2, n2, n3);
        if (this.i != null) {
            this.i.inverse(dArray2, n2, dArray2, n2, n3);
        }
    }

    public double cartesianDistance(DoublePoint doublePoint, DoublePoint doublePoint2, LinearUnit linearUnit) {
        return this.cartesianDistance(doublePoint.x, doublePoint.y, doublePoint2.x, doublePoint2.y, linearUnit);
    }

    public double cartesianDistance(double d2, double d3, double d4, double d5, LinearUnit linearUnit) {
        double[] dArray = new double[]{d2, d3, d4, d5};
        this.f.safeInverse(dArray, 0, dArray, 0, 2);
        if (this.isProjected() || this.isNonEarth()) {
            LinearUnit linearUnit2 = this.getLinearUnit();
            double d6 = MathUtil.cartesianDistance((double)dArray[0], (double)dArray[1], (double)dArray[2], (double)dArray[3]);
            return linearUnit.convert(d6, linearUnit2);
        }
        AngularUnit angularUnit = this.getAngularUnit();
        AngularUnit angularUnit2 = AngularUnit.radian;
        angularUnit2.convert(dArray, 0, 2, angularUnit);
        dArray[1] = angularUnit2.clipY(dArray[1]);
        dArray[3] = angularUnit2.clipY(dArray[3]);
        double d7 = (dArray[2] - dArray[0]) * Math.cos((dArray[1] + dArray[3]) / 2.0);
        double d8 = dArray[3] - dArray[1];
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        return UnitUtil.convert(d9, angularUnit2, linearUnit);
    }

    public double cartesianDistance(DoublePoint doublePoint, DoublePoint doublePoint2, AngularUnit angularUnit) {
        return this.cartesianDistance(doublePoint.x, doublePoint.y, doublePoint2.x, doublePoint2.y, angularUnit);
    }

    public double cartesianDistance(double d2, double d3, double d4, double d5, AngularUnit angularUnit) {
        double[] dArray = new double[]{d2, d3, d4, d5};
        this.f.safeInverse(dArray, 0, dArray, 0, 2);
        if (this.isProjected() || this.isNonEarth()) {
            LinearUnit linearUnit = this.getLinearUnit();
            double d6 = MathUtil.cartesianDistance((double)dArray[0], (double)dArray[1], (double)dArray[2], (double)dArray[3]);
            return UnitUtil.convert(d6, linearUnit, angularUnit);
        }
        AngularUnit angularUnit2 = this.getAngularUnit();
        AngularUnit angularUnit3 = AngularUnit.radian;
        angularUnit3.convert(dArray, 0, 2, angularUnit2);
        dArray[1] = angularUnit3.clipY(dArray[1]);
        dArray[3] = angularUnit3.clipY(dArray[3]);
        double d7 = (dArray[2] - dArray[0]) * Math.cos((dArray[1] + dArray[3]) / 2.0);
        double d8 = dArray[3] - dArray[1];
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        return angularUnit.convert(d9, angularUnit3);
    }

    public double sphericalDistance(DoublePoint doublePoint, DoublePoint doublePoint2, LinearUnit linearUnit) {
        return this.sphericalDistance(doublePoint.x, doublePoint.y, doublePoint2.x, doublePoint2.y, linearUnit);
    }

    public double sphericalDistance(DoublePoint doublePoint, DoublePoint doublePoint2, AngularUnit angularUnit) {
        return this.sphericalDistance(doublePoint.x, doublePoint.y, doublePoint2.x, doublePoint2.y, angularUnit);
    }

    public double sphericalDistance(double d2, double d3, double d4, double d5, LinearUnit linearUnit) {
        double[] dArray = new double[]{d2, d3, d4, d5};
        this.b(dArray, 0, dArray, 0, 2);
        if (this.isNonEarth()) {
            double d6 = MathUtil.cartesianDistance((double)dArray[0], (double)dArray[1], (double)dArray[2], (double)dArray[3]);
            return linearUnit.convert(d6, this.getLinearUnit());
        }
        AngularUnit.radian.convert(dArray, 0, 2, this.j.getAngularUnit());
        dArray[1] = AngularUnit.radian.clipY(dArray[1]);
        dArray[3] = AngularUnit.radian.clipY(dArray[3]);
        double d7 = Math.sin((dArray[2] - dArray[0]) / 2.0);
        double d8 = Math.sin((dArray[3] - dArray[1]) / 2.0);
        double d9 = d8 * d8 + Math.cos(dArray[1]) * Math.cos(dArray[3]) * d7 * d7;
        d9 = Math.sqrt(Math.max(d9, 0.0));
        d9 = Math.asin(Math.min(d9, 1.0)) * 2.0;
        return UnitUtil.convert(d9, AngularUnit.radian, linearUnit);
    }

    public double sphericalDistance(double d2, double d3, double d4, double d5, AngularUnit angularUnit) {
        double[] dArray = new double[]{d2, d3, d4, d5};
        this.b(dArray, 0, dArray, 0, 2);
        if (this.isNonEarth()) {
            double d6 = MathUtil.cartesianDistance((double)dArray[0], (double)dArray[1], (double)dArray[2], (double)dArray[3]);
            return UnitUtil.convert(d6, this.getLinearUnit(), angularUnit);
        }
        AngularUnit.radian.convert(dArray, 0, 2, this.j.getAngularUnit());
        dArray[1] = AngularUnit.radian.clipY(dArray[1]);
        dArray[3] = AngularUnit.radian.clipY(dArray[3]);
        double d7 = Math.sin((dArray[2] - dArray[0]) / 2.0);
        double d8 = Math.sin((dArray[3] - dArray[1]) / 2.0);
        double d9 = d8 * d8 + Math.cos(dArray[1]) * Math.cos(dArray[3]) * d7 * d7;
        d9 = Math.sqrt(Math.max(d9, 0.0));
        d9 = Math.asin(Math.min(d9, 1.0)) * 2.0;
        return angularUnit.convert(d9, AngularUnit.radian);
    }

    public void adjustPointsUsingDistance(DoublePoint doublePoint, DoublePoint doublePoint2, double d2, LinearUnit linearUnit, boolean bl, boolean bl2) {
        d2 = Math.abs(d2);
        int n = 0;
        while (n < 10) {
            double d3;
            double d4;
            double d5 = this.cartesianDistance(doublePoint, doublePoint2, linearUnit);
            if (d5 == 0.0) {
                if (bl2) {
                    d4 = doublePoint.x == 0.0 ? -1.0 : doublePoint.x / -100.0;
                    d3 = 0.0;
                } else {
                    d4 = 0.0;
                    d3 = doublePoint.y == 0.0 ? -1.0 : doublePoint.y / -100.0;
                }
            } else {
                double d6 = d2 / d5 - 1.0;
                if (Math.abs(d6) < 1.0E-6) {
                    return;
                }
                d4 = (doublePoint2.x - doublePoint.x) * d6;
                d3 = (doublePoint2.y - doublePoint.y) * d6;
            }
            if (bl) {
                doublePoint.offset(-(d4 /= 2.0), -(d3 /= 2.0));
            }
            doublePoint2.offset(d4, d3);
            ++n;
        }
    }

    public String createMapBasicString() {
        return this.computeMapInfoString(true);
    }

    public String createMapXString() {
        return this.computeMapInfoString(false);
    }

    public String toMapBasicString() {
        if (this.k != null) {
            return this.k;
        }
        return this.computeMapInfoString(true);
    }

    public String toMapBasicString2() {
        return this.computeMapInfoString(false);
    }

    public String computeMapInfoString(boolean bl) {
        return this.computeMapInfoString(bl, true);
    }

    public String computeMapInfoString(boolean bl, boolean bl2) {
        MIProProjection mIProProjection = null;
        if (this.i instanceof MIProProjection) {
            mIProProjection = (MIProProjection)this.i;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("CoordSys ");
        }
        if (this.isNonEarth() || this.isProjected() && mIProProjection == null) {
            if (bl) {
                stringBuffer.append("NonEarth Units \"");
                stringBuffer.append(this.getLinearUnit().getAbbreviation());
                stringBuffer.append("\"");
            } else {
                stringBuffer.append("0,");
                stringBuffer.append(String.valueOf(UnitUtil.getLinearUnitIndex(this.getLinearUnit())));
            }
        } else {
            if (bl) {
                stringBuffer.append("Earth Projection ");
            }
            int n = this.isNonEarth() ? 0 : (this.isLongLat() ? 1 : mIProProjection.getType());
            if (!this.f.isIdentity() && !bl) {
                n += 1000;
            }
            stringBuffer.append(n);
            PrimeMeridian primeMeridian = this.j.getPrimeMeridian();
            HorizontalDatum horizontalDatum = this.j.getHorizontalDatum();
            int n2 = horizontalDatum.getIndex();
            if (!primeMeridian.matchesDatumIndex(n2)) {
                n2 = 9999;
            }
            stringBuffer.append(c);
            stringBuffer.append(n2);
            if (n2 == 9999) {
                stringBuffer.append(c);
                stringBuffer.append(horizontalDatum.getEllipsoid().getIndex());
                stringBuffer.append(c);
                stringBuffer.append(horizontalDatum.getShiftX());
                stringBuffer.append(c);
                stringBuffer.append(horizontalDatum.getShiftY());
                stringBuffer.append(c);
                stringBuffer.append(horizontalDatum.getShiftZ());
                stringBuffer.append(c);
                stringBuffer.append(horizontalDatum.getRotateX());
                stringBuffer.append(c);
                stringBuffer.append(horizontalDatum.getRotateY());
                stringBuffer.append(c);
                stringBuffer.append(horizontalDatum.getRotateZ());
                stringBuffer.append(c);
                stringBuffer.append(horizontalDatum.getScaleAdjust());
                stringBuffer.append(c);
                stringBuffer.append(AngularUnit.degree.convert(primeMeridian.getLongitude(), primeMeridian.getAngularUnit()));
            }
            if (mIProProjection != null) {
                LinearUnit linearUnit = mIProProjection.getLinearUnit();
                if (bl) {
                    stringBuffer.append(", \"");
                    stringBuffer.append(linearUnit.getAbbreviation());
                    stringBuffer.append("\"");
                } else {
                    stringBuffer.append(c);
                    stringBuffer.append(UnitUtil.getLinearUnitIndex(linearUnit));
                }
                double[] dArray = mIProProjection.getParamArray(AngularUnit.degree, linearUnit);
                int n3 = 0;
                while (n3 < dArray.length) {
                    stringBuffer.append(c);
                    if (dArray[n3] - Math.floor(dArray[n3]) == 0.0) {
                        stringBuffer.append((int)dArray[n3]);
                    } else {
                        stringBuffer.append(dArray[n3]);
                    }
                    ++n3;
                }
            }
        }
        if (!this.f.isIdentity()) {
            double[] dArray = new double[6];
            this.f.getCoefficients(dArray);
            if (bl) {
                stringBuffer.append(" Affine Units \"");
                if (this.isProjected() || this.isNonEarth()) {
                    stringBuffer.append(this.getLinearUnit().getAbbreviation());
                } else {
                    stringBuffer.append(this.getAngularUnit().getAbbreviation());
                }
                stringBuffer.append("\"");
            } else {
                if (bl2) {
                    stringBuffer.append(c);
                } else {
                    stringBuffer.append(" ");
                }
                if (this.isProjected() || this.isNonEarth()) {
                    stringBuffer.append(UnitUtil.getLinearUnitIndex(this.getLinearUnit()));
                } else {
                    stringBuffer.append(UnitUtil.getAngularUnitIndex(this.getAngularUnit()));
                }
            }
            int n = 0;
            while (n < 6) {
                stringBuffer.append(c);
                stringBuffer.append(dArray[n]);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static CoordSys createFromMapBasic(String string) throws Exception {
        CoordSys coordSys = CoordSys.createFromMapBasic(new Tokenizer(string));
        coordSys.k = string;
        return coordSys;
    }

    public static CoordSys createFromMapBasic(Tokenizer tokenizer) throws Exception {
        AffineTransform affineTransform;
        SpatialReferenceSystem spatialReferenceSystem;
        tokenizer.matchtok(b);
        if (tokenizer.looktok("nonearth")) {
            tokenizer.gettok();
            tokenizer.matchtok("units");
            LinearUnit linearUnit = tokenizer.looktok(2) ? UnitFactory.createLinearUnit(tokenizer.matchstring()) : UnitFactory.createLinearUnit((int)tokenizer.matchnum());
            spatialReferenceSystem = new NonEarthCoordinateSystem(linearUnit);
        } else {
            tokenizer.matchtok("earth");
            if (tokenizer.looktok("projection")) {
                tokenizer.gettok();
                spatialReferenceSystem = CoordSys.a(tokenizer).getReferenceSystem();
            } else {
                spatialReferenceSystem = GeographicCoordinateSystem.datumless;
            }
        }
        if (tokenizer.looktok("affine")) {
            tokenizer.gettok();
            tokenizer.matchtok("units");
            tokenizer.gettok();
            double[] dArray = new double[6];
            int n = 0;
            while (n < 6) {
                tokenizer.matchtok(13);
                dArray[n] = tokenizer.matchnum();
                ++n;
            }
            affineTransform = new AffineTransform(dArray);
        } else {
            affineTransform = AffineTransform.identity;
        }
        return new CoordSys(spatialReferenceSystem, affineTransform);
    }

    public static CoordSys createFromPRJ(String string) throws Exception {
        int n;
        Tokenizer tokenizer = new Tokenizer(string);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (tokenizer.looktok(2)) {
            string2 = tokenizer.matchstring();
            int n2 = string.indexOf("\\p");
            if (n2 != -1) {
                string2 = string.substring(n2 + 2, string.indexOf("\"", n2 + 2));
                n = string2.lastIndexOf(":");
                if (n == -1) {
                    string4 = d;
                    string3 = string2;
                    string2 = string4 + ":" + string3;
                } else {
                    string4 = string2.substring(0, n);
                    string3 = string2.substring(n + 1);
                }
            } else {
                try {
                    Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    string2 = null;
                }
            }
            tokenizer.matchtok(13);
        }
        CoordSys coordSys = CoordSys.a(tokenizer);
        if (string2 != null) {
            coordSys.l = string2.toLowerCase();
            coordSys.m = string3;
            coordSys.n = string4.toLowerCase();
        } else {
            string2 = CoordSysXMLCreator.getSrsName(coordSys);
            if (string2 != null) {
                n = string2.lastIndexOf(":");
                coordSys.l = string2.toLowerCase();
                coordSys.n = string2.substring(0, n).toLowerCase();
                coordSys.m = string2.substring(n + 1);
            } else {
                coordSys.l = "";
                coordSys.m = "";
                coordSys.n = "";
            }
        }
        return coordSys;
    }

    private static CoordSys a(Tokenizer tokenizer) throws Exception {
        AffineTransform affineTransform;
        PrimeMeridian primeMeridian;
        HorizontalDatum horizontalDatum;
        boolean bl = false;
        int n = (int)tokenizer.matchnum();
        if (n >= 2000) {
            n -= 2000;
        }
        if (n >= 1000) {
            n -= 1000;
            bl = true;
        }
        if (n == 0) {
            horizontalDatum = null;
            primeMeridian = null;
        } else {
            tokenizer.matchtok(13);
            int n2 = (int)tokenizer.matchnum();
            if (n2 == 999 || n2 == 9999) {
                tokenizer.matchtok(13);
                Ellipsoid ellipsoid = new Ellipsoid((int)tokenizer.matchnum());
                int n3 = n2 == 999 ? 3 : 7;
                double[] dArray = new double[n3];
                int n4 = 0;
                while (n4 < n3) {
                    tokenizer.matchtok(13);
                    dArray[n4] = tokenizer.matchnum();
                    ++n4;
                }
                horizontalDatum = new HorizontalDatum(ellipsoid, dArray);
                if (n2 == 999) {
                    primeMeridian = PrimeMeridian.greenwich;
                } else {
                    tokenizer.matchtok(13);
                    primeMeridian = new PrimeMeridian(tokenizer.matchnum());
                }
            } else {
                horizontalDatum = new HorizontalDatum(n2);
                primeMeridian = new PrimeMeridian(n2);
            }
        }
        LinearUnit linearUnit = null;
        if (n != 1) {
            tokenizer.matchtok(13);
            linearUnit = tokenizer.looktok(2) ? UnitFactory.createLinearUnit(tokenizer.matchstring()) : UnitFactory.createLinearUnit((int)tokenizer.matchnum());
        }
        int n5 = MIProProjection.getParamCount(n);
        double[] dArray = new double[n5];
        int n6 = 0;
        while (n6 < n5) {
            tokenizer.matchtok(13);
            dArray[n6] = tokenizer.matchnum();
            ++n6;
        }
        if (bl) {
            if (tokenizer.looktok(13)) {
                tokenizer.matchtok(13);
                tokenizer.matchtok(1);
            }
            if (tokenizer.looktok(1)) {
                tokenizer.matchtok(1);
            }
            double[] dArray2 = new double[6];
            int n7 = 0;
            while (n7 < 6) {
                tokenizer.matchtok(13);
                dArray2[n7] = tokenizer.matchnum();
                ++n7;
            }
            affineTransform = new AffineTransform(dArray2);
        } else {
            affineTransform = AffineTransform.identity;
        }
        return new CoordSys(CoordSys.createReferenceSystem(n, linearUnit, horizontalDatum, primeMeridian, dArray), affineTransform);
    }

    public static SpatialReferenceSystem createReferenceSystem(int n, LinearUnit linearUnit, HorizontalDatum horizontalDatum, PrimeMeridian primeMeridian, double[] dArray) {
        MIProProjection mIProProjection;
        switch (n) {
            case 0: {
                return new NonEarthCoordinateSystem(linearUnit);
            }
            case 1: {
                return new GeographicCoordinateSystem(horizontalDatum, AngularUnit.degree, primeMeridian);
            }
            case 2: {
                mIProProjection = new CylindricalEqualArea(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), dArray[0], dArray[1]);
                break;
            }
            case 3: 
            case 19: {
                mIProProjection = new LambertConformalConic(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2], dArray[3], dArray[4], dArray[5], n);
                break;
            }
            case 4: {
                mIProProjection = new LambertAzimuthalEqualArea(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2]);
                break;
            }
            case 5: {
                mIProProjection = new AzimuthalEquidistant(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2]);
                break;
            }
            case 6: {
                mIProProjection = new EquidistantConic(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2], dArray[3], dArray[4], dArray[5]);
                break;
            }
            case 7: {
                mIProProjection = new HotineObliqueMercator(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2], dArray[3], dArray[4], dArray[5]);
                break;
            }
            case 8: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                mIProProjection = new TransverseMercator(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2], dArray[3], dArray[4], n);
                break;
            }
            case 9: {
                mIProProjection = new AlbersEqualAreaConic(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2], dArray[3], dArray[4], dArray[5]);
                break;
            }
            case 10: {
                mIProProjection = new Mercator(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), dArray[0]);
                break;
            }
            case 11: {
                mIProProjection = new Miller(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), dArray[0]);
                break;
            }
            case 12: {
                mIProProjection = new Robinson(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), dArray[0]);
                break;
            }
            case 13: {
                mIProProjection = new Mollweide(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), dArray[0]);
                break;
            }
            case 14: {
                mIProProjection = new EckertIV(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), dArray[0]);
                break;
            }
            case 15: {
                mIProProjection = new EckertVI(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), dArray[0]);
                break;
            }
            case 16: {
                mIProProjection = new Sinusoidal(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), dArray[0]);
                break;
            }
            case 17: {
                mIProProjection = new Gall(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), dArray[0]);
                break;
            }
            case 18: {
                mIProProjection = new NewZealandMapGrid(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2], dArray[3]);
                break;
            }
            case 20: {
                mIProProjection = new Stereographic(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2], dArray[3], dArray[4]);
                break;
            }
            case 25: {
                mIProProjection = new SwissObliqueMercator(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2], dArray[3]);
                break;
            }
            case 26: {
                mIProProjection = new Mercator(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), dArray[0], dArray[1]);
                break;
            }
            case 27: {
                mIProProjection = new Polyconic(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2], dArray[3]);
                break;
            }
            case 28: {
                mIProProjection = new AzimuthalEquidistant(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2]);
                break;
            }
            case 29: {
                mIProProjection = new LambertAzimuthalEqualArea(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2]);
                break;
            }
            case 30: {
                mIProProjection = new CassiniSoldner(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2], dArray[3]);
                break;
            }
            case 31: {
                mIProProjection = new DoubleStereographic(AngularUnit.degree, linearUnit, horizontalDatum.getEllipsoid(), new DoublePoint(dArray[0], dArray[1]), dArray[2], dArray[3], dArray[4]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Projection not supported: " + n);
            }
        }
        return new ProjectedCoordinateSystem(new GeographicCoordinateSystem(horizontalDatum, AngularUnit.degree, primeMeridian), linearUnit, mIProProjection);
    }

    public static String getVersion() {
        return VersionInfo.getFullVersion();
    }

    public String getSrsName() {
        if (this.l.equals(":")) {
            return "";
        }
        return this.l;
    }

    public String getCode() {
        return this.m;
    }

    public String getCodeSpace() {
        return this.n;
    }

    public static void main(String[] stringArray) {
        System.out.println("Version:" + CoordSys.getVersion());
    }

    static {
        a = a;
        b = b;
        c = c;
        d = d;
        serialVersionUID = 8000041693546267866L;
        longLatDatumless = new CoordSys((SpatialReferenceSystem)GeographicCoordinateSystem.datumless, "coordsys1", "mapinfo");
        longLatNAD27 = new CoordSys((SpatialReferenceSystem)GeographicCoordinateSystem.NAD27, "4267", d);
        longLatNAD83 = new CoordSys((SpatialReferenceSystem)GeographicCoordinateSystem.NAD83, "4269", d);
        longLatWGS84 = new CoordSys((SpatialReferenceSystem)GeographicCoordinateSystem.WGS84, "4326", d);
    }
}

