/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys;

import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.util.DoublePoint;

public abstract class MIProProjection
extends Projection {
    public static final short TYPE_NONEARTH = 0;
    public static final short TYPE_LL = 1;
    public static final short TYPE_CEA = 2;
    public static final short TYPE_LAMBERT_CC = 3;
    public static final short TYPE_LAMBERT_AEA = 4;
    public static final short TYPE_AZIMUTHAL = 5;
    public static final short TYPE_CONIC = 6;
    public static final short TYPE_HOTINE = 7;
    public static final short TYPE_TM = 8;
    public static final short TYPE_ALBERS = 9;
    public static final short TYPE_MERCATOR = 10;
    public static final short TYPE_MILLER = 11;
    public static final short TYPE_ROBINSON = 12;
    public static final short TYPE_MOLLWEIDE = 13;
    public static final short TYPE_ECKERT4 = 14;
    public static final short TYPE_ECKERT6 = 15;
    public static final short TYPE_SINUSOIDAL = 16;
    public static final short TYPE_GALL = 17;
    public static final short TYPE_NZMG = 18;
    public static final short TYPE_LAMBERT_BELGIUM72 = 19;
    public static final short TYPE_STEREOGRAPHIC = 20;
    public static final short TYPE_TM_DENMARK_S34J = 21;
    public static final short TYPE_TM_DENMARK_S34S = 22;
    public static final short TYPE_TM_DENMARK_S45B = 23;
    public static final short TYPE_TM_FINLAND = 24;
    public static final short TYPE_SWISS = 25;
    public static final short TYPE_REGIONAL_MERCATOR = 26;
    public static final short TYPE_POLYCONIC = 27;
    public static final short TYPE_AZIMUTHAL_OBLIQUE = 28;
    public static final short TYPE_LAMBERT_AEA_OBLIQUE = 29;
    public static final short TYPE_CASSINI_SOLDNER = 30;
    public static final short TYPE_DOUBLE_STEREOGRAPHIC = 31;
    private static final int[] a;

    public MIProProjection(String string) {
        super(string);
    }

    public static boolean isValidType(int n) {
        return n >= 0 && n <= 25;
    }

    public static int getParamCount(int n) {
        return a[n];
    }

    public abstract int getType();

    public abstract double[] getParamArray(AngularUnit var1, LinearUnit var2);

    protected static boolean a(DoublePoint doublePoint, DoublePoint doublePoint2) {
        double d2 = doublePoint.x - doublePoint2.x;
        double d3 = doublePoint.y - doublePoint2.y;
        return Math.abs(d2) < 1.0E-12 && Math.abs(d3) < 1.0E-12;
    }

    static {
        TYPE_NONEARTH = 0;
        TYPE_LL = 1;
        TYPE_CEA = (short)2;
        TYPE_LAMBERT_CC = (short)3;
        TYPE_LAMBERT_AEA = (short)4;
        TYPE_AZIMUTHAL = (short)5;
        TYPE_CONIC = (short)6;
        TYPE_HOTINE = (short)7;
        TYPE_TM = (short)8;
        TYPE_ALBERS = (short)9;
        TYPE_MERCATOR = (short)10;
        TYPE_MILLER = (short)11;
        TYPE_ROBINSON = (short)12;
        TYPE_MOLLWEIDE = (short)13;
        TYPE_ECKERT4 = (short)14;
        TYPE_ECKERT6 = (short)15;
        TYPE_SINUSOIDAL = (short)16;
        TYPE_GALL = (short)17;
        TYPE_NZMG = (short)18;
        TYPE_LAMBERT_BELGIUM72 = (short)19;
        TYPE_STEREOGRAPHIC = (short)20;
        TYPE_TM_DENMARK_S34J = (short)21;
        TYPE_TM_DENMARK_S34S = (short)22;
        TYPE_TM_DENMARK_S45B = (short)23;
        TYPE_TM_FINLAND = (short)24;
        TYPE_SWISS = (short)25;
        TYPE_REGIONAL_MERCATOR = (short)26;
        TYPE_POLYCONIC = (short)27;
        TYPE_AZIMUTHAL_OBLIQUE = (short)28;
        TYPE_LAMBERT_AEA_OBLIQUE = (short)29;
        TYPE_CASSINI_SOLDNER = (short)30;
        TYPE_DOUBLE_STEREOGRAPHIC = (short)31;
        a = new int[]{0, 0, 2, 6, 3, 3, 6, 6, 5, 6, 1, 1, 1, 1, 1, 1, 1, 1, 4, 6, 5, 5, 5, 5, 5, 4, 2, 4, 3, 3, 4, 5};
    }
}

