/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys;

import com.mapinfo.coordsys.BursaWolfe;
import com.mapinfo.coordsys.GeographicCoordinateSystem;
import com.mapinfo.coordsys.GeographicTransform;
import com.mapinfo.coordsys.HorizontalDatum;
import com.mapinfo.coordsys.PrimeMeridian;
import com.mapinfo.io.LittleEndianDataInput;
import com.mapinfo.io.LittleEndianDataInputStream;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.DoubleRect;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class Nadcon
extends GeographicTransform {
    private static String[] a = new String[]{"conus", "hawaii", "prvi", "stlrnc", "stgeorge", "stpaul", "alaska"};
    private static String[] b = new String[]{".los", ".las"};
    private static Region[] c;
    private boolean d;
    private BursaWolfe e;
    private Region f;
    private Region g;
    private int h;
    private int i;
    private double[] j = new double[2];
    private double[] k = new double[2];
    private double[] l = new double[2];
    private double[] m = new double[2];
    private double[] n = new double[2];
    private DoublePoint o = new DoublePoint();

    public Nadcon(GeographicCoordinateSystem geographicCoordinateSystem, GeographicCoordinateSystem geographicCoordinateSystem2) throws Exception {
        super("NADCON", geographicCoordinateSystem, geographicCoordinateSystem2);
        if (!Nadcon.isSuitable(geographicCoordinateSystem, geographicCoordinateSystem2)) {
            throw new Exception("NADCON is unsuitable for this transform.");
        }
        this.d = geographicCoordinateSystem.getHorizontalDatum().isNAD83();
        this.e = new BursaWolfe(geographicCoordinateSystem, geographicCoordinateSystem2);
    }

    public static synchronized void init(File file) throws Exception {
        if (c == null) {
            Region[] regionArray = new Region[a.length];
            int n = 0;
            while (n < a.length) {
                regionArray[n] = new Region(file, a[n]);
                ++n;
            }
            c = regionArray;
        }
    }

    public static synchronized void terminate() throws IOException {
        if (c != null) {
            int n = 0;
            while (n < c.length) {
                Nadcon.c[n].a[0].close();
                Nadcon.c[n].a[1].close();
                ++n;
            }
            c = null;
        }
    }

    public static boolean isInitialized() {
        return c != null;
    }

    public static boolean isSuitable(GeographicCoordinateSystem geographicCoordinateSystem, GeographicCoordinateSystem geographicCoordinateSystem2) {
        if (!(geographicCoordinateSystem.getAngularUnit().equivalent(AngularUnit.degree) && geographicCoordinateSystem2.getAngularUnit().equivalent(AngularUnit.degree) && geographicCoordinateSystem.getPrimeMeridian().equivalent(PrimeMeridian.greenwich) && geographicCoordinateSystem2.getPrimeMeridian().equivalent(PrimeMeridian.greenwich))) {
            return false;
        }
        HorizontalDatum horizontalDatum = geographicCoordinateSystem.getHorizontalDatum();
        HorizontalDatum horizontalDatum2 = geographicCoordinateSystem2.getHorizontalDatum();
        return horizontalDatum.isNAD27() && horizontalDatum2.isNAD83() || horizontalDatum.isNAD83() && horizontalDatum2.isNAD27();
    }

    private boolean a(double d2, double d3) {
        if (d2 > 0.0) {
            d2 -= 360.0;
        }
        int n = 0;
        while (n < c.length) {
            if (Nadcon.c[n].e.contains(d2, d3, false)) {
                this.f = c[n];
                this.o.x = (d2 - this.f.e.xmin) / this.f.f + 1.0;
                this.o.y = (d3 - this.f.e.ymin) / this.f.g + 1.0;
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(double[] dArray, int n, double[] dArray2, int n2) throws IOException {
        double d2 = dArray[n];
        double d3 = dArray[n + 1];
        if (!this.a(d2, d3)) {
            return false;
        }
        int n3 = (int)this.o.y;
        int n4 = (int)this.o.x;
        if (this.f != this.g || n3 != this.h || n4 != this.i) {
            this.g = null;
            int n5 = 0;
            while (n5 < 2) {
                float f;
                float f2;
                float f3;
                float f4;
                int n6 = (n3 * (this.f.c + 1) + n4) * 4;
                RandomAccessFile randomAccessFile = this.f.a[n5];
                DataInput dataInput = this.f.b[n5];
                RandomAccessFile randomAccessFile2 = randomAccessFile;
                synchronized (randomAccessFile2) {
                    randomAccessFile.seek(n6);
                    f4 = dataInput.readFloat();
                    f3 = dataInput.readFloat();
                    randomAccessFile.seek(n6 + (this.f.c + 1) * 4);
                    f2 = dataInput.readFloat();
                    f = dataInput.readFloat();
                }
                this.j[n5] = f4;
                this.k[n5] = f3 - f4;
                this.l[n5] = f2 - f4;
                this.m[n5] = f - f3 - f2 + f4;
                ++n5;
            }
            this.g = this.f;
            this.h = n3;
            this.i = n4;
        }
        this.o.x -= (double)n4;
        this.o.y -= (double)n3;
        dArray2[n2] = d2 - (this.j[0] + this.k[0] * this.o.x + this.l[0] * this.o.y + this.m[0] * this.o.x * this.o.y) / 3600.0;
        dArray2[n2 + 1] = d3 + (this.j[1] + this.k[1] * this.o.x + this.l[1] * this.o.y + this.m[1] * this.o.x * this.o.y) / 3600.0;
        return true;
    }

    private boolean b(double[] dArray, int n, double[] dArray2, int n2) throws IOException {
        double d2 = dArray[n];
        double d3 = dArray[n + 1];
        dArray2[n2] = d2;
        dArray2[n2 + 1] = d3;
        boolean bl = false;
        int n3 = 0;
        while (!bl && n3 < 10) {
            if (!this.a(dArray2, n2, this.n, 0)) {
                return false;
            }
            double d4 = d2 - this.n[0];
            double d5 = d3 - this.n[1];
            bl = true;
            if (Math.abs(d4) > 1.0E-9) {
                int n4 = n2;
                dArray2[n4] = dArray2[n4] + d4;
                bl = false;
            }
            if (Math.abs(d5) > 1.0E-9) {
                int n5 = n2 + 1;
                dArray2[n5] = dArray2[n5] + d5;
                bl = false;
            }
            ++n3;
        }
        return bl;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.transform(dArray, n, dArray2, n2, n3, true);
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.transform(dArray, n, dArray2, n2, n3, false);
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3, boolean bl) {
        while (n3-- > 0) {
            boolean bl2;
            try {
                bl2 = bl == this.d ? this.b(dArray, n, dArray2, n2) : this.a(dArray, n, dArray2, n2);
            }
            catch (IOException iOException) {
                bl2 = false;
            }
            if (!bl2) {
                this.e.transform(dArray, n, dArray2, n2, 1, bl);
            }
            n += 2;
            n2 += 2;
        }
    }

    private static class Region {
        RandomAccessFile[] a = new RandomAccessFile[2];
        DataInput[] b = new DataInput[2];
        int c;
        int d;
        DoubleRect e = new DoubleRect();
        double f;
        double g;

        Region(File file, String string) throws Exception {
            byte[][] byArray = new byte[2][32];
            int n = 0;
            while (n < 2) {
                File file2 = new File(file, string + b[n]);
                this.a[n] = new RandomAccessFile(file2, "r");
                this.b[n] = new LittleEndianDataInput((DataInput)this.a[n]);
                this.a[n].seek(64L);
                this.a[n].readFully(byArray[n]);
                ++n;
            }
            int n2 = 0;
            while (n2 < 32) {
                if (byArray[0][n2] != byArray[1][n2]) {
                    throw new Exception("Inconsistent NADCON headers for " + string);
                }
                ++n2;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray[0]);
            LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream((InputStream)byteArrayInputStream);
            this.c = littleEndianDataInputStream.readInt();
            this.d = littleEndianDataInputStream.readInt();
            littleEndianDataInputStream.skipBytes(4);
            this.e.xmin = littleEndianDataInputStream.readFloat();
            this.f = littleEndianDataInputStream.readFloat();
            this.e.ymin = littleEndianDataInputStream.readFloat();
            this.g = littleEndianDataInputStream.readFloat();
            this.e.xmax = this.e.xmin + (double)(this.c - 1) * this.f;
            this.e.ymax = this.e.ymin + (double)(this.d - 1) * this.g;
            this.f = Math.abs(this.f);
            this.g = Math.abs(this.g);
        }
    }
}

