/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.SpatialReferenceInfo;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;

public abstract class Projection
extends SpatialReferenceInfo {
    protected AngularUnit m_AngularUnit;
    protected LinearUnit m_LinearUnit;
    protected Ellipsoid m_Ellipsoid;
    protected LinearUnit m_EllipsoidUnit;
    protected static final double COORD_MIN = -1.0E9;
    protected static final double COORD_MAX = 1.0E9;

    public Projection(String string, AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid) {
        super(string);
        this.init(angularUnit, linearUnit, ellipsoid);
    }

    public Projection(String string) {
        this(string, null, null, null);
    }

    public abstract void init(AngularUnit var1, LinearUnit var2, Ellipsoid var3, MeasuredQuantity[] var4);

    protected void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid) {
        this.m_AngularUnit = angularUnit;
        this.m_LinearUnit = linearUnit;
        this.m_Ellipsoid = ellipsoid;
        if (this.m_Ellipsoid != null) {
            this.m_EllipsoidUnit = this.m_Ellipsoid.getAxisUnit();
        }
    }

    public AngularUnit getAngularUnit() {
        return this.m_AngularUnit;
    }

    public LinearUnit getLinearUnit() {
        return this.m_LinearUnit;
    }

    public Ellipsoid getEllipsoid() {
        return this.m_Ellipsoid;
    }

    public boolean equals(Projection projection) {
        return this.m_Ellipsoid.equals(projection.m_Ellipsoid) && this.m_AngularUnit.equals(projection.m_AngularUnit) && this.m_LinearUnit.equals(projection.m_LinearUnit);
    }

    public boolean equivalent(Projection projection) {
        boolean bl = this.m_Ellipsoid.equivalent(projection.m_Ellipsoid);
        return bl;
    }

    public abstract double getScaleFactor(double var1, double var3);

    public abstract void forward(double[] var1, int var2, double[] var3, int var4, int var5);

    public abstract void inverse(double[] var1, int var2, double[] var3, int var4, int var5);

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3, boolean bl) {
        if (bl) {
            this.forward(dArray, n, dArray2, n2, n3);
        } else {
            this.inverse(dArray, n, dArray2, n2, n3);
        }
    }

    static {
        COORD_MIN = -1.0E9;
        COORD_MAX = 1.0E9;
    }
}

