/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.MathUtil;

public class AzimuthalEquidistant
extends MIProProjection {
    double a;
    DoublePoint b;
    private Angle c;
    private Angle d;
    private Angle e;
    double f;
    double g;
    double h;
    double i;
    double j;
    double k;
    double l;
    double m;
    int n;

    public AzimuthalEquidistant() {
        super("Azimuthal Equidistant");
    }

    public AzimuthalEquidistant(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, DoublePoint doublePoint, double d2) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.b = new DoublePoint(doublePoint);
        this.a = d2;
        this.c = new Angle(d2, angularUnit);
        this.d = new Angle(doublePoint.x, angularUnit);
        this.e = new Angle(doublePoint.y, angularUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        DoublePoint doublePoint;
        this.init(angularUnit, linearUnit, ellipsoid);
        this.b = doublePoint = new DoublePoint(measuredQuantityArray[0].getScalarValue(angularUnit), measuredQuantityArray[1].getScalarValue(angularUnit));
        this.a = measuredQuantityArray[2].getScalarValue(angularUnit);
        this.c = new Angle(this.a, angularUnit);
        this.d = new Angle(doublePoint.x, angularUnit);
        this.e = new Angle(doublePoint.y, angularUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Longitude_of_Center\"," + this.b.x + "]," + "PARAMETER[\"Latitude_of_Center\"," + this.b.y + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof AzimuthalEquidistant) {
            AzimuthalEquidistant azimuthalEquidistant = (AzimuthalEquidistant)projection;
            return super.equals(azimuthalEquidistant) && this.b.equals(azimuthalEquidistant.b) && this.a == azimuthalEquidistant.a;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof AzimuthalEquidistant) {
            AzimuthalEquidistant azimuthalEquidistant = (AzimuthalEquidistant)projection;
            boolean bl = super.equivalent(projection) && this.d.equivalent(azimuthalEquidistant.d) && this.e.equivalent(azimuthalEquidistant.e) && this.c.equivalent(azimuthalEquidistant.c);
            return bl;
        }
        return false;
    }

    public int getType() {
        if (this.n == 1 || this.n == -1) {
            return 5;
        }
        return 28;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.b.x, this.m_AngularUnit), angularUnit.convert(this.b.y, this.m_AngularUnit), angularUnit.convert(this.a, this.m_AngularUnit)};
    }

    private void a() {
        this.g = AngularUnit.radian.convertClipX(this.b.x, this.m_AngularUnit);
        this.h = AngularUnit.degree.convertClipY(this.b.y, this.m_AngularUnit);
        this.n = this.h == 90.0 ? 1 : (this.h == -90.0 ? -1 : 0);
        this.h = AngularUnit.radian.convert(this.h, AngularUnit.degree);
        this.i = Math.sin(this.h);
        this.j = Math.cos(this.h);
        this.f = this.m_Ellipsoid.a();
        double d2 = AngularUnit.radian.convertClip(this.a, this.m_AngularUnit, 1.0, 180.0);
        this.k = this.f * d2;
        this.l = MathUtil.clip((double)(this.h - d2), (double)-1.5707963267948966, (double)1.5707963267948966);
        this.m = MathUtil.clip((double)(this.h + d2), (double)-1.5707963267948966, (double)1.5707963267948966);
    }

    public double getScaleFactor(double d2, double d3) {
        return 1.0;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3 = AngularUnit.radian.convertClipX(dArray[n++], this.m_AngularUnit);
            double d4 = AngularUnit.radian.convertClipY(dArray[n++], this.m_AngularUnit);
            double d5 = d3 - this.g;
            if (1 == this.n) {
                d2 = this.f * (1.5707963267948966 - d4);
                d3 = d2 * Math.sin(d5);
                d4 = -d2 * Math.cos(d5);
            } else if (-1 == this.n) {
                d2 = this.f * (1.5707963267948966 + d4);
                d3 = d2 * Math.sin(d5);
                d4 = d2 * Math.cos(d5);
            } else {
                double d6 = Math.cos(d4);
                double d7 = Math.sin(d4);
                double d8 = Math.cos(d5);
                double d9 = Math.acos(this.i * d7 + this.j * d6 * d8);
                double d10 = d9 / Math.sin(d9);
                d2 = this.f * d10;
                d3 = d2 * d6 * Math.sin(d5);
                d4 = d2 * (this.j * d7 - this.i * d6 * d8);
            }
            d2 = Math.sqrt(d3 * d3 + d4 * d4);
            if (d2 > this.k) {
                d2 = this.k / d2;
                d3 *= d2;
                d4 *= d2;
            }
            dArray2[n2++] = this.m_LinearUnit.convert(d3, this.m_EllipsoidUnit);
            dArray2[n2++] = this.m_LinearUnit.convert(d4, this.m_EllipsoidUnit);
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d3 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            d2 = MathUtil.clip((double)d2, (double)-1.0E9, (double)1.0E9);
            d3 = MathUtil.clip((double)d3, (double)-1.0E9, (double)1.0E9);
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            double d5 = d4 / this.f;
            if (d4 != 0.0) {
                d5 = d4 / this.f;
                double d6 = Math.cos(d5);
                if (0 != this.n) {
                    d2 = this.g + Math.atan2(d2, (double)(-this.n) * d3);
                    d3 = Math.asin(MathUtil.clip((double)(d6 * this.i), (double)-1.0, (double)1.0));
                } else {
                    double d7 = Math.sin(d5);
                    d2 = this.g + Math.atan2(d2 * d7, d4 * this.j * d6 - d3 * this.i * d7);
                    d3 = Math.asin(MathUtil.clip((double)(d6 * this.i + d3 * d7 * this.j / d4), (double)-1.0, (double)1.0));
                }
                d3 = MathUtil.clip((double)d3, (double)this.l, (double)this.m);
            } else {
                d2 = this.g;
                d3 = this.h;
            }
            if (d2 > Math.PI) {
                d2 -= Math.PI * 2;
            } else if (d2 < -Math.PI) {
                d2 += Math.PI * 2;
            }
            dArray2[n2++] = this.m_AngularUnit.convert(d2, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d3, AngularUnit.radian);
        }
    }
}

