/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.MathUtil;

public class CylindricalEqualArea
extends MIProProjection {
    private double a;
    private double b;
    private Angle c;
    private Angle d;
    private double e;
    private double f;
    private double g;
    private double h;
    private double i;

    public CylindricalEqualArea() {
        super("Cylindrical Equal-Area");
    }

    public CylindricalEqualArea(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, double d2, double d3) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = d2;
        this.b = d3;
        this.c = new Angle(this.a, angularUnit);
        this.d = new Angle(this.b, angularUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = measuredQuantityArray[0].getScalarValue(angularUnit);
        this.b = measuredQuantityArray[1].getScalarValue(angularUnit);
        this.c = new Angle(this.a, angularUnit);
        this.d = new Angle(this.b, angularUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Central_Meridian\"," + this.a + "]," + "PARAMETER[\"Standard_Parallel_1\"," + this.b + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof CylindricalEqualArea) {
            CylindricalEqualArea cylindricalEqualArea = (CylindricalEqualArea)projection;
            return super.equals(cylindricalEqualArea) && this.a == cylindricalEqualArea.a && this.b == cylindricalEqualArea.b;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof CylindricalEqualArea) {
            CylindricalEqualArea cylindricalEqualArea = (CylindricalEqualArea)projection;
            boolean bl = super.equivalent(cylindricalEqualArea) && this.c.equivalent(cylindricalEqualArea.c) && this.d.equivalent(cylindricalEqualArea.d);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 2;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a, this.m_AngularUnit), angularUnit.convert(this.b, this.m_AngularUnit)};
    }

    private void a() {
        double d2 = AngularUnit.radian.convertClipY(this.b, this.m_AngularUnit);
        this.g = Math.cos(d2);
        if (this.g == 0.0) {
            this.g = 1.0;
        }
        this.e = this.m_Ellipsoid.a();
        this.h = this.e * this.g;
        this.i = this.e / this.g;
        this.f = AngularUnit.radian.convertClipX(this.a, this.m_AngularUnit);
    }

    public double getScaleFactor(double d2, double d3) {
        double d4 = Math.cos(AngularUnit.radian.convertClipY(d3, this.m_AngularUnit));
        double d5 = d4 != 0.0 ? this.g / d4 : 1.0E9;
        return d5;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = AngularUnit.radian.convertClipX(dArray[n++], this.m_AngularUnit);
            double d3 = AngularUnit.radian.convertClipY(dArray[n++], this.m_AngularUnit);
            d2 = (d2 - this.f) * this.h;
            d3 = Math.sin(d3) * this.i;
            dArray2[n2++] = this.m_LinearUnit.convert(d2, this.m_EllipsoidUnit);
            dArray2[n2++] = this.m_LinearUnit.convert(d3, this.m_EllipsoidUnit);
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d3 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            d2 = d2 / this.h + this.f;
            double d4 = d3 / this.i;
            d3 = Math.asin(MathUtil.clip((double)d4, (double)-1.0, (double)1.0));
            dArray2[n2++] = this.m_AngularUnit.convert(d2, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d3, AngularUnit.radian);
        }
    }
}

