/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.Distance;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.MathUtil;

public class DoubleStereographic
extends MIProProjection {
    private static final double a = 1.0E-12;
    private static final int b = 30;
    private DoublePoint c;
    private double d;
    private double e;
    private double f;
    private Angle g;
    private Angle h;
    private Distance i;
    private Distance j;
    private double k;
    private double l;
    private double m;
    private double n;
    private double o;

    public DoubleStereographic() {
        super("Double Stereographic");
    }

    public DoubleStereographic(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, DoublePoint doublePoint, double d2, double d3, double d4) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.c = new DoublePoint(doublePoint);
        this.d = d2;
        this.e = d3;
        this.f = d4;
        this.g = new Angle(doublePoint.x, angularUnit);
        this.h = new Angle(doublePoint.y, angularUnit);
        this.i = new Distance(d3, linearUnit);
        this.j = new Distance(d4, linearUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        DoublePoint doublePoint;
        this.init(angularUnit, linearUnit, ellipsoid);
        this.c = doublePoint = new DoublePoint(measuredQuantityArray[0].getScalarValue(angularUnit), measuredQuantityArray[1].getScalarValue(angularUnit));
        this.d = measuredQuantityArray[2].getScalarValue();
        this.e = measuredQuantityArray[3].getScalarValue(linearUnit);
        this.f = measuredQuantityArray[4].getScalarValue(linearUnit);
        this.g = new Angle(doublePoint.x, angularUnit);
        this.h = new Angle(doublePoint.y, angularUnit);
        this.i = new Distance(this.e, linearUnit);
        this.j = new Distance(this.f, linearUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Longitude_of_Center\"," + this.c.x + "]," + "PARAMETER[\"Latitude_of_Center\"," + this.c.y + "]," + "PARAMETER[\"Scale_Factor\"," + this.d + "]," + "PARAMETER[\"False_Easting\"," + this.e + "]," + "PARAMETER[\"False_Northing\"," + this.f + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof DoubleStereographic) {
            DoubleStereographic doubleStereographic = (DoubleStereographic)projection;
            return super.equals(doubleStereographic) && this.c.equals(doubleStereographic.c) && this.d == doubleStereographic.d && this.e == doubleStereographic.e && this.f == doubleStereographic.f;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof DoubleStereographic) {
            DoubleStereographic doubleStereographic = (DoubleStereographic)projection;
            boolean bl = super.equivalent(doubleStereographic) && this.g.equivalent(doubleStereographic.g) && this.h.equivalent(doubleStereographic.h) && this.d == doubleStereographic.d && this.i.equivalent(doubleStereographic.i) && this.j.equivalent(doubleStereographic.j);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 31;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.c.x, this.m_AngularUnit), angularUnit.convert(this.c.y, this.m_AngularUnit), this.d, linearUnit.convert(this.e, this.m_LinearUnit), linearUnit.convert(this.f, this.m_LinearUnit)};
    }

    private void a() {
        double d2 = AngularUnit.radian.convertClip(this.h.getScalarValue(), this.h.getAngularUnit(), -90.0, 90.0);
        double d3 = Math.sin(d2);
        this.k = Math.sqrt(1.0 + this.m_Ellipsoid.e2() * Math.pow(Math.cos(d2), 4.0) / (1.0 - this.m_Ellipsoid.e2()));
        this.m = Math.asin(MathUtil.clip((double)(d3 / this.k), (double)-1.0, (double)1.0));
        double d4 = Math.tan(0.7853981633974483 + this.m / 2.0);
        double d5 = Math.pow((1.0 - this.m_Ellipsoid.getEccentricity() * d3) / (1.0 + this.m_Ellipsoid.getEccentricity() * d3), this.m_Ellipsoid.getEccentricity() / 2.0);
        this.l = d4 * Math.pow(Math.tan(0.7853981633974483 + d2 / 2.0) * d5, -this.k);
        double d6 = AngularUnit.radian.convertClip(this.g.getScalarValue(), this.g.getAngularUnit(), -360.0, 360.0);
        this.n = this.k * d6;
        double d7 = 1.0 - this.m_Ellipsoid.e2() * d3 * d3;
        double d8 = Math.sqrt(d7);
        double d9 = this.m_Ellipsoid.getSemiMajorAxis() * (1.0 - this.m_Ellipsoid.e2()) / (d7 * d8);
        double d10 = this.m_Ellipsoid.getSemiMajorAxis() / d8;
        this.o = Math.sqrt(d9 * d10);
    }

    public double getScaleFactor(double d2, double d3) {
        d2 = AngularUnit.radian.convert(d2, AngularUnit.degree);
        double d4 = d3 = AngularUnit.radian.convert(d3, AngularUnit.degree);
        DoublePoint doublePoint = this.a(d2, d3);
        double d5 = doublePoint.y;
        double d6 = doublePoint.x;
        double d7 = d6 - this.n;
        double d8 = this.m_Ellipsoid.getSemiMajorAxis() / Math.sqrt(1.0 - this.m_Ellipsoid.e2() * Math.sin(d4) * Math.sin(d4));
        double d9 = Math.cos(d4) * (1.0 + Math.sin(this.m) * Math.sin(d5) + Math.cos(this.m) * Math.cos(d5) * Math.cos(d7));
        double d10 = d9 == 0.0 ? 1.0 : 2.0 * this.d * this.k * this.o * Math.cos(d5) / (d8 * d9);
        return d10;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        double d2 = Math.sin(this.m);
        double d3 = Math.cos(this.m);
        while (n3-- > 0) {
            double d4 = AngularUnit.radian.convertClip(dArray[n++], this.m_AngularUnit, -360.0, 360.0);
            double d5 = AngularUnit.radian.convertClip(dArray[n++], this.m_AngularUnit, -90.0, 90.0);
            DoublePoint doublePoint = this.a(d4, d5);
            double d6 = doublePoint.y;
            double d7 = doublePoint.x;
            double d8 = Math.cos(d6);
            double d9 = Math.sin(d6);
            double d10 = Math.sin(d7 - this.n);
            double d11 = Math.cos(d7 - this.n);
            double d12 = 1.0 + d9 * d2 + d8 * d3 * d11;
            if (d12 == 0.0) {
                d12 = 1.0;
            }
            d4 = 2.0 * this.d * this.o * d8 * d10 / d12;
            d5 = 2.0 * this.d * this.o * (d9 * d3 - d8 * d2 * d11) / d12;
            dArray2[n2++] = this.m_LinearUnit.convert(d4, this.m_EllipsoidUnit) + this.e;
            dArray2[n2++] = this.m_LinearUnit.convert(d5, this.m_EllipsoidUnit) + this.f;
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        double d2 = Math.sin(this.m);
        double d3 = Math.cos(this.m);
        while (n3-- > 0) {
            double d4;
            double d5;
            double d6 = this.m_EllipsoidUnit.convert(dArray[n++] - this.e, this.m_LinearUnit);
            double d7 = this.m_EllipsoidUnit.convert(dArray[n++] - this.f, this.m_LinearUnit);
            double d8 = d6 / this.d;
            double d9 = d7 / this.d;
            double d10 = Math.sqrt(d8 * d8 + d9 * d9);
            double d11 = 2.0 * Math.atan(d10 / (2.0 * this.o));
            if (d10 == 0.0) {
                d5 = 0.0;
                d4 = 1.0;
            } else {
                d4 = d8 / d10;
                d5 = d9 / d10;
            }
            double d12 = d7 = Math.asin(MathUtil.clip((double)(d2 * Math.cos(d11) + Math.sin(d11) * d3 * d5), (double)-1.0, (double)1.0));
            d6 = Math.cos(d12) == 0.0 ? this.n : this.n + Math.asin(MathUtil.clip((double)(Math.sin(d11) * d4 / Math.cos(d12)), (double)-1.0, (double)1.0));
            DoublePoint doublePoint = this.b(d6, d7);
            dArray2[n2++] = this.m_AngularUnit.convert(doublePoint.x, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(doublePoint.y, AngularUnit.radian);
        }
    }

    private DoublePoint a(double d2, double d3) {
        double d4 = d3;
        double d5 = d2;
        double d6 = this.m_Ellipsoid.getEccentricity() * Math.sin(d4);
        double d7 = Math.tan(0.7853981633974483 + d4 / 2.0);
        double d8 = Math.pow((1.0 - d6) / (1.0 + d6), this.m_Ellipsoid.getEccentricity() / 2.0);
        double d9 = this.l * Math.pow(d7 * d8, this.k);
        return new DoublePoint(this.k * d5, 2.0 * Math.atan(d9) - 1.5707963267948966);
    }

    private DoublePoint b(double d2, double d3) {
        double d4;
        int n = 1;
        double d5 = d3;
        double d6 = d2;
        double d7 = d4 = d5;
        double d8 = 1.0;
        while (d8 > 1.0E-12 && n <= 30) {
            d7 = this.c(d4, d5);
            d8 = Math.abs(d7 - d4);
            d4 = d7;
            ++n;
        }
        return new DoublePoint(d6 / this.k, d7);
    }

    private double c(double d2, double d3) {
        double d4 = Math.tan(0.7853981633974483 + d2 / 2.0);
        double d5 = this.m_Ellipsoid.getEccentricity() * Math.sin(d2);
        double d6 = Math.pow((1.0 - d5) / (1.0 + d5), this.m_Ellipsoid.getEccentricity() / 2.0);
        double d7 = 1.0 / Math.cos(0.7853981633974483 + d2 / 2.0);
        double d8 = d7 * d7;
        double d9 = this.l * Math.pow(d4 * d6, this.k) - Math.tan(0.7853981633974483 + d3 / 2.0);
        double d10 = this.k * this.l * Math.pow(d4 * d6, this.k - 1.0) * d6 * (0.5 * d8 - this.m_Ellipsoid.getEccentricity() * this.m_Ellipsoid.getEccentricity() * Math.cos(d2) * d4 / (1.0 - d5 * d5));
        return d10 == 0.0 ? d2 : d2 - d9 / d10;
    }

    static {
        a = 1.0E-12;
        b = 30;
    }
}

