/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.MathUtil;

public class EckertIV
extends MIProProjection {
    private double a;
    private Angle b;
    private double c;
    private double d;
    private double e;
    private double f;

    public EckertIV() {
        super("Eckert IV");
    }

    public EckertIV(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, double d2) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = d2;
        this.b = new Angle(d2, angularUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = measuredQuantityArray[0].getScalarValue(angularUnit);
        this.b = new Angle(this.a, angularUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"CentralMeridian\"," + this.a + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof EckertIV) {
            EckertIV eckertIV = (EckertIV)projection;
            return super.equals(eckertIV) && this.a == eckertIV.a;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof EckertIV) {
            EckertIV eckertIV = (EckertIV)projection;
            boolean bl = super.equivalent(eckertIV) && this.b.equivalent(eckertIV.b);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 14;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a, this.m_AngularUnit)};
    }

    private void a() {
        this.c = this.m_Ellipsoid.a();
        this.e = 2.0 * this.c / Math.sqrt(22.43597501544853);
        this.f = 2.0 * this.c * Math.sqrt(0.43990084648844263);
        this.d = AngularUnit.radian.convertClipX(this.a, this.m_AngularUnit);
    }

    public double getScaleFactor(double d2, double d3) {
        double d4;
        double d5 = AngularUnit.radian.convertClipY(d3, this.m_AngularUnit);
        double d6 = Math.cos(d5);
        if (d6 == 0.0) {
            d4 = 1.0E9;
        } else {
            double d7;
            double d8 = 3.5707963267948966 * Math.sin(d5);
            double d9 = d5 / 2.0;
            while (true) {
                d7 = Math.cos(d9);
                double d10 = (d9 + Math.sin(d9) * (d7 + 2.0) - d8) / (2.0 * d7 * (1.0 + d7));
                if (d10 > -1.0E-7 && d10 < 1.0E-7) break;
                d9 -= d10;
            }
            d4 = this.e * (1.0 + d7) / (this.c * d6);
        }
        return d4;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3;
            double d4;
            double d5 = AngularUnit.radian.convertClipX(dArray[n++], this.m_AngularUnit);
            double d6 = AngularUnit.radian.convertClipY(dArray[n++], this.m_AngularUnit);
            double d7 = d5;
            double d8 = d6;
            double d9 = 3.5707963267948966 * Math.sin(d8);
            double d10 = d8 / 2.0;
            while (!((d4 = (d10 + (d3 = Math.sin(d10)) * ((d2 = Math.cos(d10)) + 2.0) - d9) / (2.0 * d2 * (1.0 + d2))) > -1.0E-7) || !(d4 < 1.0E-7)) {
                d10 -= d4;
            }
            d5 = this.e * (d7 - this.d) * (1.0 + d2);
            d6 = this.f * d3;
            dArray2[n2++] = this.m_LinearUnit.convert(d5, this.m_EllipsoidUnit);
            dArray2[n2++] = this.m_LinearUnit.convert(d6, this.m_EllipsoidUnit);
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d3 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d4 = d3 / this.f;
            double d5 = Math.asin(MathUtil.clip((double)d4, (double)-1.0, (double)1.0));
            double d6 = Math.cos(d5);
            d4 = (d5 + Math.sin(d5) * (d6 + 2.0)) / 3.5707963267948966;
            d3 = Math.asin(MathUtil.clip((double)d4, (double)-1.0, (double)1.0));
            d2 = this.d + d2 / (this.e * (1.0 + d6));
            dArray2[n2++] = this.m_AngularUnit.convert(d2, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d3, AngularUnit.radian);
        }
    }
}

