/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.Distance;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.MathUtil;

public class HotineObliqueMercator
extends MIProProjection {
    private DoublePoint a;
    private double b;
    private double c;
    private double d;
    private double e;
    private Angle f;
    private Angle g;
    private Angle h;
    private Distance i;
    private Distance j;
    private double k;
    private double l;
    private double m;
    private double n;
    private double o;
    private double p;
    private double q;
    private double r;
    private double s;
    private double t;
    private double u;
    private double v;
    private double w;
    private double x;

    public HotineObliqueMercator() {
        super("Hotine Oblique Mercator");
    }

    public HotineObliqueMercator(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, DoublePoint doublePoint, double d2, double d3, double d4, double d5) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = new DoublePoint(doublePoint);
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.e = d5;
        this.f = new Angle(doublePoint.x, angularUnit);
        this.g = new Angle(doublePoint.y, angularUnit);
        this.h = new Angle(this.b, angularUnit);
        this.i = new Distance(this.d, linearUnit);
        this.j = new Distance(this.e, linearUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        DoublePoint doublePoint;
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = doublePoint = new DoublePoint(measuredQuantityArray[0].getScalarValue(angularUnit), measuredQuantityArray[1].getScalarValue(angularUnit));
        this.b = measuredQuantityArray[2].getScalarValue(angularUnit);
        this.c = measuredQuantityArray[3].getScalarValue();
        this.d = measuredQuantityArray[4].getScalarValue(linearUnit);
        this.e = measuredQuantityArray[5].getScalarValue(linearUnit);
        this.f = new Angle(doublePoint.x, angularUnit);
        this.g = new Angle(doublePoint.y, angularUnit);
        this.h = new Angle(this.b, angularUnit);
        this.i = new Distance(this.d, linearUnit);
        this.j = new Distance(this.e, linearUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Longitude_of_Center\"," + this.a.x + "]," + "PARAMETER[\"Latitude_of_Center\"," + this.a.y + "]," + "PARAMETER[\"Azimuth\"," + this.b + "]," + "PARAMETER[\"Scale_Factor\"," + this.c + "]," + "PARAMETER[\"False_Easting\"," + this.d + "]," + "PARAMETER[\"False_Northing\"," + this.e + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof HotineObliqueMercator) {
            HotineObliqueMercator hotineObliqueMercator = (HotineObliqueMercator)projection;
            return super.equals(hotineObliqueMercator) && this.a.equals(hotineObliqueMercator.a) && this.b == hotineObliqueMercator.b && this.c == hotineObliqueMercator.c && this.d == hotineObliqueMercator.d && this.e == hotineObliqueMercator.e;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof HotineObliqueMercator) {
            HotineObliqueMercator hotineObliqueMercator = (HotineObliqueMercator)projection;
            boolean bl = super.equivalent(hotineObliqueMercator) && this.f.equivalent(hotineObliqueMercator.f) && this.g.equivalent(hotineObliqueMercator.g) && this.c == hotineObliqueMercator.c && this.i.equivalent(hotineObliqueMercator.i) && this.j.equivalent(hotineObliqueMercator.j) && this.h.equivalent(hotineObliqueMercator.h);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 7;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a.x, this.m_AngularUnit), angularUnit.convert(this.a.y, this.m_AngularUnit), angularUnit.convert(this.b, this.m_AngularUnit), this.c, linearUnit.convert(this.d, this.m_LinearUnit), linearUnit.convert(this.e, this.m_LinearUnit)};
    }

    private void a() {
        double d2;
        double d3 = AngularUnit.radian.convertClipX(this.a.x, this.m_AngularUnit);
        double d4 = AngularUnit.radian.convertClipY(this.a.y, this.m_AngularUnit);
        double d5 = AngularUnit.radian.convertClipX(this.b, this.m_AngularUnit);
        this.p = Math.sin(d5);
        this.q = Math.cos(d5);
        this.k = this.m_Ellipsoid.e();
        double d6 = this.c;
        if (d6 == 0.0) {
            d6 = 1.0;
        }
        double d7 = Math.cos(d4);
        double d8 = d7 * d7;
        double d9 = Math.sin(d4);
        double d10 = this.k * d9;
        double d11 = d10 * d10;
        this.n = Math.sqrt(1.0 + this.m_Ellipsoid.e2() * d8 * d8 / (1.0 - this.m_Ellipsoid.e2()));
        this.m = this.m_Ellipsoid.a() * this.n * d6 * Math.sqrt(1.0 - this.m_Ellipsoid.e2()) / (1.0 - d11);
        double d12 = 1.0 + d9;
        double d13 = d12 != 0.0 ? Math.sqrt((1.0 - d9) / d12 * Math.pow((1.0 + d10) / (1.0 - d10), this.k)) : 1.0E9;
        d12 = d7 * Math.sqrt(1.0 - d11);
        double d14 = d12 != 0.0 ? this.n * Math.sqrt(1.0 - this.m_Ellipsoid.e2()) / d12 : 1.0E9;
        double d15 = d14 * d14;
        if (d2 < 1.0) {
            d15 = 1.0;
        }
        double d16 = d4 > 0.0 ? d14 + Math.sqrt(d15 - 1.0) : d14 - Math.sqrt(d15 - 1.0);
        this.o = d16 * Math.pow(d13, this.n);
        double d17 = d16 != 0.0 ? (d16 - 1.0 / d16) / 2.0 : -1.0E9;
        d12 = this.p / d14;
        this.s = MathUtil.clip((double)d12, (double)-1.0, (double)1.0);
        this.r = Math.asin(this.s);
        this.t = Math.cos(this.r);
        d12 = d17 * Math.tan(this.r);
        this.l = d3 - Math.asin(MathUtil.clip((double)d12, (double)-1.0, (double)1.0)) / this.n;
        double d18 = this.m_Ellipsoid.e2() * this.m_Ellipsoid.e2();
        double d19 = this.m_Ellipsoid.e2() * d18;
        double d20 = d18 * d18;
        double d21 = this.m_Ellipsoid.e2() / 2.0 + 5.0 * d18 / 24.0 + d19 / 12.0 + 13.0 * d20 / 360.0;
        double d22 = 7.0 * d18 / 48.0 + 29.0 * d19 / 240.0 + 811.0 * d20 / 11520.0;
        double d23 = 7.0 * d19 / 120.0 + 81.0 * d20 / 1120.0;
        d14 = 4279.0 * d20 / 161280.0;
        this.u = d21 - d23;
        this.v = 2.0 * d22 - 4.0 * d14;
        this.w = 4.0 * d23;
        this.x = 8.0 * d14;
    }

    public double getScaleFactor(double d2, double d3) {
        double d4;
        double d5 = AngularUnit.radian.convertClipY(d3, this.m_AngularUnit);
        double d6 = AngularUnit.radian.convertClipX(d2, this.m_AngularUnit);
        double d7 = Math.sin(d5);
        double d8 = this.k * d7;
        double d9 = this.n * (d6 - this.l);
        double d10 = Math.cos(d9);
        if (d7 == 1.0) {
            d4 = this.m * d5 / this.n;
        } else if (d7 == -1.0) {
            d4 = this.m * d5 / this.n;
        } else {
            double d11 = Math.sqrt((1.0 - d7) / (1.0 + d7) * Math.pow((1.0 + d8) / (1.0 - d8), this.k));
            double d12 = this.o / Math.pow(d11, this.n);
            double d13 = d12 != 0.0 ? (d12 - 1.0 / d12) / 2.0 : -1.0E9;
            double d14 = Math.sin(d9);
            d4 = d10 != 0.0 ? this.m * Math.atan2(d13 * this.t + d14 * this.s, d10) / this.n : this.m * d9;
        }
        double d15 = this.m_Ellipsoid.a() * Math.cos(d5) * d10;
        double d16 = d15 != 0.0 ? this.m * Math.cos(this.n * d4 / this.m) * Math.sqrt(1.0 - d8 * d8) / d15 : 1.0E9;
        return d16;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6 = AngularUnit.radian.convertClipX(dArray[n++], this.m_AngularUnit);
            double d7 = d5 = AngularUnit.radian.convertClipY(dArray[n++], this.m_AngularUnit);
            double d8 = Math.sin(d7);
            double d9 = this.k * d8;
            if (d8 == 1.0) {
                double d10;
                d4 = this.m * d7 / this.n;
                d3 = Math.tan(0.7853981633974483 - this.r / 2.0);
                d2 = d10 > 0.0 ? this.m / this.n * Math.log(d3) : -1.0E9;
            } else if (d8 == -1.0) {
                double d11;
                d4 = this.m * d7 / this.n;
                d3 = Math.tan(0.7853981633974483 + this.r / 2.0);
                d2 = d11 > 0.0 ? this.m / this.n * Math.log(d3) : -1.0E9;
            } else {
                double d12;
                double d13;
                double d14 = Math.sqrt((1.0 - d8) / (1.0 + d8) * Math.pow((1.0 + d9) / (1.0 - d9), this.k));
                double d15 = this.o / Math.pow(d14, this.n);
                if (d15 != 0.0) {
                    d3 = 1.0 / d15;
                    d13 = (d15 - d3) / 2.0;
                    d12 = (d15 + d3) / 2.0;
                } else {
                    d13 = -1.0E9;
                    d12 = 1.0E9;
                }
                double d16 = this.n * (d6 - this.l);
                double d17 = Math.sin(d16);
                double d18 = (-d17 * this.t + d13 * this.s) / d12;
                d2 = d18 == 1.0 ? -1.0E9 : (d18 == -1.0 ? 1.0E9 : this.m * Math.log((1.0 - d18) / (1.0 + d18)) / (2.0 * this.n));
                d3 = Math.cos(d16);
                d4 = d3 != 0.0 ? this.m * Math.atan2(d13 * this.t + d17 * this.s, d3) / this.n : this.m * d16;
            }
            d6 = d2 * this.q + d4 * this.p;
            d5 = d4 * this.q - d2 * this.p;
            dArray2[n2++] = this.m_LinearUnit.convert(d6, this.m_EllipsoidUnit) + this.d;
            dArray2[n2++] = this.m_LinearUnit.convert(d5, this.m_EllipsoidUnit) + this.e;
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        double d2 = this.n / this.m;
        while (n3-- > 0) {
            double d3 = this.m_EllipsoidUnit.convert(dArray[n++] - this.d, this.m_LinearUnit);
            double d4 = this.m_EllipsoidUnit.convert(dArray[n++] - this.e, this.m_LinearUnit);
            d3 = MathUtil.clip((double)d3, (double)-1.0E9, (double)1.0E9);
            d4 = MathUtil.clip((double)d4, (double)-1.0E9, (double)1.0E9);
            double d5 = d3 * this.q - d4 * this.p;
            double d6 = d4 * this.q + d3 * this.p;
            double d7 = -d2 * d5;
            double d8 = d7 < -100.0 ? 1.0E-9 : (d7 > 100.0 ? 1.0E9 : Math.exp(d7));
            d7 = 1.0 / d8;
            double d9 = (d8 - d7) / 2.0;
            double d10 = (d8 + d7) / 2.0;
            double d11 = Math.sin(d2 * d6);
            double d12 = (d11 * this.t + d9 * this.s) / d10;
            if (Math.abs(d12) >= 1.0) {
                d3 = this.l;
                d4 = d12 > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
            } else {
                double d13 = Math.pow(this.o / Math.sqrt((1.0 + d12) / (1.0 - d12)), 1.0 / this.n);
                double d14 = d9 * this.t - d11 * this.s;
                double d15 = Math.cos(d2 * d6);
                d3 = d14 == 0.0 && d15 == 0.0 ? this.l : this.l - Math.atan2(d14, d15) / this.n;
                double d16 = 1.5707963267948966 - 2.0 * Math.atan(d13);
                double d17 = 2.0 * d16;
                double d18 = Math.cos(d17);
                d4 = d16 + Math.sin(d17) * (this.u + d18 * (this.v + d18 * (this.w + d18 * this.x)));
            }
            dArray2[n2++] = this.m_AngularUnit.convert(d3, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d4, AngularUnit.radian);
        }
    }
}

