/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.Distance;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.DoublePoint;

public class LambertConformalConic
extends MIProProjection {
    private DoublePoint a;
    private double b;
    private double c;
    private double d;
    private double e;
    private Angle f;
    private Angle g;
    private Angle h;
    private Angle i;
    private Distance j;
    private Distance k;
    private int l;
    private double m;
    private double n;
    private double o;
    private double p;
    private double q;
    private double r;
    private double s;
    private double t;
    private double u;
    private double v;
    private boolean w;

    public LambertConformalConic() {
        super("Lambert Conformal Conic");
    }

    public LambertConformalConic(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, DoublePoint doublePoint, double d2, double d3, double d4, double d5, int n) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = new DoublePoint(doublePoint);
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.e = d5;
        this.l = n;
        this.f = new Angle(doublePoint.x, angularUnit);
        this.g = new Angle(doublePoint.y, angularUnit);
        this.h = new Angle(d2, angularUnit);
        this.i = new Angle(d3, angularUnit);
        this.j = new Distance(d4, linearUnit);
        this.k = new Distance(d5, linearUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        DoublePoint doublePoint;
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = doublePoint = new DoublePoint(measuredQuantityArray[0].getScalarValue(angularUnit), measuredQuantityArray[1].getScalarValue(angularUnit));
        this.b = measuredQuantityArray[2].getScalarValue(angularUnit);
        this.c = measuredQuantityArray[3].getScalarValue(angularUnit);
        this.d = measuredQuantityArray[4].getScalarValue(linearUnit);
        this.e = measuredQuantityArray[5].getScalarValue(linearUnit);
        this.l = measuredQuantityArray.length == 7 ? (int)measuredQuantityArray[6].getScalarValue() : 3;
        this.f = new Angle(doublePoint.x, angularUnit);
        this.g = new Angle(doublePoint.y, angularUnit);
        this.h = new Angle(this.b, angularUnit);
        this.i = new Angle(this.c, angularUnit);
        this.j = new Distance(this.d, linearUnit);
        this.k = new Distance(this.e, linearUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Central_Meridian\"," + this.a.x + "]," + "PARAMETER[\"Latitude_of_Origin\"," + this.a.y + "]," + "PARAMETER[\"Standard_Parallel_1\"," + this.b + "]," + "PARAMETER[\"Standard_Parallel_2\"," + this.c + "]," + "PARAMETER[\"False_Easting\"," + this.d + "]," + "PARAMETER[\"False_Northing\"," + this.e + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof LambertConformalConic) {
            LambertConformalConic lambertConformalConic = (LambertConformalConic)projection;
            return super.equals(lambertConformalConic) && this.a.equals(lambertConformalConic.a) && this.b == lambertConformalConic.b && this.c == lambertConformalConic.c && this.d == lambertConformalConic.d && this.e == lambertConformalConic.e && this.l == lambertConformalConic.l;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof LambertConformalConic) {
            LambertConformalConic lambertConformalConic = (LambertConformalConic)projection;
            boolean bl = super.equivalent(projection) && this.f.equivalent(lambertConformalConic.f) && this.g.equivalent(lambertConformalConic.g) && this.h.equivalent(lambertConformalConic.h) && this.i.equivalent(lambertConformalConic.i) && this.j.equivalent(lambertConformalConic.j) && this.k.equivalent(lambertConformalConic.k) && this.l == lambertConformalConic.l;
            return bl;
        }
        return false;
    }

    public static boolean isValidType(int n) {
        return n == 3 || n == 19;
    }

    public int getType() {
        return this.l;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a.x, this.m_AngularUnit), angularUnit.convert(this.a.y, this.m_AngularUnit), angularUnit.convert(this.b, this.m_AngularUnit), angularUnit.convert(this.c, this.m_AngularUnit), linearUnit.convert(this.d, this.m_LinearUnit), linearUnit.convert(this.e, this.m_LinearUnit)};
    }

    private void a() {
        double d2;
        if (!LambertConformalConic.isValidType(this.l)) {
            this.l = 3;
        }
        this.n = AngularUnit.radian.convertClipX(this.a.x, this.m_AngularUnit);
        this.m = this.m_Ellipsoid.e();
        double d3 = AngularUnit.radian.convertClipY(this.a.y, this.m_AngularUnit);
        double d4 = AngularUnit.radian.convertClipY(this.b, this.m_AngularUnit);
        double d5 = AngularUnit.radian.convertClipY(this.c, this.m_AngularUnit);
        double d6 = Math.sin(d3);
        double d7 = this.m * d6;
        double d8 = Math.sin(d4);
        double d9 = this.m * d8;
        double d10 = Math.sin(d5);
        double d11 = this.m * d10;
        double d12 = Math.cos(d4) / Math.sqrt(1.0 - d9 * d9);
        double d13 = Math.cos(d5) / Math.sqrt(1.0 - d11 * d11);
        double d14 = 1.0 + d6;
        double d15 = d14 != 0.0 && (d2 = 1.0 - d7) != 0.0 ? Math.sqrt((1.0 - d6) / d14 * Math.pow((1.0 + d7) / d2, this.m)) : 1.0E9;
        d14 = 1.0 + d8;
        double d16 = d14 != 0.0 && (d2 = 1.0 - d9) != 0.0 ? Math.sqrt((1.0 - d8) / d14 * Math.pow((1.0 + d9) / d2, this.m)) : 1.0E9;
        d14 = 1.0 + d10;
        double d17 = d14 != 0.0 && (d2 = 1.0 - d11) != 0.0 ? Math.sqrt((1.0 - d10) / d14 * Math.pow((1.0 + d11) / d2, this.m)) : 1.0E9;
        this.o = d12 != 0.0 && d13 != 0.0 && d16 != 0.0 && d17 != 0.0 && (d14 = Math.log(d16) - Math.log(d17)) != 0.0 ? (Math.log(d12) - Math.log(d13)) / d14 : d8;
        if (this.o == 0.0) {
            this.o = 1.0;
        }
        this.p = 1.0 / this.o;
        this.w = this.o < 0.0;
        d14 = this.w && d16 == 0.0 ? this.o * 1.0E9 : this.o * Math.pow(d16, this.o);
        double d18 = d14 != 0.0 ? d12 / d14 : 1.0;
        this.q = this.m_Ellipsoid.a() * d18;
        this.r = this.w && d15 == 0.0 ? this.q * 1.0E9 : this.q * Math.pow(d15, this.o);
        double d19 = this.m_Ellipsoid.e2();
        double d20 = d19 * d19;
        double d21 = d19 * d20;
        double d22 = d20 * d20;
        double d23 = d19 / 2.0 + 5.0 * d20 / 24.0 + d21 / 12.0 + 13.0 * d22 / 360.0;
        double d24 = 7.0 * d20 / 48.0 + 29.0 * d21 / 240.0 + 811.0 * d22 / 11520.0;
        double d25 = 7.0 * d21 / 120.0 + 81.0 * d22 / 1120.0;
        double d26 = 4279.0 * d22 / 161280.0;
        this.s = d23 - d25;
        this.t = 2.0 * d24 - 4.0 * d26;
        this.u = 4.0 * d25;
        this.v = 8.0 * d26;
    }

    public double getScaleFactor(double d2, double d3) {
        double d4 = AngularUnit.radian.convertClip(d3, this.m_AngularUnit, -89.9999, 89.9999);
        double d5 = Math.sin(d4);
        double d6 = this.m * d5;
        double d7 = Math.cos(d4) / Math.sqrt(1.0 - d6 * d6);
        double d8 = 1.0 + d5;
        double d9 = d8 == 0.0 ? 1.0E9 : Math.sqrt((1.0 - d5) / d8 * Math.pow((1.0 + d6) / (1.0 - d6), this.m));
        double d10 = this.w && d9 == 0.0 ? this.q * 1.0E9 : this.q * Math.pow(d9, this.o);
        double d11 = d10 * this.o / (this.m_Ellipsoid.a() * d7);
        return d11;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6 = AngularUnit.radian.convertClipX(dArray[n++], this.m_AngularUnit);
            if ((d5 = 1.0 + (d4 = Math.sin(d3 = AngularUnit.radian.convertClipY(dArray[n++], this.m_AngularUnit)))) == 0.0) {
                d2 = 1.0E9;
            } else {
                double d7 = this.m * d4;
                d2 = Math.sqrt((1.0 - d4) / d5 * Math.pow((1.0 + d7) / (1.0 - d7), this.m));
            }
            double d8 = this.w && d2 == 0.0 ? this.q * 1.0E9 : this.q * Math.pow(d2, this.o);
            double d9 = this.o * (d6 - this.n);
            if (this.l == 19) {
                d9 -= AngularUnit.radian.convert(29.2985, AngularUnit.second);
            }
            double d10 = d8 * Math.sin(d9);
            double d11 = this.r - d8 * Math.cos(d9);
            dArray2[n2++] = this.m_LinearUnit.convert(d10, this.m_EllipsoidUnit) + this.d;
            dArray2[n2++] = this.m_LinearUnit.convert(d11, this.m_EllipsoidUnit) + this.e;
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3;
            double d4 = this.m_EllipsoidUnit.convert(dArray[n++] - this.d, this.m_LinearUnit);
            double d5 = this.m_EllipsoidUnit.convert(dArray[n++] - this.e, this.m_LinearUnit);
            double d6 = this.r - d5;
            double d7 = Math.sqrt(d4 * d4 + d6 * d6);
            if (this.w) {
                d7 = -d7;
                d4 = -d4;
                d6 = -d6;
            }
            double d8 = d3 = d4 != 0.0 || d6 != 0.0 ? Math.atan2(d4, d6) : 0.0;
            if (this.l == 19) {
                d3 += AngularUnit.radian.convert(29.2985, AngularUnit.second);
            }
            double d9 = d7 / this.q;
            if (this.w && d9 == 0.0) {
                d2 = -1.5707963267948966;
            } else {
                double d10 = Math.pow(d9, this.p);
                d2 = 1.5707963267948966 - 2.0 * Math.atan(d10);
            }
            d4 = d3 / this.o + this.n;
            double d11 = 2.0 * d2;
            double d12 = Math.cos(d11);
            d5 = d2 + Math.sin(d11) * (this.s + d12 * (this.t + d12 * (this.u + d12 * this.v)));
            dArray2[n2++] = this.m_AngularUnit.convert(d4, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d5, AngularUnit.radian);
        }
    }
}

