/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.coordsys.SpatialReferenceInfo;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;

public class Mercator
extends MIProProjection {
    double a;
    double b;
    double c;
    double d;
    double e;
    double f;
    double g;
    double h;
    private Angle i;
    private Angle j;
    private boolean k;

    public Mercator() {
        super("Mercator");
    }

    public Mercator(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, double d2) {
        this(angularUnit, linearUnit, ellipsoid, d2, 0.0);
    }

    public Mercator(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, double d2, double d3) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.h = d2;
        this.j = new Angle(d3, angularUnit);
        this.k = this.j.getScalarValue(AngularUnit.degree) != 0.0;
        this.i = new Angle(this.h, angularUnit);
        if (this.k) {
            ((SpatialReferenceInfo)this).e = "Regional Mercator";
        }
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        this.init(angularUnit, linearUnit, ellipsoid);
        this.h = measuredQuantityArray[0].getScalarValue(angularUnit);
        this.i = new Angle(this.h, angularUnit);
        if (measuredQuantityArray.length == 2) {
            this.j = new Angle(measuredQuantityArray[1].getScalarValue(angularUnit), angularUnit);
            ((SpatialReferenceInfo)this).e = "Regional Mercator";
        } else {
            this.j = new Angle(angularUnit.convert(0.0, AngularUnit.degree), angularUnit);
            ((SpatialReferenceInfo)this).e = "Mercator";
        }
        this.k = this.j.getScalarValue(AngularUnit.degree) != 0.0;
        this.a();
    }

    public String getWellKnownText() {
        String string = "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Central_Meridian\"," + this.h + "]";
        if (this.k) {
            string = string + ", PARAMETER[\"Standard_Parallel_1\"," + this.j.getScalarValue(AngularUnit.degree) + "]";
        }
        return string;
    }

    public boolean equals(Projection projection) {
        if (projection instanceof Mercator) {
            Mercator mercator = (Mercator)projection;
            return super.equals(mercator) && this.h == mercator.h && this.j.getScalarValue() == mercator.j.getScalarValue();
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof Mercator) {
            Mercator mercator = (Mercator)projection;
            boolean bl = super.equivalent(mercator) && this.i.equivalent(mercator.i) && this.j.equivalent(mercator.j);
            return bl;
        }
        return false;
    }

    public int getType() {
        if (this.k) {
            return 26;
        }
        return 10;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        if (this.k) {
            return new double[]{angularUnit.convert(this.h, this.m_AngularUnit), this.j.getScalarValue(angularUnit)};
        }
        return new double[]{angularUnit.convert(this.h, this.m_AngularUnit)};
    }

    void a() {
        this.b = this.m_Ellipsoid.a() / 2.0;
        this.a = AngularUnit.radian.convertClipX(this.h, this.m_AngularUnit);
        double d2 = this.m_Ellipsoid.e2() * this.m_Ellipsoid.e2();
        double d3 = this.m_Ellipsoid.e2() * d2;
        double d4 = d2 * d2;
        double d5 = this.m_Ellipsoid.e2() / 2.0 + 5.0 * d2 / 24.0 + d3 / 12.0 + 13.0 * d4 / 360.0;
        double d6 = 7.0 * d2 / 48.0 + 29.0 * d3 / 240.0 + 811.0 * d4 / 11520.0;
        double d7 = 7.0 * d3 / 120.0 + 81.0 * d4 / 1120.0;
        double d8 = 4279.0 * d4 / 161280.0;
        this.c = d5 - d7;
        this.d = 2.0 * d6 - 4.0 * d8;
        this.e = 4.0 * d7;
        this.f = 8.0 * d8;
        if (!this.k) {
            this.g = 1.0;
        } else {
            double d9 = AngularUnit.radian.convertClip(this.j.getScalarValue(), this.j.getAngularUnit(), -90.0, 90.0);
            double d10 = Math.sin(d9);
            this.g = Math.cos(d9) / Math.sqrt(1.0 - this.m_Ellipsoid.e2() * d10 * d10);
        }
    }

    public double getScaleFactor(double d2, double d3) {
        double d4;
        double d5 = AngularUnit.radian.convertClipY(d3, this.m_AngularUnit);
        double d6 = Math.cos(d5);
        if (d6 == 0.0) {
            d4 = 1.0E9;
        } else {
            double d7 = this.m_Ellipsoid.e() * Math.sin(d5);
            d4 = Math.sqrt(1.0 - d7 * d7) / d6;
        }
        return d4;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = AngularUnit.radian.convert(dArray[n++], this.m_AngularUnit);
            double d3 = AngularUnit.radian.convert(dArray[n++], this.m_AngularUnit);
            d2 = this.m_Ellipsoid.a() * (d2 - this.a) * this.g;
            double d4 = Math.sin(d3);
            double d5 = 1.0 + d4;
            if (d5 == 0.0) {
                d3 = -1.0E9;
            } else {
                double d6 = 1.0 - d4;
                if (d6 == 0.0) {
                    d3 = 1.0E9;
                } else {
                    double d7 = this.m_Ellipsoid.e() * d4;
                    d3 = this.b * Math.log(d5 / d6 * Math.pow((1.0 - d7) / (1.0 + d7), this.m_Ellipsoid.e())) * this.g;
                }
            }
            dArray2[n2++] = this.m_LinearUnit.convert(d2, this.m_EllipsoidUnit);
            dArray2[n2++] = this.m_LinearUnit.convert(d3, this.m_EllipsoidUnit);
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d3 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            d2 = d2 / this.g / this.m_Ellipsoid.a() + this.a;
            double d4 = -(d3 /= this.g) / this.m_Ellipsoid.a();
            double d5 = d4 < -1000.0 ? 1.5707963267948966 : (d4 > 1000.0 ? -1.5707963267948966 : 1.5707963267948966 - 2.0 * Math.atan(Math.exp(d4)));
            double d6 = 2.0 * d5;
            double d7 = Math.cos(d6);
            d3 = d5 + Math.sin(d6) * (this.c + d7 * (this.d + d7 * (this.e + d7 * this.f)));
            dArray2[n2++] = this.m_AngularUnit.convert(d2, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d3, AngularUnit.radian);
        }
    }
}

