/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.MathUtil;

public class Mollweide
extends MIProProjection {
    private double a;
    private Angle b;
    private double c;
    private double d;
    private double e;
    private double f;

    public Mollweide() {
        super("Mollweide");
    }

    public Mollweide(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, double d2) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = d2;
        this.b = new Angle(this.a, angularUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = measuredQuantityArray[0].getScalarValue(angularUnit);
        this.b = new Angle(this.a, angularUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Central_Meridian\"," + this.a + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof Mollweide) {
            Mollweide mollweide = (Mollweide)projection;
            return super.equals(mollweide) && this.a == mollweide.a;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof Mollweide) {
            Mollweide mollweide = (Mollweide)projection;
            boolean bl = super.equivalent(mollweide) && this.b.equivalent(mollweide.b);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 13;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a, this.m_AngularUnit)};
    }

    private void a() {
        this.c = this.m_Ellipsoid.a();
        this.e = Math.sqrt(8.0) / Math.PI * this.c;
        this.f = Math.sqrt(2.0) * this.c;
        this.d = AngularUnit.radian.convertClipX(this.a, this.m_AngularUnit);
    }

    public double getScaleFactor(double d2, double d3) {
        double d4;
        double d5 = AngularUnit.radian.convertClipY(d3, this.m_AngularUnit);
        double d6 = Math.cos(d5);
        if (d6 == 0.0) {
            d4 = 1.0E9;
        } else {
            double d7;
            double d8 = Math.PI * Math.sin(d5);
            double d9 = d5;
            while (!((d7 = (d9 + Math.sin(d9) - d8) / (1.0 + Math.cos(d9))) > -1.0E-7) || !(d7 < 1.0E-7)) {
                d9 -= d7;
            }
            double d10 = d9 / 2.0;
            d4 = this.e * Math.cos(d10) / (this.c * d6);
        }
        return d4;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3 = AngularUnit.radian.convertClipX(dArray[n++], this.m_AngularUnit);
            double d4 = AngularUnit.radian.convertClipY(dArray[n++], this.m_AngularUnit);
            double d5 = d3;
            double d6 = d4;
            double d7 = Math.PI * Math.sin(d6);
            double d8 = d6;
            while (!((d2 = (d8 + Math.sin(d8) - d7) / (1.0 + Math.cos(d8))) > -1.0E-7) || !(d2 < 1.0E-7)) {
                d8 -= d2;
            }
            double d9 = d8 / 2.0;
            d3 = this.e * (d5 - this.d) * Math.cos(d9);
            d4 = this.f * Math.sin(d9);
            dArray2[n2++] = this.m_LinearUnit.convert(d3, this.m_EllipsoidUnit);
            dArray2[n2++] = this.m_LinearUnit.convert(d4, this.m_EllipsoidUnit);
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d3 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d4 = d3 / this.f;
            double d5 = Math.asin(MathUtil.clip((double)d4, (double)-1.0, (double)1.0));
            d4 = d5 * 2.0;
            d4 = (d4 + Math.sin(d4)) / Math.PI;
            d3 = Math.asin(MathUtil.clip((double)d4, (double)-1.0, (double)1.0));
            d4 = this.e * Math.cos(d5);
            d2 = d4 != 0.0 ? this.d + d2 / d4 : this.d;
            dArray2[n2++] = this.m_AngularUnit.convert(d2, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d3, AngularUnit.radian);
        }
    }
}

