/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.Distance;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.ComplexNumber;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.DoubleRect;
import com.mapinfo.util.MathUtil;

public class NewZealandMapGrid
extends MIProProjection {
    private DoublePoint a;
    private double b;
    private double c;
    private Angle d;
    private Angle e;
    private Distance f;
    private Distance g;
    private double h;
    private double i;
    private DoubleRect j;
    private DoubleRect k;
    ComplexNumber l = new ComplexNumber();
    ComplexNumber m = new ComplexNumber();
    ComplexNumber n = new ComplexNumber();
    ComplexNumber o = new ComplexNumber();
    ComplexNumber p = new ComplexNumber();
    ComplexNumber q = new ComplexNumber();
    ComplexNumber r = new ComplexNumber();
    private static final double[] s = new double[]{0.0, 0.6399175073, -0.1358797613, 0.063294409, -0.02526853, 0.0117879, -0.0055161, 0.0026906, -0.001333, 6.7E-4, -3.4E-4};
    private static final double[] t = new double[]{0.0, 1.5627014243, 0.5185406398, -0.03333098, -0.1052906, -0.0368594, 0.007317, 0.0122, 0.00394, -0.0013};
    private static final double[] u = new double[]{1.3230946238, -0.8680281742, 0.6629999306, -0.14371346, 0.05551665, -0.00729966, 0.001708, -2.1E-4};
    private static final double[][] v = new double[][]{{0.0, 0.0}, {0.7557853228, 0.0}, {0.249204646, 0.003371507}, {-0.001541739, 0.04105856}, {-0.10162907, 0.01727609}, {-0.26623489, -0.36249218}, {-0.6870983, -1.1651967}};
    private static final double[][] w = new double[][]{{0.0, 0.0}, {1.3231270439, 0.0}, {-0.577245789, -0.007809598}, {0.508307513, -0.112208952}, {-0.15094762, 0.18200602}, {1.01418179, 1.64497696}, {1.9660549, 2.5127645}};

    public NewZealandMapGrid() {
        super("New Zealand Map Grid");
    }

    public NewZealandMapGrid(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, DoublePoint doublePoint, double d2, double d3) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = new DoublePoint(doublePoint);
        this.b = d2;
        this.c = d3;
        this.d = new Angle(doublePoint.x, angularUnit);
        this.e = new Angle(doublePoint.y, angularUnit);
        this.f = new Distance(d2, linearUnit);
        this.g = new Distance(d3, linearUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        DoublePoint doublePoint;
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = doublePoint = new DoublePoint(measuredQuantityArray[0].getScalarValue(angularUnit), measuredQuantityArray[1].getScalarValue(angularUnit));
        this.b = measuredQuantityArray[2].getScalarValue(linearUnit);
        this.c = measuredQuantityArray[3].getScalarValue(linearUnit);
        this.d = new Angle(doublePoint.x, angularUnit);
        this.e = new Angle(doublePoint.y, angularUnit);
        this.f = new Distance(this.b, linearUnit);
        this.g = new Distance(this.c, linearUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Central_Meridian\"," + this.a.x + "]," + "PARAMETER[\"Latitude_of_Origin\"," + this.a.y + "]," + "PARAMETER[\"False_Easting\"," + this.b + "]," + "PARAMETER[\"False_Northing\"," + this.c + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof NewZealandMapGrid) {
            NewZealandMapGrid newZealandMapGrid = (NewZealandMapGrid)projection;
            return super.equals(newZealandMapGrid) && this.a.equals(newZealandMapGrid.a) && this.b == newZealandMapGrid.b && this.c == newZealandMapGrid.c;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof NewZealandMapGrid) {
            NewZealandMapGrid newZealandMapGrid = (NewZealandMapGrid)projection;
            boolean bl = super.equivalent(newZealandMapGrid) && this.d.equivalent(newZealandMapGrid.d) && this.e.equivalent(newZealandMapGrid.e) && this.f.equivalent(newZealandMapGrid.f) && this.g.equivalent(newZealandMapGrid.g);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 18;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a.x, this.m_AngularUnit), angularUnit.convert(this.a.y, this.m_AngularUnit), linearUnit.convert(this.b, this.m_LinearUnit), linearUnit.convert(this.c, this.m_LinearUnit)};
    }

    private void a() {
        double d2;
        double d3 = AngularUnit.degree.convertClipX(this.a.x, this.m_AngularUnit);
        this.h = d2 = AngularUnit.degree.convertClipY(this.a.y, this.m_AngularUnit);
        this.i = AngularUnit.radian.convertClipX(this.a.x, this.m_AngularUnit);
        this.j = new DoubleRect(d3 - 15.0, d2 - 15.0, d3 + 15.0, d2 + 15.0);
        this.m_AngularUnit.convert(this.j, AngularUnit.degree);
        double[] dArray = new double[8];
        this.j.get(dArray, 4);
        this.forward(dArray, 0, dArray, 0, 4);
        this.k = new DoubleRect(dArray, 4);
    }

    public synchronized double getScaleFactor(double d2, double d3) {
        d2 = MathUtil.clip((double)d2, (double)this.j.xmin, (double)this.j.xmax);
        d3 = MathUtil.clip((double)d3, (double)this.j.ymin, (double)this.j.ymax);
        double d4 = AngularUnit.degree.convert(d3, this.m_AngularUnit);
        double d5 = (d4 - this.h) * 0.036;
        double d6 = AngularUnit.radian.convert(d2, this.m_AngularUnit);
        double d7 = d6 - this.i;
        double d8 = 1.0;
        double d9 = s[0];
        int n = 1;
        while (n < s.length) {
            d9 += s[n] * (d8 *= d5);
            ++n;
        }
        this.l.set(d9, d7);
        this.m.set(1.0, 0.0);
        this.o.set(v[1][0], v[1][1]);
        n = 1;
        while (n < v.length - 1) {
            this.m.mult(this.l);
            this.n.set(v[n + 1][0], v[n + 1][1]);
            this.n.mult(this.m);
            this.n.mult((double)(n + 1));
            this.o.add(this.n);
            ++n;
        }
        this.o.mult(this.m_Ellipsoid.a());
        double d10 = 1.0;
        double d11 = u[0];
        n = 1;
        while (n < u.length) {
            d11 += u[n] * (d10 *= d9);
            ++n;
        }
        double d12 = d11 * this.o.norm() / this.m_Ellipsoid.a();
        return d12;
    }

    public synchronized void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = MathUtil.clip((double)dArray[n++], (double)this.j.xmin, (double)this.j.xmax);
            double d3 = MathUtil.clip((double)dArray[n++], (double)this.j.ymin, (double)this.j.ymax);
            double d4 = AngularUnit.degree.convert(d3, this.m_AngularUnit);
            double d5 = (d4 - this.h) * 0.036;
            double d6 = AngularUnit.radian.convert(d2, this.m_AngularUnit);
            double d7 = d6 - this.i;
            double d8 = 1.0;
            double d9 = s[0];
            int n4 = 1;
            while (n4 < s.length) {
                d9 += s[n4] * (d8 *= d5);
                ++n4;
            }
            this.l.set(d9, d7);
            this.m.set(1.0, 0.0);
            this.p.set(v[0][0], v[0][1]);
            n4 = 1;
            while (n4 < v.length) {
                this.m.mult(this.l);
                this.n.set(v[n4][0], v[n4][1]);
                this.n.mult(this.m);
                this.p.add(this.n);
                ++n4;
            }
            this.p.mult(this.m_Ellipsoid.a());
            d3 = this.p.getReal();
            d2 = this.p.getImaginary();
            dArray2[n2++] = this.m_LinearUnit.convert(d2, this.m_EllipsoidUnit) + this.b;
            dArray2[n2++] = this.m_LinearUnit.convert(d3, this.m_EllipsoidUnit) + this.c;
        }
    }

    public synchronized void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = MathUtil.clip((double)dArray[n++], (double)this.k.xmin, (double)this.k.xmax);
            double d3 = MathUtil.clip((double)dArray[n++], (double)this.k.ymin, (double)this.k.ymax);
            d2 = this.m_EllipsoidUnit.convert(d2 - this.b, this.m_LinearUnit);
            d3 = this.m_EllipsoidUnit.convert(d3 - this.c, this.m_LinearUnit);
            this.p.set(d3 / this.m_Ellipsoid.a(), d2 / this.m_Ellipsoid.a());
            this.q.set(1.0, 0.0);
            this.l.set(w[0][0], w[0][1]);
            int n4 = 1;
            while (n4 < w.length) {
                this.q.mult(this.p);
                this.n.set(w[n4][0], w[n4][1]);
                this.n.mult(this.q);
                this.l.add(this.n);
                ++n4;
            }
            this.m.set(1.0, 0.0);
            this.r.set(v[1][0], v[1][1]);
            n4 = 1;
            while (n4 < v.length) {
                this.m.mult(this.l);
                if (n4 > 1) {
                    this.n.set(v[n4][0], v[n4][1]);
                    this.n.mult(this.m);
                    this.n.mult((double)(n4 - 1));
                    this.p.add(this.n);
                }
                if (n4 + 1 < v.length) {
                    this.n.set(v[n4 + 1][0], v[n4 + 1][1]);
                    this.n.mult(this.m);
                    this.n.mult((double)(n4 + 1));
                    this.r.add(this.n);
                }
                ++n4;
            }
            this.p.div(this.r);
            double d4 = this.p.getReal();
            double d5 = this.p.getImaginary();
            double d6 = 1.0;
            double d7 = t[0];
            n4 = 1;
            while (n4 < t.length) {
                d7 += t[n4] * (d6 *= d4);
                ++n4;
            }
            d2 = this.i + d5;
            d3 = this.h + d7 / 0.036;
            dArray2[n2++] = this.m_AngularUnit.convert(d2, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d3, AngularUnit.degree);
        }
    }
}

