/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.Distance;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.DoublePoint;

public class Polyconic
extends MIProProjection {
    private DoublePoint a;
    private double b;
    private double c;
    private Angle d;
    private Angle e;
    private Distance f;
    private Distance g;
    private double h;
    private double i;
    private double j;
    private double k;
    private double l;
    private double m;
    private double n;
    private double o;
    private double p;
    private double q;

    public Polyconic() {
        super("Polyconic");
    }

    public Polyconic(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, DoublePoint doublePoint, double d2, double d3) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = new DoublePoint(doublePoint);
        this.b = d2;
        this.c = d3;
        this.d = new Angle(doublePoint.x, angularUnit);
        this.e = new Angle(doublePoint.y, angularUnit);
        this.f = new Distance(this.b, linearUnit);
        this.g = new Distance(this.c, linearUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        DoublePoint doublePoint;
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = doublePoint = new DoublePoint(measuredQuantityArray[0].getScalarValue(angularUnit), measuredQuantityArray[1].getScalarValue(angularUnit));
        this.b = measuredQuantityArray[2].getScalarValue(linearUnit);
        this.c = measuredQuantityArray[3].getScalarValue(linearUnit);
        this.d = new Angle(doublePoint.x, angularUnit);
        this.e = new Angle(doublePoint.y, angularUnit);
        this.f = new Distance(this.b, linearUnit);
        this.g = new Distance(this.c, linearUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Longitude_of_Center\"," + this.a.x + "]," + "PARAMETER[\"Latitude_of_Center\"," + this.a.y + "]," + "PARAMETER[\"False_Easting\"," + this.b + "]," + "PARAMETER[\"False_Northing\"," + this.c + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof Polyconic) {
            Polyconic polyconic = (Polyconic)projection;
            return super.equals(polyconic) && this.a.equals(polyconic.a) && this.b == polyconic.b && this.c == polyconic.c;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof Polyconic) {
            Polyconic polyconic = (Polyconic)projection;
            boolean bl = super.equivalent(polyconic) && this.d.equivalent(polyconic.d) && this.e.equivalent(polyconic.e) && this.f.equivalent(polyconic.f) && this.g.equivalent(polyconic.g);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 27;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a.x, this.m_AngularUnit), angularUnit.convert(this.a.y, this.m_AngularUnit), linearUnit.convert(this.b, this.m_LinearUnit), linearUnit.convert(this.c, this.m_LinearUnit)};
    }

    private void a() {
        this.h = AngularUnit.radian.convertClip(this.d.getScalarValue(), this.d.getAngularUnit(), -360.0, 360.0);
        double d2 = AngularUnit.radian.convertClip(this.e.getScalarValue(), this.e.getAngularUnit(), -90.0, 90.0);
        double d3 = this.m_Ellipsoid.e2() * this.m_Ellipsoid.e2();
        double d4 = this.m_Ellipsoid.e2() * d3;
        double d5 = this.m_Ellipsoid.getSemiMajorAxis() * -(3.0 * this.m_Ellipsoid.e2() / 8.0 + 3.0 * d3 / 32.0 + 45.0 * d4 / 1024.0);
        double d6 = this.m_Ellipsoid.getSemiMajorAxis() * (15.0 * d3 / 256.0 + 45.0 * d4 / 1024.0);
        double d7 = this.m_Ellipsoid.getSemiMajorAxis() * -35.0 * d4 / 3072.0;
        this.i = this.m_Ellipsoid.getSemiMajorAxis() * (1.0 - this.m_Ellipsoid.e2() / 4.0 - 3.0 * d3 / 64.0 - 5.0 * d4 / 256.0);
        this.j = d5 - d7;
        this.k = 2.0 * d6;
        this.l = 4.0 * d7;
        d5 = 1.0 - this.m_Ellipsoid.e2() / 4.0 - 3.0 * d3 / 64.0 - 5.0 * d4 / 256.0;
        d6 = -2.0 * (3.0 * this.m_Ellipsoid.e2() / 8.0 + 3.0 * d3 / 32.0 + 45.0 * d4 / 1024.0);
        d7 = 4.0 * (15.0 * d3 / 256.0 + 45.0 * d4 / 1024.0);
        double d8 = -6.0 * (35.0 * d4 / 3072.0);
        this.m = d5 - d7;
        this.n = d6 - 3.0 * d8;
        this.o = 2.0 * d7;
        this.p = 4.0 * d8;
        double d9 = d2 * 2.0;
        double d10 = Math.cos(d9);
        this.q = this.i * d2 + Math.sin(d9) * (this.j + d10 * (this.k + d10 * this.l));
    }

    public double getScaleFactor(double d2, double d3) {
        return 1.0;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = dArray[n++] - this.d.getScalarValue(AngularUnit.degree);
            double d3 = dArray[n++];
            d2 = AngularUnit.radian.convertClip(d2, AngularUnit.degree, -180.0, 180.0);
            d3 = AngularUnit.radian.convertClip(d3, AngularUnit.degree, -90.0, 90.0);
            double d4 = d2;
            double d5 = d3;
            if (0.0 == d5) {
                d2 = this.m_Ellipsoid.getSemiMajorAxis() * d4;
                d3 = -this.q;
            } else {
                double d6 = d4 * Math.sin(d5);
                double d7 = d5 * 2.0;
                double d8 = Math.cos(d7);
                double d9 = this.i * d5 + Math.sin(d7) * (this.j + d8 * (this.k + d8 * this.l));
                double d10 = Math.sin(d5);
                double d11 = this.m_Ellipsoid.getSemiMajorAxis() / Math.sqrt(1.0 - this.m_Ellipsoid.e2() * d10 * d10);
                d2 = d11 * Polyconic.a(d5) * Math.sin(d6);
                d3 = d9 - this.q + d11 * Polyconic.a(d5) * (1.0 - Math.cos(d6));
            }
            d2 = this.m_LinearUnit.convert(d2, this.m_Ellipsoid.getAxisUnit());
            d3 = this.m_LinearUnit.convert(d3, this.m_Ellipsoid.getAxisUnit());
            dArray2[n2++] = d2 += this.f.getScalarValue(this.m_LinearUnit);
            dArray2[n2++] = d3 += this.g.getScalarValue(this.m_LinearUnit);
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        double d2 = 0.0;
        double d3 = 0.0;
        while (n3-- > 0) {
            double d4;
            double d5 = this.m_EllipsoidUnit.convert(dArray[n++] - this.b, this.m_LinearUnit);
            if ((d4 = this.m_EllipsoidUnit.convert(dArray[n++] - this.c, this.m_LinearUnit)) == -this.q) {
                d5 = d5 / this.m_Ellipsoid.getSemiMajorAxis() + this.h;
                d4 = 0.0;
            } else {
                boolean bl = false;
                double d6 = (this.q + d4) / this.m_Ellipsoid.getSemiMajorAxis();
                while (!bl) {
                    double d7 = d5 * d5 / (this.m_Ellipsoid.getSemiMajorAxis() * this.m_Ellipsoid.getSemiMajorAxis()) + d6 * d6;
                    double d8 = d6;
                    int n4 = 0;
                    while (!bl && n4 < 100) {
                        double d9 = Math.sin(d8);
                        d2 = Math.sqrt(1.0 - this.m_Ellipsoid.e2() * d9 * d9) * Math.tan(d8);
                        double d10 = d8 * 2.0;
                        double d11 = Math.cos(d10);
                        double d12 = this.i * d8 + Math.sin(d10) * (this.j + d11 * (this.k + d11 * this.l));
                        double d13 = d12 / this.m_Ellipsoid.getSemiMajorAxis();
                        double d14 = d13 * d13;
                        double d15 = this.m + d11 * (this.n + d11 * (this.o + d11 * this.p));
                        double d16 = Math.sin(d10);
                        d3 = d8 - (d6 * (d2 * d13 + 1.0) - d13 - 0.5 * (d14 + d7) * d2) / (this.m_Ellipsoid.e2() * d16 * (d14 + d7 - 2.0 * d6 * d13) / 4.0 * d2 + (d6 - d13) * (d2 * d15 - 2.0 / d16) - d15);
                        double d17 = d3 - d8;
                        if (d17 > -1.0E-7 && d17 < 1.0E-7) {
                            bl = true;
                        }
                        d8 = d3;
                        ++n4;
                    }
                    if (bl) continue;
                    double d18 = d5 = d5 < 0.0 ? d5 + 100.0 : d5 - 100.0;
                }
                d4 = d3;
                d5 = Math.asin(d5 * d2 / this.m_Ellipsoid.getSemiMajorAxis()) / Math.sin(d3) + this.h;
            }
            dArray2[n2++] = this.m_AngularUnit.convertClipX(d5, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convertClipY(d4, AngularUnit.radian);
        }
    }

    private static double a(double d2) {
        return 1.0 / Math.tan(d2);
    }
}

