/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;

public class Robinson
extends MIProProjection {
    private double a;
    private Angle b;
    private double c;
    private double d;
    private double e;
    private static final double[][] f = new double[][]{{1.0, 0.0}, {0.9986, 0.062}, {0.9954, 0.124}, {0.99, 0.186}, {0.9822, 0.248}, {0.973, 0.31}, {0.96, 0.372}, {0.9427, 0.434}, {0.9216, 0.4958}, {0.8962, 0.5571}, {0.8679, 0.6176}, {0.835, 0.6769}, {0.7986, 0.7346}, {0.7597, 0.7903}, {0.7186, 0.8435}, {0.6732, 0.8936}, {0.6213, 0.9394}, {0.5722, 0.9761}, {0.5322, 1.0}, {0.5322, 1.0}};

    public Robinson() {
        super("Robinson");
    }

    public Robinson(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, double d2) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = d2;
        this.b = new Angle(this.a, angularUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = measuredQuantityArray[0].getScalarValue(angularUnit);
        this.b = new Angle(this.a, angularUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Central_Meridian\"," + this.a + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof Robinson) {
            Robinson robinson = (Robinson)projection;
            return super.equals(robinson) && this.a == robinson.a;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof Robinson) {
            Robinson robinson = (Robinson)projection;
            boolean bl = super.equivalent(robinson) && this.b.equivalent(robinson.b);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 12;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a, this.m_AngularUnit)};
    }

    private void a() {
        double d2 = this.m_Ellipsoid.a();
        this.d = 0.8487 * d2;
        this.e = 1.3523 * d2;
        this.c = AngularUnit.radian.convertClipX(this.a, this.m_AngularUnit);
    }

    public double getScaleFactor(double d2, double d3) {
        double d4;
        double d5 = AngularUnit.degree.convertClipY(d3, this.m_AngularUnit);
        double d6 = Math.cos(AngularUnit.radian.convert(d5, AngularUnit.degree));
        if (d6 == 0.0) {
            d4 = 1.0E9;
        } else {
            double d7 = Math.abs(d5) / 5.0;
            int n = (int)d7;
            double d8 = d7 - (double)n;
            double d9 = f[n][0] + d8 * (f[n + 1][0] - f[n][0]);
            d4 = 0.8487 * d9 / d6;
        }
        return d4;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        AngularUnit angularUnit = AngularUnit.degree;
        AngularUnit angularUnit2 = AngularUnit.radian;
        AngularUnit angularUnit3 = this.m_AngularUnit;
        LinearUnit linearUnit = this.m_LinearUnit;
        LinearUnit linearUnit2 = this.m_EllipsoidUnit;
        double[][] dArray3 = f;
        double d2 = this.d;
        double d3 = this.e;
        while (n3-- > 0) {
            double d4 = angularUnit2.convertClipX(dArray[n++], angularUnit3);
            double d5 = angularUnit.convertClipY(dArray[n++], angularUnit3);
            double d6 = Math.abs(d5) / 5.0;
            int n4 = (int)d6;
            double d7 = d6 - (double)n4;
            double d8 = dArray3[n4][0];
            double d9 = dArray3[n4][1];
            double d10 = dArray3[n4 + 1][0];
            double d11 = dArray3[n4 + 1][1];
            double d12 = d2 * (d8 + d7 * (d10 - d8)) * (d4 - this.c);
            double d13 = d3 * (d9 + d7 * (d11 - d9));
            if (d5 < 0.0) {
                d13 = -d13;
            }
            dArray2[n2++] = linearUnit.convert(d12, linearUnit2);
            dArray2[n2++] = linearUnit.convert(d13, linearUnit2);
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3;
            double d4;
            double d5 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d6 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d7 = Math.abs(d6 / this.e);
            if (d4 >= 1.0) {
                d3 = 90.0;
                d2 = f[18][0];
            } else {
                int n4 = 0;
                int n5 = 0;
                while (n5 < 19) {
                    if (f[n5 + 1][1] > d7) {
                        n4 = n5;
                        break;
                    }
                    ++n5;
                }
                double d8 = (d7 - f[n4][1]) / (f[n4 + 1][1] - f[n4][1]);
                d3 = ((double)n4 + d8) * 5.0;
                d2 = f[n4][0] + d8 * (f[n4 + 1][0] - f[n4][0]);
            }
            d5 = this.m_AngularUnit.convertClipX(d5 / (d2 * this.d) + this.c, AngularUnit.radian);
            d6 = this.m_AngularUnit.convert(d6 < 0.0 ? -d3 : d3, AngularUnit.degree);
            dArray2[n2++] = d5;
            dArray2[n2++] = d6;
        }
    }
}

