/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.MathUtil;

public class Sinusoidal
extends MIProProjection {
    private double a;
    private Angle b;
    private double c;
    private double d;

    public Sinusoidal() {
        super("Sinusoidal");
    }

    public Sinusoidal(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, double d2) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = d2;
        this.b = new Angle(this.a, angularUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = measuredQuantityArray[0].getScalarValue(angularUnit);
        this.b = new Angle(this.a, angularUnit);
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Central_Meridian\"," + this.a + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof Sinusoidal) {
            Sinusoidal sinusoidal = (Sinusoidal)projection;
            return super.equals(sinusoidal) && this.a == sinusoidal.a;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof Sinusoidal) {
            Sinusoidal sinusoidal = (Sinusoidal)projection;
            boolean bl = super.equivalent(sinusoidal) && this.b.equivalent(sinusoidal.b);
            return bl;
        }
        return false;
    }

    public int getType() {
        return 16;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a, this.m_AngularUnit)};
    }

    private void a() {
        this.d = AngularUnit.radian.convertClipX(this.a, this.m_AngularUnit);
        this.c = this.m_Ellipsoid.a();
    }

    public double getScaleFactor(double d2, double d3) {
        return 1.0;
    }

    public void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = AngularUnit.radian.convertClipX(dArray[n++], this.m_AngularUnit);
            double d3 = AngularUnit.radian.convertClipY(dArray[n++], this.m_AngularUnit);
            d2 = this.c * (d2 - this.d) * Math.cos(d3);
            dArray2[n2++] = this.m_LinearUnit.convert(d2, this.m_EllipsoidUnit);
            dArray2[n2++] = this.m_LinearUnit.convert(d3 *= this.c, this.m_EllipsoidUnit);
        }
    }

    public void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            double d3 = this.m_EllipsoidUnit.convert(dArray[n++], this.m_LinearUnit);
            d3 = MathUtil.clip((double)d3, (double)-1.0E9, (double)1.0E9);
            double d4 = this.c * Math.cos(d3 /= this.c);
            d2 = d4 != 0.0 ? this.d + d2 / d4 : this.d;
            dArray2[n2++] = this.m_AngularUnit.convert(d2, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convert(d3, AngularUnit.radian);
        }
    }
}

